/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PatchReleaseNoteTask
extends Task {
    private String sourceFile = "";
    private String destFile = "";

    public PatchReleaseNoteTask() {
        this.setDescription("Wowza Media Systems Patch Release Notes Generator");
    }

    public void setSourcefile(String string) {
        this.sourceFile = string;
    }

    public void setDestfile(String string) {
        this.destFile = string;
    }

    public void execute() throws BuildException {
        File file = new File(this.sourceFile);
        File file2 = new File(this.destFile);
        if (!file.exists()) {
            throw new BuildException("File not found: " + this.sourceFile);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            String string = null;
            int n = 0;
            while (bufferedReader.ready()) {
                String string2 = bufferedReader.readLine();
                if (string != null) {
                    if (string.matches("={1,}") && string2.matches("Changes in.*")) {
                        if (n > 0) break;
                        ++n;
                    }
                    bufferedWriter.write(string);
                    bufferedWriter.write("\r\n");
                }
                string = string2;
            }
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            throw new BuildException("Error generating release notes", (Throwable)exception);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java -jar <jar> inFile outFile");
            System.exit(1);
        }
        PatchReleaseNoteTask patchReleaseNoteTask = new PatchReleaseNoteTask();
        patchReleaseNoteTask.setSourcefile(stringArray[0]);
        patchReleaseNoteTask.setDestfile(stringArray[1]);
        patchReleaseNoteTask.execute();
    }
}

