/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stats.entry;

import com.wowza.wms.rest.JodaTimeSerializer;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.stats.utils.StatsUtilsDateTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
public class StatsEntry
implements Serializable {
    protected static final long serialVersionUID = 7537953782297726455L;
    @JsonProperty
    @JsonSerialize(using=JodaTimeSerializer.class)
    protected DateTime dateTime = null;
    @JsonProperty
    protected int[] data = null;

    public StatsEntry() {
        this.dateTime = StatsUtilsDateTime.getNormalizedToSeconds();
    }

    public StatsEntry(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public int getFieldCount() {
        return this.data.length;
    }

    public void setFieldData(int[] nArray) {
        this.data = nArray;
    }

    public int[] getFieldData() {
        return (int[])this.data.clone();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatsEntry)) {
            return false;
        }
        StatsEntry statsEntry = (StatsEntry)object;
        if (this.data.length != statsEntry.data.length) {
            return false;
        }
        if (!this.dateTime.equals((Object)statsEntry.dateTime)) {
            return false;
        }
        int n = 0;
        while (n < this.data.length) {
            if (this.data[n] != statsEntry.data[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        String string = Severity.valueOf((int)(29 * 35), (String)"\u0004,8.(|\u00180+rx8#") + this.dateTime + Utils.lastIndexOf((String)"-Jndp(", (int)(48 + 93));
        int n = 0;
        while (n < this.data.length) {
            string = string + " " + this.data[n];
            ++n;
        }
        return string;
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

