/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stats.utils;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class StatsUtilsDateTime {
    static int a = 0;

    public static void setCurrentTime(DateTime dateTime) {
        DateTime dateTime2 = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        a = (int)(dateTime.getMillis() - dateTime2.getMillis());
    }

    public static DateTime getNow() {
        DateTime dateTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).plusMillis(a);
        return dateTime;
    }

    public static DateTime getNow(DateTimeZone dateTimeZone) {
        DateTime dateTime = DateTime.now((DateTimeZone)dateTimeZone).plusMillis(a);
        return dateTime;
    }

    public static DateTime getNormalizedToSeconds() {
        return StatsUtilsDateTime.getNormalizedToSeconds(StatsUtilsDateTime.getNow());
    }

    public static DateTime getNormalizedToSeconds(DateTime dateTime) {
        DateTime dateTime2 = new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), StatsUtilsDateTime.normalizeSeconds(dateTime), dateTime.getZone());
        return dateTime2;
    }

    public static DateTime getNormalizedToMinutes() {
        return StatsUtilsDateTime.getNormalizedToMinutes(StatsUtilsDateTime.getNow());
    }

    public static DateTime getNormalizedToMinutes(DateTime dateTime) {
        return new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), 0, dateTime.getZone());
    }

    public static DateTime getNormalizedToHours() {
        return StatsUtilsDateTime.getNormalizedToHours(StatsUtilsDateTime.getNow());
    }

    public static DateTime getNormalizedToHours(DateTime dateTime) {
        return new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), 0, 0, dateTime.getZone());
    }

    public static DateTime getNormalizedToDays() {
        return StatsUtilsDateTime.getNormalizedToDays(StatsUtilsDateTime.getNow());
    }

    public static DateTime getNormalizedToDays(DateTime dateTime) {
        return new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), 0, 0, 0, dateTime.getZone());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int normalizeSeconds(DateTime dateTime) {
        int n = dateTime.getSecondOfMinute();
        if (n == 0) return n;
        return n / 5 * 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int compare(DateTime dateTime, DateTime dateTime2) {
        int n = dateTime.getYear() - dateTime2.getYear();
        if (n == 0) {
            n += dateTime.getMonthOfYear() - dateTime2.getMonthOfYear();
        }
        if (n == 0) {
            n += dateTime.getDayOfMonth() - dateTime2.getDayOfMonth();
        }
        if (n == 0) {
            n += dateTime.getHourOfDay() - dateTime2.getHourOfDay();
        }
        if (n == 0) {
            n += dateTime.getMinuteOfHour() - dateTime2.getMinuteOfHour();
        }
        if (n != 0) return n;
        return n += dateTime.getSecondOfMinute() - dateTime2.getSecondOfMinute();
    }

    public static int getHoursOffsetFromUTC() {
        int n = DateTimeZone.getDefault().getOffset((ReadableInstant)DateTime.now());
        return n / 1000 / 60 / 60;
    }
}

