/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.FeatureInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.ParameterInfo;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;

public class MbeansDescriptorsDynamicMBeanSource
extends ModelerSource {
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    @Override
    public List loadDescriptors(Registry registry, String string, String string2, Object object) throws Exception {
        this.setRegistry(registry);
        this.setLocation(string);
        this.setType(string2);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            ManagedBean managedBean = this.createManagedBean(this.registry, null, this.source, this.type);
            if (managedBean == null) {
                return;
            }
            managedBean.setName(this.type);
            this.mbeans.add(managedBean);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MbeansDescriptorsDynamicMBeanSource.class).error("Error reading descriptors ", (Throwable)exception);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String string, Object object, String string2) {
        if (!(object instanceof DynamicMBean)) {
            return null;
        }
        DynamicMBean dynamicMBean = (DynamicMBean)object;
        ManagedBean managedBean = new ManagedBean();
        MBeanInfo mBeanInfo = dynamicMBean.getMBeanInfo();
        try {
            FeatureInfo featureInfo;
            Object object2;
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray[i];
                object2 = mBeanAttributeInfo.getName();
                featureInfo = new AttributeInfo();
                ((AttributeInfo)featureInfo).setName((String)object2);
                ((AttributeInfo)featureInfo).setType(mBeanAttributeInfo.getType());
                ((AttributeInfo)featureInfo).setReadable(mBeanAttributeInfo.isReadable());
                ((AttributeInfo)featureInfo).setWriteable(mBeanAttributeInfo.isWritable());
                managedBean.addAttribute((AttributeInfo)featureInfo);
            }
            MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
            for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
                object2 = mBeanOperationInfoArray[i];
                featureInfo = new OperationInfo();
                ((OperationInfo)featureInfo).setName(((MBeanFeatureInfo)object2).getName());
                ((OperationInfo)featureInfo).setReturnType(((MBeanOperationInfo)object2).getReturnType());
                MBeanParameterInfo[] mBeanParameterInfoArray = ((MBeanOperationInfo)object2).getSignature();
                for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                    ParameterInfo parameterInfo = new ParameterInfo();
                    parameterInfo.setType(mBeanParameterInfoArray[i].getType());
                    parameterInfo.setName(mBeanParameterInfoArray[i].getName());
                    ((OperationInfo)featureInfo).addParameter(parameterInfo);
                }
                managedBean.addOperation((OperationInfo)featureInfo);
            }
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MbeansDescriptorsDynamicMBeanSource.class);
            if (wMSLogger.isDebugEnabled()) {
                wMSLogger.debug("Setting name: " + string2);
            }
            managedBean.setName(string2);
            return managedBean;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

