/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.util;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.modeler.util.IntrospectionUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtil {
    public static String getContent(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = DomUtil.getChild(node, 3);
        if (node2 == null) {
            return null;
        }
        String string = node2.getNodeValue();
        return string.trim();
    }

    public static Node getChild(Node node, String string) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        for (Node node3 = node2; node3 != null; node3 = node3.getNextSibling()) {
            if (node3.getNodeType() != 1) continue;
            if (string != null && string.equals(node3.getNodeName())) {
                return node3;
            }
            if (string != null) continue;
            return node3;
        }
        return null;
    }

    public static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static void setAttribute(Node node, String string, String string2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = node.getOwnerDocument().createAttribute(string);
        attr.setNodeValue(string2);
        namedNodeMap.setNamedItem(attr);
    }

    public static void removeAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        namedNodeMap.removeNamedItem(string);
    }

    public static void setText(Node node, String string) {
        Node node2 = DomUtil.getChild(node, 3);
        if (node2 == null) {
            Text text = node.getOwnerDocument().createTextNode(string);
            node.appendChild(text);
            return;
        }
        node2.setNodeValue(string);
    }

    public static Node findChildWithAtt(Node node, String string, String string2, String string3) {
        Node node2 = DomUtil.getChild(node, 1);
        if (string3 == null) {
            while (node2 != null && (string == null || string.equals(node2.getNodeName())) && DomUtil.getAttribute(node2, string2) != null) {
                node2 = DomUtil.getNext(node2, string, 1);
            }
        } else {
            while (node2 != null && (string == null || string.equals(node2.getNodeName())) && !string3.equals(DomUtil.getAttribute(node2, string2))) {
                node2 = DomUtil.getNext(node2, string, 1);
            }
        }
        return node2;
    }

    public static String getChildContent(Node node, String string) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        for (Node node3 = node2; node3 != null; node3 = node3.getNextSibling()) {
            if (!string.equals(node3.getNodeName())) continue;
            return DomUtil.getContent(node3);
        }
        return null;
    }

    public static Node getChild(Node node, int n) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null && n != node2.getNodeType(); node2 = node2.getNextSibling()) {
        }
        if (node2 == null) {
            return null;
        }
        return node2;
    }

    public static Node getNext(Node node) {
        String string = node.getNodeName();
        short s = node.getNodeType();
        return DomUtil.getNext(node, string, s);
    }

    public static Node getNext(Node node, String string, int n) {
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            return null;
        }
        for (Node node3 = node2; node3 != null; node3 = node3.getNextSibling()) {
            if (n >= 0 && node3.getNodeType() != n) continue;
            if (string == null) {
                return node3;
            }
            if (!string.equals(node3.getNodeName())) continue;
            return node3;
        }
        return null;
    }

    public static void setAttributes(Object object, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            String string = node2.getNodeName();
            String string2 = node2.getNodeValue();
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DomUtil.class);
            if (wMSLogger.isDebugEnabled()) {
                wMSLogger.debug("Attribute " + node.getNodeName() + " " + string + "=" + string2);
            }
            try {
                IntrospectionUtils.setProperty(object, string, string2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static Document readXml(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringComments(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new NullResolver());
        Document document = documentBuilder.parse(inputStream);
        return document;
    }

    public static void writeXml(Node node, OutputStream outputStream) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(outputStream));
    }

    public static class NullResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DomUtil.class);
            if (wMSLogger.isDebugEnabled()) {
                wMSLogger.debug("ResolveEntity: " + string + " " + string2);
            }
            return new InputSource(new StringReader(""));
        }
    }
}

