/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public abstract class CallingFormat {
    protected static CallingFormat pathCallingFormat = new PathCallingFormat();
    protected static CallingFormat subdomainCallingFormat = new SubdomainCallingFormat();
    protected static CallingFormat vanityCallingFormat = new VanityCallingFormat();

    public abstract boolean supportsLocatedBuckets();

    public abstract String getEndpoint(String var1, int var2, String var3);

    public abstract String getPathBase(String var1, String var2);

    public abstract URL getURL(boolean var1, String var2, int var3, String var4, String var5, Map var6) throws MalformedURLException;

    public static CallingFormat getPathCallingFormat() {
        return pathCallingFormat;
    }

    public static CallingFormat getSubdomainCallingFormat() {
        return subdomainCallingFormat;
    }

    public static CallingFormat getVanityCallingFormat() {
        return vanityCallingFormat;
    }

    private static class VanityCallingFormat
    extends SubdomainCallingFormat {
        private VanityCallingFormat() {
        }

        @Override
        public String getServer(String string, String string2) {
            return string2;
        }
    }

    private static class SubdomainCallingFormat
    extends CallingFormat {
        private SubdomainCallingFormat() {
        }

        @Override
        public boolean supportsLocatedBuckets() {
            return true;
        }

        public String getServer(String string, String string2) {
            return string2 + "." + string;
        }

        @Override
        public String getEndpoint(String string, int n, String string2) {
            return this.getServer(string, string2) + ":" + n;
        }

        @Override
        public String getPathBase(String string, String string2) {
            return "/" + string2;
        }

        @Override
        public URL getURL(boolean bl, String string, int n, String string2, String string3, Map map) throws MalformedURLException {
            if (string2 == null || string2.length() == 0) {
                String string4 = Utils.convertPathArgsHashToString(map);
                return new URL(bl ? "https" : "http", string, n, "/" + string4);
            }
            String string5 = this.getServer(string, string2);
            String string6 = this.getPathBase(string2, string3);
            String string7 = Utils.convertPathArgsHashToString(map);
            return new URL(bl ? "https" : "http", string5, n, string6 + string7);
        }
    }

    private static class PathCallingFormat
    extends CallingFormat {
        private PathCallingFormat() {
        }

        @Override
        public boolean supportsLocatedBuckets() {
            return false;
        }

        @Override
        public String getPathBase(String string, String string2) {
            return this.isBucketSpecified(string) ? "/" + string + "/" + string2 : "/";
        }

        @Override
        public String getEndpoint(String string, int n, String string2) {
            return string + ":" + n;
        }

        @Override
        public URL getURL(boolean bl, String string, int n, String string2, String string3, Map map) throws MalformedURLException {
            String string4 = this.isBucketSpecified(string2) ? "/" + string2 + "/" + string3 : "/";
            String string5 = Utils.convertPathArgsHashToString(map);
            return new URL(bl ? "https" : "http", string, n, string4 + string5);
        }

        private boolean isBucketSpecified(String string) {
            if (string == null) {
                return false;
            }
            return string.length() != 0;
        }
    }
}

