/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.util.JSON;
import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.protocol.wowz.WOWZSession;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.ILivePlayer;
import com.wowza.wms.stream.live.LivePlayerSwitch;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class LivePlayer
implements ILivePlayer {
    protected long trackerSeqSource = 0L;
    protected IMediaStreamPlay stream = null;
    protected byte[] workBuffer = null;
    protected boolean isDebugLog = false;
    protected long lastSeq = -1L;
    protected long lastAudioTC = -1L;
    protected long lastVideoTC = -1L;
    protected long lastDataTC = -1L;
    protected long lastTC = -1L;
    protected long firstPacketTC = -1L;
    protected boolean isEnhancedSeekCapable = false;
    protected boolean isBurstCapable = false;
    protected boolean sendFirstKeyFrame = true;
    protected boolean checkStreamProperties = true;
    protected boolean sendFirstVideoFrame = true;
    protected boolean sendFirstAudioFrame = true;
    protected boolean sentPlayStart = false;
    protected boolean sendPlayStop = false;
    protected boolean sendPlaySwitch = false;
    protected long lastSendTime = -1L;
    protected boolean waitForKeyFrame = true;
    protected long lastTCOffset = 0L;
    protected int lastTCFilter = 7;
    protected LiveTracker lastSentLiveTracker = null;
    protected long trackerBufferTime = 0L;
    protected long trackerStartSeq = -1L;
    protected boolean sendStreamNotFound = true;
    protected boolean waitForBufferFill = true;
    protected boolean waitForBufferKeyFrame = false;
    protected long waitForBufferFillStarTime = -1L;
    protected int maximumLiveLatency = 8000;
    protected boolean disableLowBandwidthThrottling = false;
    protected boolean instantOn = false;
    protected int instantOnBufferTime = 0;
    protected int behindDropDFrames = 500;
    protected int behindDropPFrames = 1500;
    protected int behindDropKFrames = 3000;
    protected int behindDropAudio = 3000;
    protected boolean lastReceiveAudio = true;
    protected boolean lastReceiveVideo = true;
    protected int lastReceiveVideoFPS = -1;
    protected double playStart = 0.0;
    protected double playLen = -1.0;
    protected int playTransition = 0;
    protected boolean playlistEnd = false;
    protected boolean bufferEmptyOnce = false;
    protected Object lock = new Object();
    protected AtomicReference<LivePlayerSwitch> liveSwitch = new AtomicReference<Object>(null);
    protected boolean sendOriginalTimecodes = false;
    protected int packetsSent = 0;
    protected int startPacketsSent = 0;
    protected boolean referenceWrite = true;
    protected int[] avgPacketSizes = new int[8];
    protected long avgPacketSizeCount = 0L;
    protected long avgPacketSizeTotal = 0L;
    protected int referenceWritePacketSizeThreshold = 500;
    private boolean a = true;
    private PacketTimecodeDebug b = null;

    public LivePlayer(IMediaStreamPlay iMediaStreamPlay) {
        this.stream = iMediaStreamPlay;
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isBurstCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{10, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstStart(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(true);
        try {
            int n = IFasterByteArrayOutputStream.getProtocol((OutputStream)outputStream);
            if (n == 4) {
                WOWZSession wOWZSession = IFasterByteArrayOutputStream.getWOWZSession((OutputStream)outputStream);
                wOWZSession.wrapWrite(outputStream, byArray, 0, byArray.length);
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        outputStream.write(byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstEnd(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(false);
        try {
            int n = IFasterByteArrayOutputStream.getProtocol((OutputStream)outputStream);
            if (n == 4) {
                WOWZSession wOWZSession = IFasterByteArrayOutputStream.getWOWZSession((OutputStream)outputStream);
                wOWZSession.wrapWrite(outputStream, byArray, 0, byArray.length);
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        outputStream.write(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int packetOutput(OutputStream outputStream, IMediaStream iMediaStream, AMFPacket aMFPacket, long l, AMFObj aMFObj, byte[] byArray, int n) {
        if (this.startPacketsSent == this.packetsSent) {
            this.sendBurstStart(outputStream, iMediaStream);
        }
        ++this.packetsSent;
        return StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket, (long)l, (AMFObj)aMFObj, (byte[])byArray, (int)n, (boolean)this.referenceWrite);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int doSwitch(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray, long l, byte by, AMFPacket aMFPacket, AMFPacket aMFPacket2, AMFPacket aMFPacket3) {
        AMFPacket aMFPacket4;
        int n = 0;
        Client client = (Client)iMediaStream.getClient();
        int n2 = client.getSendChunkSize();
        this.checkWorkBuffer(n2);
        AMFPacket aMFPacket5 = new AMFPacket(8, iMediaStream.getSrc(), 0);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        AMFPacket aMFPacket6 = null;
        if (((by & 0xF) == 7 || (by & 0xF) == 12) && (aMFPacket6 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by & 0xF)), 2, 0, 0, 0};
            aMFPacket6.addData(byArray, 0, byArray.length);
        }
        if (aMFPacket6 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket6.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket6, l, aMFObj2, this.workBuffer, n2);
            aMFObj2.setNew(true);
        }
        n += iMediaStream.sendPlayStatus(outputStream, l, 1, 0.0, 0.0);
        n += iMediaStream.sendPlayStart(outputStream, iMediaStream.getName(), true, true, l, null);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        if (aMFPacket != null) {
            Object var18_19 = null;
            aMFPacket4 = null;
            ResponseFunction responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
            responseFunction.createSeekMessage(Base64.lastIndexOf((int)(-44 - -35), (String)"86\n.:((-"));
            responseFunction.setSrc(iMediaStream.getSrc());
            responseFunction.setType(18);
            responseFunction.setTimecode(l);
            aMFPacket4 = new AMFDataObj();
            aMFPacket4.put(JSON.regionMatches((String)"l\u007fuw", (int)(21 * 51)), (AMFData)new AMFDataItem(JSON.regionMatches((String)"Kcs[}xnm` Kqes=Gawel", (int)(63 - 26))));
            responseFunction.addBody((AMFData)aMFPacket4);
            n += responseFunction.write(outputStream, true, n2);
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket, l, aMFObj3, this.workBuffer, n2);
        }
        if (aMFPacket3 == null) return n;
        byte by2 = (byte)aMFPacket3.getFirstByte();
        aMFPacket4 = null;
        if (((by2 & 0xF) == 7 || (by2 & 0xF) == 12) && (aMFPacket4 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by2 & 0xF)), 2, 0, 0, 0};
            aMFPacket4.addData(byArray, 0, byArray.length);
        }
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, true), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket4 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket4.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket4, l, aMFObj2, this.workBuffer, n2);
        }
        lArray[2] = lArray[2] + (long)aMFPacket3.getSize();
        lArray[3] = lArray[3] + 1L;
        n += this.packetOutput(outputStream, iMediaStream, aMFPacket3, l, aMFObj2, this.workBuffer, n2);
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, false), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket2 == null) return n;
        return n += this.packetOutput(outputStream, iMediaStream, aMFPacket2, l, aMFObj2, this.workBuffer, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        WMSProperties wMSProperties = this.stream.getParent().getProperties();
        this.isDebugLog = WMSLoggerFactory.getLogger(LivePlayer.class).isDebugEnabled();
        if (wMSProperties == null) return;
        this.disableLowBandwidthThrottling = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(5 * 43), (String)"31*;908\u001207\u0003#- 2/#<!\u001e#>\":;<8<4"), this.disableLowBandwidthThrottling);
        this.instantOn = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"mkusig~Db", (int)(254 / 59)), this.instantOn);
        this.instantOnBufferTime = wMSProperties.getPropertyInt(JSON.regionMatches((String)"hlppdhsGgH~jkk}Dx\u007fv", (int)(20 + -19)), this.instantOnBufferTime);
        this.waitForBufferFill = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(55 + -3), (String)"ct\u007fc^vhYi{xz2\u0007+/("), this.waitForBufferFill);
        this.waitForBufferKeyFrame = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(12 + 125), (String)"~kbxKa}Rdtuqg]ra_hzqx"), this.waitForBufferKeyFrame);
        this.behindDropDFrames = wMSProperties.getPropertyInt(Base64.lastIndexOf((int)(722 / 175), (String)"f`nnfmNyc}JIbp\u007fvg"), this.behindDropDFrames);
        this.behindDropPFrames = wMSProperties.getPropertyInt(Base64.lastIndexOf((int)(49 + 67), (String)"60>>6=\u001e)3-\u000e\u0019r`ofw"), this.behindDropPFrames);
        this.behindDropAudio = this.behindDropKFrames = wMSProperties.getPropertyInt(JSON.regionMatches((String)"muy{}pQdxhR\\i}p{l", (int)(22 - -25)), this.behindDropKFrames);
        this.behindDropAudio = wMSProperties.getPropertyInt(Base64.lastIndexOf((int)(49 * 61), (String)"okgy\u007fvWfzfVm}st"), this.behindDropAudio);
        this.maximumLiveLatency = wMSProperties.getPropertyInt(JSON.regionMatches((String)"r!9.*2 '2, %'-9+!3(", (int)(78 + -15)), this.maximumLiveLatency);
        this.sendOriginalTimecodes = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"vcilFxbkd`n|E{~qvys}j", (int)(662 / 112)), this.sendOriginalTimecodes);
        this.referenceWritePacketSizeThreshold = wMSProperties.getPropertyInt(Base64.lastIndexOf((int)(57 + -10), (String)"}uwwaq{urOksoyM\u007f|+$6\u0010-?#\u0013 ;/8$\"\"+"), this.referenceWritePacketSizeThreshold);
        this.referenceWrite = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"2$$&6 ($-\u001e8\"8(", (int)(42 - -54)), this.referenceWrite);
        this.a = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"`hfjeoOucobyrAgfpwzUxhpyom", (int)(571 / 103)), this.a);
        boolean bl = false;
        bl = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(682 / 200), (String)"gags`G|~lcd`hBE_CDtu|}mNrqxm"), bl);
        if (!bl) {
            if (!this.isDebugLog) return;
        }
        this.b = new PacketTimecodeDebug();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean testVideoFrame(int n, int n2) {
        if ((n & 1 << ((n2 & 0x30) >> 4) - 1) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.workBuffer == null) {
            bl = true;
        } else if (this.workBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.workBuffer = new byte[n];
    }

    /*
     * Enabled aggressive block sorting
     */
    protected AMFPacket getEnhanceSeekPacket(IMediaStream iMediaStream, int n, boolean bl) {
        AMFPacket aMFPacket = new AMFPacket(9, iMediaStream.getSrc(), 2);
        byte[] byArray = new byte[]{(byte)(0x50 | (byte)(n & 0xF)), (byte)(!bl ? 1 : 0)};
        aMFPacket.addData(byArray, 0, byArray.length);
        return aMFPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        this.startPacketsSent = this.packetsSent;
        synchronized (this.lock) {
            Client client = (Client)this.stream.getParent().getClient();
            int n2 = client.getSendChunkSize();
            this.checkWorkBuffer(n2);
            LivePlayer livePlayer = this;
            livePlayer.isEnhancedSeekCapable = livePlayer.isEnhancedSeekCapable(livePlayer.stream.getParent());
            if (this.a) {
                LivePlayer livePlayer2 = this;
                livePlayer2.isBurstCapable = livePlayer2.isBurstCapable(livePlayer2.stream.getParent());
            }
            int n3 = -1;
            AMFPacket aMFPacket = this.getLastKeyFrame(iMediaStream);
            if (aMFPacket != null) {
                long l = 0L;
                int n4 = aMFPacket.getFirstByte();
                n3 = FLVUtils.getVideoCodec((int)n4);
                if (!this.sentPlayStart) {
                    if (this.sendPlayStop) {
                        n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                        this.sendPlayStop = false;
                    }
                    n += this.stream.getParent().sendLivePlayStart(outputStream, this.stream.getParent().getName(), l, this.firstPacketTC);
                    this.sentPlayStart = true;
                    this.sendPlayStop = true;
                    this.stream.getParent().setSendPlayStopLogEvent(true);
                    WMSLoggerFactory.putGlobalLogValue((String)JSON.regionMatches((String)"h<ac{f", (int)(13 + 35)), (Object)new Long(0L));
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), JSON.regionMatches((String)"  '365", (int)(11 * 57)), "play", 200, this.stream.getParent().getName());
                    this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                    aMFObj3.setNew(true);
                    aMFObj.setNew(true);
                    aMFObj2.setNew(true);
                }
                if (this.sendFirstKeyFrame) {
                    AMFPacket aMFPacket2;
                    AMFPacket aMFPacket3;
                    Object object;
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                    if (iMediaStreamMetaDataProvider != null) {
                        ArrayList arrayList = new ArrayList();
                        long l2 = 0L;
                        iMediaStreamMetaDataProvider.onStreamStart(arrayList, l2);
                        if (arrayList.size() > 0) {
                            object = null;
                            AMFDataObj aMFDataObj = null;
                            object = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                            object.createSeekMessage(Base64.lastIndexOf((int)(31 * 45), (String)"<:\u0006\"6,,)"));
                            object.setSrc(this.stream.getParent().getSrc());
                            object.setType(18);
                            object.setTimecode(l);
                            aMFDataObj = new AMFDataObj();
                            aMFDataObj.put(JSON.regionMatches((String)"`kac", (int)(259 / 72)), (AMFData)new AMFDataItem(Base64.lastIndexOf((int)(756 / 157), (String)"J`rT|{oja#Jndp<@`tdc")));
                            object.addBody((AMFData)aMFDataObj);
                            n += object.write(outputStream, true, n2);
                            for (AMFPacket aMFPacket4 : arrayList) {
                                n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket4, l, aMFObj3, this.workBuffer, n2);
                            }
                        }
                    }
                    boolean bl = false;
                    if (this.sendFirstVideoFrame) {
                        aMFPacket3 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (aMFPacket3 != null) {
                            n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket3, l, aMFObj2, this.workBuffer, n2);
                        }
                        this.sendFirstVideoFrame = false;
                        bl = true;
                    }
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer3 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer3.getEnhanceSeekPacket(livePlayer3.stream.getParent(), aMFPacket.getFirstByte(), true), l, aMFObj2, this.workBuffer, n2);
                    }
                    lArray[2] = lArray[2] + (long)aMFPacket.getSize();
                    lArray[3] = lArray[3] + 1L;
                    n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket, l, aMFObj2, this.workBuffer, n2);
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer4 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer4.getEnhanceSeekPacket(livePlayer4.stream.getParent(), aMFPacket.getFirstByte(), false), l, aMFObj2, this.workBuffer, n2);
                    }
                    if ((aMFPacket3 = new AMFPacket(8, iMediaStream.getSrc(), 0)) != null) {
                        lArray[0] = lArray[0] + 0L;
                        lArray[1] = lArray[1] + 1L;
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket3, l, aMFObj, this.workBuffer, n2);
                        aMFObj.setNew(true);
                    }
                    if ((n3 == 7 || n3 == 12) && (aMFPacket2 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
                        lArray[2] = lArray[2] + 5L;
                        lArray[3] = lArray[3] + 1L;
                        object = new byte[5];
                        object[0] = (ResponseFunction)23;
                        object[1] = (ResponseFunction)2;
                        object[2] = (ResponseFunction)false;
                        object[3] = (ResponseFunction)false;
                        object[4] = (ResponseFunction)false;
                        aMFPacket2.addData((byte[])object, 0, ((ResponseFunction)object).length);
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket2, l, aMFObj2, this.workBuffer, n2);
                    }
                    if (this.stream.getParent().isSendPlayStopLogEvent()) {
                        this.stream.getParent().setSendPlayStopLogEvent(false);
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.lastIndexOf((int)(1402 / 236), (String)"vrumhg"), "stop", 200, this.stream.getParent().getName());
                        this.stream.getParent().notifyActionStop();
                    }
                    n += this.stream.getParent().sendPlayStatus(outputStream, l, 2, 0.0, 0.0);
                    n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                    this.sendPlayStop = false;
                    this.sendFirstKeyFrame = false;
                }
                this.playlistEnd = true;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (this.startPacketsSent == this.packetsSent) return n;
            this.sendBurstEnd(outputStream, this.stream.getParent());
            return n;
        }
    }

    protected List getPlayPackets(IMediaStream iMediaStream) {
        return iMediaStream.getPlayPackets();
    }

    protected AMFPacket getLastKeyFrame(IMediaStream iMediaStream) {
        return iMediaStream.getLastKeyFrame();
    }

    protected AMFPacket getLastPacket(IMediaStream iMediaStream) {
        return iMediaStream.getLastPacket();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected long[] getLastPacketTimecodes(List<AMFPacket> var1_1) {
        var2_2 = new long[]{-1L, -1L};
        var3_3 = var1_1.size() - 1;
        if (true) ** GOTO lbl8
        block0: while (true) {
            var2_2[1] = var6_6;
            while (var2_2[0] < 0L || var2_2[1] < 0L) {
                --var3_3;
lbl8:
                // 2 sources

                if (var3_3 < 0) return var2_2;
                var4_4 = var1_1.get(var3_3);
                var5_5 = var4_4.getType();
                var6_6 = var4_4.getAbsTimecode();
                if (var5_5 != 8) {
                    if (var5_5 != 9 || var2_2[1] != -1L) continue;
                    continue block0;
                }
                if (var2_2[0] != -1L) continue;
                var2_2[0] = var6_6;
            }
            break;
        }
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int playAll(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        this.startPacketsSent = this.packetsSent;
        n += this.playAllInternal(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        IMediaStream iMediaStream2 = null;
        LivePlayerSwitch livePlayerSwitch = this.liveSwitch.get();
        if (livePlayerSwitch != null && livePlayerSwitch.switchTimecodeFound) {
            this.sendPlaySwitch = true;
            this.sendFirstAudioFrame = true;
            this.sendFirstVideoFrame = true;
            this.lastSeq = livePlayerSwitch.switchVideoKeyFrameSeq;
            ((MediaStream)this.stream.getParent()).setJustName(livePlayerSwitch.getName());
            iMediaStream2 = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            this.stream.getParent().getPlayer().switchPlay();
            this.liveSwitch.set(null);
        }
        if (iMediaStream2 != null) {
            n += this.playAllInternal(iMediaStream2, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        if (this.startPacketsSent == this.packetsSent) return n;
        this.sendBurstEnd(outputStream, this.stream.getParent());
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playAllInternal(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, long[] var6_6) {
        var7_7 = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        var8_8 = true;
        var9_9 = true;
        var10_10 = -1;
        synchronized (this.stream.getParent()) {
            var8_8 = this.stream.getParent().isReceiveAudio();
            var9_9 = this.stream.getParent().isReceiveVideo();
            var10_10 = this.stream.getParent().getReceiveVideoFPS();
            // ** MonitorExit[var11_12] (shouldn't be in output)
            var11_11 = System.currentTimeMillis();
            if (this.b != null) {
                var13_13 = 0L;
                if (this.b.i >= 0L) {
                    var13_13 = var11_11 - this.b.i;
                }
                this.b.i = var11_11;
                var15_15 = Base64.lastIndexOf((int)(57 + -37), (String)"X|`rHu{byo0msdlg_") + this.stream.getParent().getContextStr() + JSON.regionMatches((String)"L(3fa,", (int)(60 + 117)) + var13_13;
                if (this.isDebugLog) {
                    WMSLoggerFactory.getLogger(null).debug((String)var15_15);
                } else {
                    WMSLoggerFactory.getLogger(null).info((String)var15_15);
                }
            }
            var13_14 = this.lock;
            synchronized (var13_14) {
                block140: {
                    block141: {
                        block173: {
                            block147: {
                                block172: {
                                    block146: {
                                        block150: {
                                            block144: {
                                                block153: {
                                                    block152: {
                                                        block151: {
                                                            var14_18 = this.liveSwitch.get();
                                                            var15_15 = this.getPlayPackets(var1_1);
                                                            var16_19 = var1_1.getLastKeyFrame();
                                                            if (this.checkStreamProperties) {
                                                                v0 = this;
                                                                v0.isEnhancedSeekCapable = v0.isEnhancedSeekCapable(v0.stream.getParent());
                                                                if (this.a) {
                                                                    v1 = this;
                                                                    v1.isBurstCapable = v1.isBurstCapable(v1.stream.getParent());
                                                                }
                                                                if ((var17_20 = this.stream.getParent().getClient()) != null && var17_20.getLiveRepeaterCapabilities() > 0) {
                                                                    this.sendOriginalTimecodes = true;
                                                                }
                                                                this.checkStreamProperties = false;
                                                            }
                                                            var17_20 = (Client)this.stream.getParent().getClient();
                                                            var18_21 = var17_20.getSendChunkSize();
                                                            var19_22 = 7;
                                                            var20_23 = false;
                                                            var21_24 = 0L;
                                                            var23_25 = null;
                                                            var24_26 = null;
                                                            var25_27 = var17_20.getWriteListener();
                                                            var26_28 = JSON.regionMatches((String)"ppwcfe", (int)(243 / 68)) + this.stream.getParent().getSrc();
                                                            var27_29 = var15_15.size();
                                                            if (var27_29 != 0) break block151;
                                                            this.bufferEmptyOnce = true;
                                                            ** GOTO lbl278
                                                        }
                                                        var28_31 = (AMFPacket)var15_15.get(0);
                                                        if (!this.waitForBufferFill || !this.sendFirstKeyFrame) break block152;
                                                        var29_34 = true;
                                                        var30_35 = Math.min((long)this.stream.getParent().getBufferTime(), (long)this.maximumLiveLatency);
                                                        if (this.waitForBufferFillStarTime != -1L) {
                                                            if (var11_11 - this.waitForBufferFillStarTime > var30_35 && !this.waitForBufferKeyFrame) {
                                                                var29_34 = false;
                                                            }
                                                        } else {
                                                            this.waitForBufferFillStarTime = var11_11;
                                                        }
                                                        if (!var29_34 || var30_35 <= 0L) break block152;
                                                        var32_40 = (AMFPacket)var15_15.get(var27_29 - 1);
                                                        if (var32_40.getAbsTimecode() - var28_31.getAbsTimecode() < var30_35) ** GOTO lbl278
                                                        if (!this.waitForBufferKeyFrame || var16_19 != null) break block152;
                                                        var33_42 = 0;
                                                        for (var34_44 = 0; var34_44 < var27_29 && ((var35_48 = (AMFPacket)var15_15.get(var34_44)).getType() != 9 || ++var33_42 <= 2); ++var34_44) {
                                                        }
                                                        if (var33_42 > 2) ** GOTO lbl278
                                                    }
                                                    var29_32 = var28_31.getSeq();
                                                    v2 = var31_36 = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - var29_32 + 1L);
                                                    if (var31_36 < 0) {
                                                        var31_36 = 0;
                                                    }
                                                    if (var31_36 >= var27_29) ** GOTO lbl278
                                                    if ((!this.bufferEmptyOnce || this.waitForBufferFill) && this.instantOn && this.sendFirstKeyFrame) {
                                                        var32_39 = -1L;
                                                        var35_47 = -1;
                                                        this.trackerBufferTime = 0L;
                                                        var36_51 = this.stream.getParent().getBufferTime();
                                                        for (var34_44 = var27_29 - 1; var34_44 >= 0; --var34_44) {
                                                            var28_31 = (AMFPacket)var15_15.get(var34_44);
                                                            var38_57 = var28_31.getType();
                                                            if (var38_57 != 9 && var38_57 != 8) continue;
                                                            var39_60 = var28_31.getAbsTimecode();
                                                            if (var32_39 == -1L) {
                                                                var32_39 = var39_60;
                                                            } else {
                                                                if (var35_47 == -1) {
                                                                    this.trackerBufferTime = var32_39 - var39_60;
                                                                }
                                                                if (var35_47 == -1 && var32_39 - var39_60 > var36_51) {
                                                                    var35_47 = var34_44;
                                                                }
                                                            }
                                                            if (var38_57 == 9) {
                                                                var41_69 = FLVUtils.isVideoKeyFrame((AMFPacket)var28_31);
                                                                if (!this.isEnhancedSeekCapable) {
                                                                    if (var41_69) {
                                                                        var23_25 = var28_31;
                                                                    }
                                                                } else if (var35_47 != -1 && var41_69) {
                                                                    var23_25 = var28_31;
                                                                    if (this.instantOnBufferTime <= 0 || var32_39 - var39_60 >= (long)this.instantOnBufferTime) break;
                                                                }
                                                            }
                                                            if (!this.isEnhancedSeekCapable && var35_47 != -1) break;
                                                        }
                                                        v3 = var31_36 = var35_47 < 0 ? 0 : var35_47;
                                                    }
                                                    if (var31_36 == 0 && this.lastSeq != -1L && (var28_31 = (AMFPacket)var15_15.get(var31_36)).getSeq() != this.lastSeq + 1L) {
                                                        this.waitForKeyFrame = true;
                                                    }
                                                    if ((var33_41 = (var32_38 = var25_27.getLastTracker()) == null ? null : (LiveTracker)var32_38.getInfo(var26_28)) != null && this.lastSentLiveTracker != null && var33_41.trackerSeq >= this.trackerStartSeq) {
                                                        var34_45 = var32_38.getSent();
                                                        var36_51 = var32_38.getSize();
                                                        var38_59 = var33_41.firstTC + (var33_41.lastTC - var33_41.firstTC) * var34_45 / var36_51;
                                                        var21_24 = this.lastSentLiveTracker.lastTC - var38_59 - this.trackerBufferTime;
                                                        if (!this.disableLowBandwidthThrottling) {
                                                            if (var21_24 > (long)this.behindDropAudio) {
                                                                var20_23 = true;
                                                            }
                                                            if (var21_24 > (long)this.behindDropKFrames) {
                                                                var19_22 = 0;
                                                            } else if (var21_24 > (long)this.behindDropPFrames) {
                                                                var19_22 = 1;
                                                            } else if (var21_24 > (long)this.behindDropDFrames) {
                                                                var19_22 = 3;
                                                            }
                                                        }
                                                        if (this.lastTCFilter != var19_22) {
                                                            WMSLoggerFactory.getLogger(LivePlayer.class).debug(JSON.regionMatches((String)"\u0013?;,<(\u0000", (int)(26 - -59)) + var26_28 + Base64.lastIndexOf((int)(47 * 51), (String)"\u0000d\u007f&(.7!7|o") + this.lastTCFilter + "-" + var19_22 + Base64.lastIndexOf((int)(15 + 72), (String)"~x6<=/8*e") + var21_24 + JSON.regionMatches((String)"&tmg~_O7", (int)(1556 / 243)) + this.lastSentLiveTracker.lastTC + Base64.lastIndexOf((int)(99 + 49), (String)"4gst}pl~xI]%") + var33_41.lastTC + Base64.lastIndexOf((int)(83 + 33), (String)"t7#1><(\u000f50;e") + this.trackerBufferTime + Base64.lastIndexOf((int)(958 / 247), (String)"#pf<") + this.lastTC);
                                                        }
                                                        this.lastTCFilter = var19_22;
                                                    }
                                                    this.lastTCOffset = var21_24;
                                                    var34_43 = var10_10;
                                                    if (var34_43 < -1) {
                                                        if (var34_43 != -2 || var19_22 != 7) {
                                                            if (var34_43 == -3 && (var19_22 == 7 || var19_22 == 3)) {
                                                                var19_22 = 1;
                                                                this.waitForKeyFrame = true;
                                                            }
                                                        } else {
                                                            var19_22 = 3;
                                                        }
                                                    }
                                                    var35_46 = 300;
                                                    if (var14_18 == null) ** GOTO lbl306
                                                    var36_49 = this.stream.getParent().getStreams().getStream(var14_18.getName());
                                                    var37_52 = null;
                                                    if (var36_49 != null) {
                                                        var37_52 = var36_49.getPlayPackets();
                                                    }
                                                    if (var14_18.switchMode != -1) ** GOTO lbl182
                                                    if (var14_18.getPlayerTransition() == 12) {
                                                        var14_18.switchMode = 1;
                                                    }
                                                    var38_56 = 0L;
                                                    if (var14_18.switchMode == -1) {
                                                        var40_63 = 1;
                                                        if (var37_52 != null && var37_52.size() > 0) {
                                                            var41_68 = this.getLastPacketTimecodes((List<AMFPacket>)var15_15);
                                                            var42_70 = this.getLastPacketTimecodes(var37_52);
                                                            var43_74 = -1L;
                                                            var45_76 = false;
                                                            var46_79 = -1L;
                                                            var48_93 = 0;
                                                            if (var41_68[0] >= 0L && var42_70[0] >= 0L) {
                                                                var43_74 = var42_70[0] - var41_68[0];
                                                                var45_76 = true;
                                                            }
                                                            if (var41_68[1] >= 0L && var42_70[1] >= 0L) {
                                                                var46_79 = var42_70[1] - var41_68[1];
                                                                var48_93 = 1;
                                                            }
                                                            if (!var45_76 || var48_93 == 0) {
                                                                var38_56 = var48_93 != 0 ? var46_79 : var43_74;
                                                            }
                                                            var38_56 = Math.abs(var46_79) >= Math.abs(var43_74) ? var43_74 : var46_79;
                                                            if (Math.abs(var38_56) <= (long)var35_46) {
                                                                var40_63 = 0;
                                                            }
                                                        }
                                                        var14_18.switchMode = var40_63;
                                                    }
                                                    switch (var14_18.switchMode) {
                                                        case 0: {
                                                            var14_18.switchTimecodeOffset = 0L;
                                                            ** break;
                                                        }
                                                        case 1: {
                                                            var14_18.switchTimecodeOffset = var38_56;
                                                            ** break;
                                                        }
                                                        default: {
                                                            if (var14_18.lastSeq != -1L) ** GOTO lbl305
                                                            break block153;
                                                        }
                                                    }
lbl182:
                                                    // 3 sources

                                                    if (var14_18.lastSeq != -1L) ** GOTO lbl305
                                                }
                                                if (var37_52 == null || (var38_54 = var37_52.size()) <= 0) ** GOTO lbl305
                                                var39_60 = -1L;
                                                var41_66 = -1L;
                                                var43_74 = -1L;
                                                var45_75 = -1L;
                                                var47_85 = var31_36;
                                                while (true) {
                                                    block157: {
                                                        block155: {
                                                            block156: {
                                                                block154: {
                                                                    if (var47_85 >= var27_29) break block154;
                                                                    var28_31 = (AMFPacket)var15_15.get(var47_85);
                                                                    var48_93 = var28_31.getType();
                                                                    var49_99 = var28_31.getAbsTimecode();
                                                                    if (var48_93 != 8) break block155;
                                                                    break block156;
                                                                }
                                                                var47_84 = var45_75 - var43_74;
                                                                var49_99 = var41_66 - var39_60;
                                                                var51_106 = Math.max(var47_84, var49_99);
                                                                var39_60 = -1L;
                                                                var41_66 = -1L;
                                                                var43_74 = -1L;
                                                                var45_75 = -1L;
                                                                var53_111 = -1;
                                                                var54_117 = var38_54 - 1;
                                                                break block140;
                                                            }
                                                            if (var39_60 == -1L) {
                                                                var39_60 = var49_99;
                                                            }
                                                            var41_66 = var49_99;
                                                            break block157;
                                                        }
                                                        if (var48_93 == 9) {
                                                            if (var43_74 == -1L) {
                                                                var43_74 = var49_99;
                                                            }
                                                            var45_75 = var49_99;
                                                        }
                                                    }
                                                    ++var47_85;
                                                }
                                                while (true) {
                                                    block145: {
                                                        block171: {
                                                            block169: {
                                                                block170: {
                                                                    block166: {
                                                                        block168: {
                                                                            block167: {
                                                                                block148: {
                                                                                    block160: {
                                                                                        block165: {
                                                                                            block149: {
                                                                                                block161: {
                                                                                                    block159: {
                                                                                                        block142: {
                                                                                                            block143: {
                                                                                                                block158: {
                                                                                                                    if (var55_122 != 9) break block141;
                                                                                                                    if (var45_75 == -1L) {
                                                                                                                        var45_75 = var56_124;
                                                                                                                        break block141;
                                                                                                                    }
                                                                                                                    if (var45_75 - var56_124 < var51_106) break block141;
                                                                                                                    var53_111 = var54_117;
                                                                                                                    break block158;
lbl231:
                                                                                                                    // 2 sources

                                                                                                                    while (var42_72 < var38_53) {
                                                                                                                        var28_31 = (AMFPacket)var37_52.get(var42_72);
                                                                                                                        var43_74 = var28_31.getSeq();
                                                                                                                        var45_78 = var28_31.getType();
                                                                                                                        var14_18.lastSeq = var43_74;
                                                                                                                        if (var45_78 == 9 && FLVUtils.isVideoKeyFrame((AMFPacket)var28_31)) {
                                                                                                                            var46_83 = var28_31.getFirstByte();
                                                                                                                            var47_84 = var28_31.getAbsTimecode();
                                                                                                                            var14_18.switchVideoKeyFrameSeq = var43_74 - 1L;
                                                                                                                            var14_18.switchTimecodeTarget = var47_84 + var14_18.switchTimecodeOffset;
                                                                                                                        }
                                                                                                                        ++var42_72;
                                                                                                                    }
                                                                                                                    break block143;
lbl244:
                                                                                                                    // 2 sources

                                                                                                                    while (true) {
                                                                                                                        var56_125 = var55_123.getFirstByte();
                                                                                                                        if (FLVUtils.getFrameType((int)var56_125) != 3) ** GOTO lbl564
                                                                                                                        ** GOTO lbl568
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    while (true) {
                                                                                                                        v4 = false;
                                                                                                                        ** GOTO lbl285
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    while (true) {
                                                                                                                        this.waitForKeyFrame = true;
                                                                                                                        break block142;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    while (true) {
                                                                                                                        var28_31 = (AMFPacket)var37_52.get(0);
                                                                                                                        var39_60 = var28_31.getSeq();
                                                                                                                        var41_67 = var14_18.lastSeq == -1L ? 0 : (int)(var14_18.lastSeq - var39_60 + 1L);
                                                                                                                        if (var41_67 < 0) {
                                                                                                                            var41_67 = 0;
                                                                                                                        }
                                                                                                                        if (var41_67 >= var38_53) break block143;
                                                                                                                        var42_72 = var41_67;
                                                                                                                        ** GOTO lbl231
                                                                                                                        break;
                                                                                                                    }
lbl263:
                                                                                                                    // 2 sources

                                                                                                                    while (true) {
                                                                                                                        var6_6[2] = var6_6[2] + (long)var23_25.getSize();
                                                                                                                        var6_6[3] = var6_6[3] + 1L;
                                                                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var23_25, var42_71, var4_4, this.workBuffer, var18_21);
                                                                                                                        var4_4.setNew(true);
                                                                                                                        var49_100 = FLVUtils.getVideoCodec((AMFPacket)var23_25);
                                                                                                                        if (!this.isEnhancedSeekCapable) break block144;
                                                                                                                        var50_131 = var23_25.getSeq();
                                                                                                                        var52_134 = (int)(var50_131 - var29_32 + 1L);
                                                                                                                        if (var48_95) {
                                                                                                                            this.waitForKeyFrame = false;
                                                                                                                        }
                                                                                                                        if (!var48_95 || var52_134 < 0 || var52_134 >= var27_29) break block144;
                                                                                                                        var53_113 = 0;
                                                                                                                        var54_119 = var52_134;
                                                                                                                        if (true) ** GOTO lbl570
                                                                                                                        break;
                                                                                                                    }
lbl278:
                                                                                                                    // 6 sources

                                                                                                                    while (true) {
                                                                                                                        var27_30 = 0L;
                                                                                                                        if (this.avgPacketSizeCount > (long)(this.avgPacketSizes.length << 1)) {
                                                                                                                            var27_30 = this.avgPacketSizeTotal / (long)this.avgPacketSizes.length;
                                                                                                                            if (this.referenceWritePacketSizeThreshold > 0) {
                                                                                                                                if (var27_30 < (long)this.referenceWritePacketSizeThreshold) ** continue;
                                                                                                                                v4 = this.referenceWrite = true;
                                                                                                                            }
                                                                                                                        }
lbl285:
                                                                                                                        // 6 sources

                                                                                                                        if (this.isDebugLog) {
                                                                                                                            var29_33 = System.currentTimeMillis();
                                                                                                                            var31_37 = this.lastSendTime != -1L ? var29_33 - this.lastSendTime : 0L;
                                                                                                                            this.lastSendTime = var29_33;
                                                                                                                            WMSLoggerFactory.getLogger(LivePlayer.class).debug(Base64.lastIndexOf((int)(618 / 127), (String)"w`hcS") + this.stream.getParent().getClientId() + JSON.regionMatches((String)"\u0003e`2+9!\u007f", (int)(17 - 51)) + var7_7 + ":" + var27_30 + JSON.regionMatches((String)">y)-6&6\u007f", (int)(9 - -53)) + var19_22 + JSON.regionMatches((String)"}*6-$x", (int)(13 * 17)) + var31_37 + JSON.regionMatches((String)"s \u001a01+<.a", (int)(-29 - 16)) + var21_24 + Base64.lastIndexOf((int)(29 * 35), (String)"w*.(/f") + this.referenceWrite);
                                                                                                                        }
                                                                                                                        if (var24_26 == null) return var7_7;
                                                                                                                        var24_26.totalLen = var7_7;
                                                                                                                        this.lastSentLiveTracker = var24_26;
                                                                                                                        var25_27.getPendingTracker().putInfo(var26_28, var24_26);
                                                                                                                        return var7_7;
                                                                                                                    }
lbl296:
                                                                                                                    // 1 sources

                                                                                                                    while (true) {
                                                                                                                        this.waitForKeyFrame = true;
                                                                                                                        break block145;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                }
lbl300:
                                                                                                                // 3 sources

                                                                                                                while (true) {
                                                                                                                    if (var53_111 < 0) {
                                                                                                                        var53_111 = 0;
                                                                                                                    }
                                                                                                                    var28_31 = (AMFPacket)var37_52.get(var53_111);
                                                                                                                    var14_18.lastSeq = var28_31.getSeq();
lbl305:
                                                                                                                    // 4 sources

                                                                                                                    if (var14_18.lastSeq >= 0L && var14_18.switchVideoKeyFrameSeq < 0L && var37_52 != null && (var38_53 = var37_52.size()) > 0) ** continue;
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            if (this.sendFirstKeyFrame || this.lastReceiveVideo == var9_9) break block159;
                                                                                                            if (var9_9) ** continue;
                                                                                                        }
                                                                                                        this.lastReceiveVideo = var9_9;
                                                                                                    }
                                                                                                    this.checkWorkBuffer(var18_21);
                                                                                                    var36_50 = -1L;
                                                                                                    var38_55 = var31_36;
                                                                                                    break block160;
lbl316:
                                                                                                    // 2 sources

                                                                                                    while (var50_130.hasNext()) {
                                                                                                        var51_110 = (AMFPacket)var50_130.next();
                                                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var51_110, var42_71, var5_5, this.workBuffer, var18_21);
                                                                                                    }
                                                                                                    break block161;
lbl321:
                                                                                                    // 1 sources

                                                                                                    while (this.lastReceiveAudio != var8_8) {
                                                                                                        if (var8_8) {
                                                                                                            var7_7 += this.stream.getParent().sendLivePlaySeek(var2_2, this.stream.getParent().getName(), var42_71);
                                                                                                        }
                                                                                                        if ((var47_91 = new AMFPacket(8, var1_1.getSrc(), 0)) != null) {
                                                                                                            var6_6[0] = var6_6[0] + 0L;
                                                                                                            var6_6[1] = var6_6[1] + 1L;
                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var47_91, var42_71, var3_3, this.workBuffer, var18_21);
                                                                                                        }
                                                                                                        this.lastReceiveAudio = var8_8;
                                                                                                        break block146;
                                                                                                    }
                                                                                                    break block146;
                                                                                                    while (true) {
                                                                                                        v5 = false;
                                                                                                        ** GOTO lbl347
                                                                                                        break;
                                                                                                    }
lbl334:
                                                                                                    // 2 sources

                                                                                                    block31: while (true) {
                                                                                                        var54_118 = var42_71 - this.b.c;
                                                                                                        var56_126 = JSON.regionMatches((String)"\u001f=#3\u000748#>.s(6ddmX", (int)(33 * 19)) + this.stream.getParent().getContextStr() + Base64.lastIndexOf((int)(114 + -8), (String)"\u0017ql%*=ja*") + var49_101 + Base64.lastIndexOf((int)(790 / 132), (String)"%u}2") + var50_132 + Base64.lastIndexOf((int)(1205 / 216), (String)"%rd") + var42_71 + "/" + var54_118 + ":" + var47_90 + ":" + var53_114;
                                                                                                        if (this.isDebugLog) {
                                                                                                            WMSLoggerFactory.getLogger(null).debug(var56_126);
                                                                                                        } else {
                                                                                                            WMSLoggerFactory.getLogger(null).info(var56_126);
                                                                                                        }
                                                                                                        this.b.c = var42_71;
                                                                                                        break block147;
lbl343:
                                                                                                        // 1 sources

                                                                                                        while (var40_64 >= var14_18.switchTimecodeTarget && !var14_18.switchTimecodeFound) {
                                                                                                            var14_18.switchTimecodeFound = true;
                                                                                                            break block148;
                                                                                                        }
                                                                                                        break block148;
lbl347:
                                                                                                        // 2 sources

                                                                                                        while (true) {
                                                                                                            block163: {
                                                                                                                block164: {
                                                                                                                    block162: {
                                                                                                                        var48_94 = v5;
                                                                                                                        if (!var48_94) {
                                                                                                                            var48_94 = this.testVideoFrame(var19_22, var46_80);
                                                                                                                        }
                                                                                                                        if (!var48_94) break block162;
                                                                                                                        if (!this.waitForKeyFrame) break block163;
                                                                                                                        break block164;
                                                                                                                    }
                                                                                                                    var45_77 = var28_31.getSize();
                                                                                                                    var6_6[6] = var6_6[6] + (long)var45_77;
                                                                                                                    var6_6[7] = var6_6[7] + 1L;
                                                                                                                    ** GOTO lbl386
                                                                                                                }
                                                                                                                if (!FLVUtils.isVideoKeyFrame((AMFPacket)var28_31)) ** GOTO lbl386
                                                                                                                WMSLoggerFactory.getLogger(LivePlayer.class).debug(Base64.lastIndexOf((int)(921 / 233), (String)"telrAg{AnuK|n}t(3rzcy|"));
                                                                                                                this.waitForKeyFrame = false;
                                                                                                            }
                                                                                                            if (this.firstPacketTC == -1L) {
                                                                                                                var42_71 = 0L;
                                                                                                                this.firstPacketTC = var40_64;
                                                                                                            } else {
                                                                                                                var42_71 = var40_64 - this.firstPacketTC;
                                                                                                            }
                                                                                                            if (this.sendOriginalTimecodes) {
                                                                                                                var42_71 = var40_64;
                                                                                                            }
                                                                                                            if (var42_71 < 0L) ** GOTO lbl386
                                                                                                            var39_61 = var4_4;
                                                                                                            this.lastTC = var42_71;
                                                                                                            this.lastVideoTC = var42_71;
                                                                                                            if (!(var9_9 || var47_88 != 7 && var47_88 != 12)) {
                                                                                                                var49_105 = Math.min(var28_31.getSize(), 5);
                                                                                                                var28_31 = var28_31.clone();
                                                                                                                var28_31.truncatePacket(var49_105);
                                                                                                            }
                                                                                                            var45_77 = var28_31.getSize();
                                                                                                            var6_6[2] = var6_6[2] + (long)var45_77;
                                                                                                            var6_6[3] = var6_6[3] + 1L;
                                                                                                            ** GOTO lbl386
                                                                                                            break;
                                                                                                        }
lbl383:
                                                                                                        // 2 sources

                                                                                                        while (true) {
                                                                                                            var46_81 = false;
                                                                                                            break block149;
lbl386:
                                                                                                            // 11 sources

                                                                                                            while (true) {
                                                                                                                if (var45_77 > 0) {
                                                                                                                    this.avgPacketSizeTotal -= (long)this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)];
                                                                                                                    this.avgPacketSizeTotal += (long)var45_77;
                                                                                                                    this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)] = var45_77;
                                                                                                                    ++this.avgPacketSizeCount;
                                                                                                                }
                                                                                                                if (var39_61 == null) break block149;
                                                                                                                if (!this.sentPlayStart) {
                                                                                                                    if (this.sendPlayStop) {
                                                                                                                        var7_7 += this.stream.getParent().sendPlayStop(var2_2, var42_71, this.stream.getParent().getName());
                                                                                                                        this.sendPlayStop = false;
                                                                                                                    }
                                                                                                                    var7_7 += this.stream.getParent().sendLivePlayStart(var2_2, this.stream.getParent().getName(), var42_71, this.sendOriginalTimecodes != false ? 0L : this.firstPacketTC);
                                                                                                                    this.sentPlayStart = true;
                                                                                                                    this.sendPlayStop = true;
                                                                                                                    this.stream.getParent().setSendPlayStopLogEvent(true);
                                                                                                                    WMSLoggerFactory.putGlobalLogValue((String)Base64.lastIndexOf((int)(288 / 48), (String)"~*{yex"), (Object)new Long(0L));
                                                                                                                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.lastIndexOf((int)(635 / 108), (String)"vrumhg"), "play", 200, this.stream.getParent().getName());
                                                                                                                    this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                                                                                                                    var5_5.setNew(true);
                                                                                                                    var3_3.setNew(true);
                                                                                                                    var4_4.setNew(true);
                                                                                                                }
                                                                                                                if (!this.sendPlaySwitch) break block31;
                                                                                                                this.sendPlaySwitch = false;
                                                                                                                var7_7 += this.stream.getParent().sendLivePlaySwitch(var2_2, var1_1.getName(), var42_71);
                                                                                                                var46_82 = var1_1.getMetaDataProvider();
                                                                                                                var47_89 = new ArrayList<E>();
                                                                                                                var48_96 = var28_31.getAbsTimecode();
                                                                                                                var46_82.onStreamStart(var47_89, var48_96);
                                                                                                                if (var47_89.size() <= 0) break block31;
                                                                                                                var50_130 = var47_89.iterator();
                                                                                                                ** GOTO lbl316
                                                                                                                break;
                                                                                                            }
                                                                                                            break;
                                                                                                        }
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                if (var24_26 == null) {
                                                                                                    var24_26 = new LiveTracker();
                                                                                                    var24_26.firstTC = var40_64;
                                                                                                }
                                                                                                var24_26.lastTC = var40_64;
                                                                                                var46_81 = false;
                                                                                                if (!this.sendFirstKeyFrame) ** GOTO lbl321
                                                                                                var47_87 = var1_1.getMetaDataProvider();
                                                                                                if (var47_87 != null) {
                                                                                                    var48_97 = new ArrayList<E>();
                                                                                                    var49_102 = var28_31.getAbsTimecode();
                                                                                                    var47_87.onStreamStart(var48_97, var49_102);
                                                                                                    if (var48_97.size() > 0) {
                                                                                                        var51_108 = null;
                                                                                                        var52_133 = null;
                                                                                                        var51_108 = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                                                                                                        var51_108.createSeekMessage(Base64.lastIndexOf((int)(-11 - 42), (String)"$\"\u001e:.$$!"));
                                                                                                        var51_108.setSrc(this.stream.getParent().getSrc());
                                                                                                        var51_108.setType(18);
                                                                                                        var51_108.setTimecode(var42_71);
                                                                                                        var52_133 = new AMFDataObj();
                                                                                                        var52_133.put(Base64.lastIndexOf((int)(121 / 31), (String)"`kac"), (AMFData)new AMFDataItem(Base64.lastIndexOf((int)(48 - -57), (String)"\u0007/?\u001f9<*1<|\u00175!7y\u000b-;)(")));
                                                                                                        var51_108.addBody((AMFData)var52_133);
                                                                                                        var7_7 += var51_108.write(var2_2, true, var18_21);
                                                                                                        for (AMFPacket var54_120 : var48_97) {
                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var54_120, var42_71, var5_5, this.workBuffer, var18_21);
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                                var48_95 = true;
                                                                                                if (var23_25 == null) {
                                                                                                    var23_25 = this.getLastKeyFrame(var1_1);
                                                                                                    var48_95 = false;
                                                                                                }
                                                                                                if (!var9_9) {
                                                                                                    var23_25 = null;
                                                                                                }
                                                                                                if (var23_25 == null) break block150;
                                                                                                if (this.sendFirstVideoFrame) {
                                                                                                    var49_104 = var1_1.getVideoCodecConfigPacket(var23_25.getAbsTimecode());
                                                                                                    if (var49_104 != null) {
                                                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var49_104, var42_71, var39_61, this.workBuffer, var18_21);
                                                                                                    }
                                                                                                    this.sendFirstVideoFrame = false;
                                                                                                    var46_81 = true;
                                                                                                }
                                                                                                if (!var46_81 || !this.isEnhancedSeekCapable) ** GOTO lbl263
                                                                                                v6 = this;
                                                                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v6.getEnhanceSeekPacket(v6.stream.getParent(), var23_25.getFirstByte(), true), var42_71, var39_61, this.workBuffer, var18_21);
                                                                                                ** continue;
                                                                                            }
                                                                                            var36_50 = var28_31.getSeq();
                                                                                            if (!(this.playLen > 0.0) || var42_71 < Math.round(this.playLen)) break block165;
                                                                                            if (this.stream.getParent().isSendPlayStopLogEvent()) {
                                                                                                this.stream.getParent().setSendPlayStopLogEvent(false);
                                                                                                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), JSON.regionMatches((String)"wqtbid", (int)(953 / 209)), "stop", 200, this.stream.getParent().getName());
                                                                                                this.stream.getParent().notifyActionStop();
                                                                                            }
                                                                                            var7_7 += this.stream.getParent().sendPlayStatus(var2_2, var42_71, 2, 0.0, 0.0);
                                                                                            var7_7 += this.stream.getParent().sendPlayStop(var2_2, var42_71, this.stream.getParent().getName());
                                                                                            this.playlistEnd = true;
                                                                                            break block166;
                                                                                        }
                                                                                        ++var38_55;
                                                                                    }
                                                                                    if (var38_55 >= var27_29) break block166;
                                                                                    var28_31 = (AMFPacket)var15_15.get(var38_55);
                                                                                    var39_61 = null;
                                                                                    var40_64 = var28_31.getAbsTimecode();
                                                                                    var42_71 = 0L;
                                                                                    var44_129 = var28_31.getType();
                                                                                    var45_77 = 0;
                                                                                    if (var14_18 == null) break block167;
                                                                                    if (var44_129 == 9 && var14_18.switchVideoKeyFrameSeq >= 0L) ** GOTO lbl343
                                                                                }
                                                                                if (var14_18.switchTimecodeFound) break block166;
                                                                            }
                                                                            switch (var44_129) {
                                                                                case 8: {
                                                                                    if (var8_8) break block168;
                                                                                    ** GOTO lbl386
                                                                                }
                                                                                case 15: 
                                                                                case 18: {
                                                                                    if (this.firstPacketTC == -1L) {
                                                                                        var42_71 = 0L;
                                                                                        this.firstPacketTC = var40_64;
                                                                                        break;
                                                                                    }
                                                                                    var42_71 = var40_64 - this.firstPacketTC;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    WMSLoggerFactory.getLogger(MediaStreamLivePlay.class).info(Base64.lastIndexOf((int)(20 + 84), (String)"\u0001',$vm\u0019\u0002\u0003\u00037 $\u0006\"%=87(f}1*tqwwWlh`dl0+ycea\u007ff|3dtu|}m:oem{% ") + var28_31.getType());
                                                                                    ** GOTO lbl386
                                                                                }
                                                                                case 9: {
                                                                                    var46_80 = var28_31.getFirstByte();
                                                                                    var47_88 = FLVUtils.getVideoCodec((int)var46_80);
                                                                                    if (var9_9 || var47_88 == 7) break block169;
                                                                                    break block170;
                                                                                }
                                                                            }
                                                                            if (this.sendOriginalTimecodes) {
                                                                                var42_71 = var40_64;
                                                                            }
                                                                            if (var42_71 < 0L) {
                                                                                var42_71 = 0L;
                                                                            }
                                                                            var39_61 = var5_5;
                                                                            this.lastTC = var42_71;
                                                                            this.lastDataTC = var42_71;
                                                                            var6_6[4] = var6_6[4] + (long)var28_31.getSize();
                                                                            var6_6[5] = var6_6[5] + 1L;
                                                                            ** GOTO lbl386
                                                                        }
                                                                        if (var20_23) ** GOTO lbl386
                                                                        if (this.firstPacketTC == -1L) {
                                                                            var42_71 = 0L;
                                                                            this.firstPacketTC = var40_64;
                                                                        } else {
                                                                            var42_71 = var40_64 - this.firstPacketTC;
                                                                        }
                                                                        if (this.sendOriginalTimecodes) {
                                                                            var42_71 = var40_64;
                                                                        }
                                                                        break block171;
                                                                    }
                                                                    if (var19_22 == 0 || var19_22 == 1) {
                                                                        ** continue;
                                                                    }
                                                                    break block145;
                                                                }
                                                                if (var47_88 != 12) ** GOTO lbl386
                                                            }
                                                            if (var19_22 != 7) ** continue;
                                                            v5 = true;
                                                            ** continue;
                                                        }
                                                        if (var42_71 < 0L) ** GOTO lbl386
                                                        var39_61 = var3_3;
                                                        this.lastTC = var42_71;
                                                        this.lastAudioTC = var42_71;
                                                        var45_77 = var28_31.getSize();
                                                        var6_6[0] = var6_6[0] + (long)var45_77;
                                                        var6_6[1] = var6_6[1] + 1L;
                                                        ** continue;
                                                    }
                                                    if (var36_50 == -1L) ** GOTO lbl278
                                                    this.lastSeq = var36_50;
                                                    ** continue;
                                                    while (true) {
                                                        this.b.e = var47_90;
                                                        this.b.f = var42_71;
                                                        ++this.b.h;
                                                        this.b.g = var42_71;
                                                        break block147;
                                                        break;
                                                    }
                                                    break;
                                                }
                                                var41_66 = var56_124;
                                                break block141;
                                                block38: while (true) {
                                                    if (var55_123.getSize() < 5) ** GOTO lbl244
                                                    var55_123 = var55_123.clone(true);
                                                    var56_128 = var55_123.getData();
                                                    var57_135 = FLVUtils.getVideoTimecodeOffset((byte[])var56_128);
                                                    var57_135 = (int)((long)var57_135 + (var55_123.getAbsTimecode() - var28_31.getAbsTimecode()));
                                                    BufferUtils.intToByteArray((int)var57_135, (byte[])var56_128, (int)2, (int)3);
lbl564:
                                                    // 2 sources

                                                    var6_6[2] = var6_6[2] + (long)var55_123.getSize();
                                                    var6_6[3] = var6_6[3] + 1L;
                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var55_123, var42_71, var4_4, this.workBuffer, var18_21);
                                                    ++var53_113;
lbl568:
                                                    // 2 sources

                                                    do {
                                                        ++var54_119;
lbl570:
                                                        // 2 sources

                                                        if (var54_119 >= var38_55) break block38;
                                                    } while ((var55_123 = (AMFPacket)var15_15.get(var54_119)).getType() != 9);
                                                    if (var49_100 == 7 || var49_100 == 12) ** break;
                                                    ** continue;
                                                }
                                            }
                                            if (var46_81 && this.isEnhancedSeekCapable) {
                                                v7 = this;
                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v7.getEnhanceSeekPacket(v7.stream.getParent(), var23_25.getFirstByte(), false), var42_71, var39_61, this.workBuffer, var18_21);
                                            }
                                            var46_81 = false;
                                        }
                                        this.trackerStartSeq = var24_26.trackerSeq;
                                        this.sendFirstKeyFrame = false;
                                        this.lastReceiveAudio = var8_8;
                                        this.lastReceiveVideo = var9_9;
                                        this.lastReceiveVideoFPS = var10_10;
                                    }
                                    if (this.sendFirstAudioFrame || this.sendFirstVideoFrame) {
                                        if (var44_129 == 8 && this.sendFirstAudioFrame) {
                                            var47_92 = new AMFPacket(8, var1_1.getSrc(), 0);
                                            if (var47_92 != null) {
                                                var6_6[0] = var6_6[0] + 0L;
                                                var6_6[1] = var6_6[1] + 1L;
                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var47_92, var42_71, var3_3, this.workBuffer, var18_21);
                                                var3_3.setNew(true);
                                            }
                                            if ((var48_98 = var1_1.getAudioCodecConfigPacket(var28_31.getAbsTimecode())) != null) {
                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var48_98, var42_71, var39_61, this.workBuffer, var18_21);
                                            }
                                            this.sendFirstAudioFrame = false;
                                        } else if (var44_129 == 9 && this.sendFirstVideoFrame) {
                                            var47_86 = var1_1.getVideoCodecConfigPacket(var28_31.getAbsTimecode());
                                            if (var47_86 != null) {
                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var47_86, var42_71, var39_61, this.workBuffer, var18_21);
                                            }
                                            this.sendFirstVideoFrame = false;
                                            var46_81 = true;
                                        }
                                    }
                                    if (this.b == null) break block147;
                                    var47_90 = System.currentTimeMillis();
                                    if (var44_129 == 8) break block172;
                                    if (var44_129 != 9) break block147;
                                    if (this.b.d >= 30) break block173;
                                    this.b.a = var47_90;
                                    this.b.b = var42_71;
                                    this.b.c = var42_71;
                                    ++this.b.d;
                                    break block147;
                                }
                                if (this.b.h < 30) ** continue;
                                var49_103 = StringUtils.intToHexStr((int)(var28_31.getFirstByte() & 255), (int)2);
                                var50_130 = StringUtils.intToStr((int)var28_31.getSize(), (int)5);
                                var51_109 = this.b.e + (var42_71 - this.b.f) - var47_90;
                                var53_116 = var51_109 + "";
                                if (var51_109 > 0L) {
                                    var53_116 = " " + var51_109;
                                }
                                var54_121 = var42_71 - this.b.g;
                                var56_127 = Base64.lastIndexOf((int)(30 + 88), (String)"\u001a>.<\n7=$;-.`wgmj]") + this.stream.getParent().getContextStr() + JSON.regionMatches((String)"\u0017ql%*=ja*", (int)(85 + -11)) + var49_103 + JSON.regionMatches((String)".|j+", (int)(-6 - -52)) + (String)var50_130 + JSON.regionMatches((String)"#pf", (int)(525 / 175)) + var42_71 + "/" + var54_121 + ":" + var47_90 + ":" + var53_116;
                                if (this.isDebugLog) {
                                    WMSLoggerFactory.getLogger(null).debug(var56_127);
                                } else {
                                    WMSLoggerFactory.getLogger(null).info(var56_127);
                                }
                                this.b.g = var42_71;
                            }
                            if (var46_81 && this.isEnhancedSeekCapable) {
                                v8 = this;
                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v8.getEnhanceSeekPacket(v8.stream.getParent(), var28_31.getFirstByte(), true), var42_71, var39_61, this.workBuffer, var18_21);
                            }
                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var28_31, var42_71, var39_61, this.workBuffer, var18_21);
                            if (!var46_81 || !this.isEnhancedSeekCapable) ** GOTO lbl383
                            v9 = this;
                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v9.getEnhanceSeekPacket(v9.stream.getParent(), var28_31.getFirstByte(), false), var42_71, var39_61, this.workBuffer, var18_21);
                            ** continue;
                        }
                        var49_101 = StringUtils.intToHexStr((int)(var28_31.getFirstByte() & 255), (int)2);
                        var50_132 = StringUtils.intToStr((int)var28_31.getSize(), (int)5);
                        var51_107 = this.b.a + (var42_71 - this.b.b) - var47_90;
                        var53_114 = var51_107 + "";
                        if (var51_107 <= 0L) ** GOTO lbl334
                        var53_114 = " " + var51_107;
                        ** continue;
lbl647:
                        // 1 sources

                        if (var41_66 - var56_124 < var51_106) break block141;
                        var53_111 = var54_117;
                        ** GOTO lbl300
                    }
                    --var54_117;
                }
                if (var54_117 >= 0) ** break;
                ** continue;
                var28_31 = (AMFPacket)var37_52.get(var54_117);
                var55_122 = var28_31.getType();
                var56_124 = var28_31.getAbsTimecode();
                if (var55_122 != 8) ** continue;
                if (var41_66 != -1L) ** GOTO lbl647
            }
        }
    }

    @Override
    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        if (this.playLen != 0.0) {
            return this.playAll(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return this.playKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null) return n;
        return n += this.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    @Override
    public boolean play(IMediaStream iMediaStream) {
        return this.stream.getParent().isOpen();
        {
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean play() {
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null && this.sendStreamNotFound) {
            this.stream.getParent().sendStreamNotFound(this.stream.getParent().getName());
        }
        this.sendStreamNotFound = false;
        if (iMediaStream != null) return true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resetInternal(boolean bl, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            this.lastAudioTC = -1L;
            this.lastVideoTC = -1L;
            this.lastDataTC = -1L;
            this.lastTC = -1L;
            this.firstPacketTC = -1L;
            this.sendFirstKeyFrame = true;
            this.checkStreamProperties = true;
            this.sendFirstVideoFrame = true;
            this.sendFirstAudioFrame = true;
            this.sentPlayStart = false;
            this.lastSendTime = -1L;
            this.waitForKeyFrame = true;
            this.lastTCOffset = 0L;
            this.lastSentLiveTracker = null;
            this.trackerStartSeq = -1L;
            this.trackerBufferTime = 0L;
            this.lastReceiveAudio = true;
            this.lastReceiveVideo = true;
            this.lastReceiveVideoFPS = -1;
            this.playlistEnd = false;
            this.bufferEmptyOnce = false;
            this.sendStreamNotFound = true;
            this.waitForBufferFillStarTime = -1L;
            this.liveSwitch.set(null);
            this.sendPlaySwitch = false;
            if (!bl2) return;
            IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            if (iMediaStream == null) return;
            AMFPacket aMFPacket = this.getLastPacket(iMediaStream);
            if (aMFPacket == null) return;
            this.lastSeq = aMFPacket.getSeq();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resetNoLookup() {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)Base64.lastIndexOf((int)(29 * 53), (String)"y/ptju"), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), JSON.regionMatches((String)"ppwcfe", (int)(59 * 57)), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reset(boolean bl) {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)JSON.regionMatches((String)"\u007f%zzd\u007f", (int)(38 + 1)), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), JSON.regionMatches((String)"*.)9<3", (int)(7 * 31)), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(bl, true);
    }

    @Override
    public void pause(int n, long l) {
    }

    @Override
    public void pauseRaw(int n, long l) {
    }

    @Override
    public void seek(int n) {
    }

    @Override
    public void setBufferTime(int n) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void stopName(String string, String string2, String string3, String string4, double d, double d2, int n) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        IMediaStream iMediaStream = this.stream.getParent();
        IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
        String string5 = this.stream.getParent().getStreamType();
        boolean bl = false;
        StreamList streamList = iApplicationInstance.getVHost().getStreamTypes();
        StreamItem streamItem = streamList.getStreamDef(string5);
        if (streamItem != null) {
            bl = streamItem.getProperties().getPropertyBoolean(Base64.lastIndexOf((int)(15 * 3), (String)"d}CygwAqesvl|h^xz{"), bl);
        }
        if (bl) {
            string = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, (IClient)iMediaStream.getClient(), (String)string);
        }
        this.liveSwitch.set(new LivePlayerSwitch(string, string2, n));
    }

    @Override
    public void setName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        this.playStart = d;
        this.playLen = d2;
        this.playTransition = n;
    }

    @Override
    public void interruptPlay() {
    }

    @Override
    public void startPlay() {
    }

    @Override
    public void switchPlay() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateLoggingValues() {
        long l = this.lastTC;
        if (l < 0L) {
            l = 0L;
        }
        if (WMSLoggerFactory.isGlobalLogValueSet((String)JSON.regionMatches((String)"w=bb|g", (int)(63 * 49)))) return;
        WMSLoggerFactory.putGlobalLogValue((String)Base64.lastIndexOf((int)(10 - -24), (String)"z.wuit"), (Object)new Long(l));
    }

    @Override
    public double length() {
        return 0.0;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public long getLastTimecodeOffset() {
        return this.lastTCOffset;
    }

    @Override
    public long getLastSentVideoTC() {
        return this.lastVideoTC;
    }

    @Override
    public long getLastSentAudioTC() {
        return this.lastAudioTC;
    }

    @Override
    public long getLastSentDataTC() {
        return this.lastDataTC;
    }

    @Override
    public int getLastVideoFilter() {
        return this.lastTCFilter;
    }

    protected class LiveTracker {
        public long totalLen = 0L;
        public long firstTC = -1L;
        public long lastTC = -1L;
        public long trackerSeq = 0L;

        public LiveTracker() {
            this.trackerSeq = ++LivePlayer.this.trackerSeqSource;
        }
    }

    private class PacketTimecodeDebug {
        long a = -1L;
        long b = -1L;
        long c = -1L;
        int d = 0;
        long e = -1L;
        long f = -1L;
        long g = -1L;
        int h = 0;
        long i = -1L;

        private PacketTimecodeDebug() {
        }
    }
}

