/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.updatetool;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.wowza.updatetool.BackupCreator;
import com.wowza.updatetool.FileUtil;
import com.wowza.updatetool.Messages;
import com.wowza.updatetool.ReleaseInfo;
import com.wowza.updatetool.VersionCheck;
import com.wowza.updatetool.manifest.UpdateManifest;
import com.wowza.updatetool.manifest.UpdateManifestEntry;
import com.wowza.updatetool.manifest.builder.ManifestBuilder;
import com.wowza.updatetool.manifest.builder.ManifestBuilderConfig;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class UpdateInstaller {
    private static final String WMS_VERSION_JAR = "lib/wms-bootstrap.jar";
    private boolean isUninstall = false;
    private final Console c = System.console();
    private UpdateManifest updateManifest = null;
    private String installDir = "../../..";
    private static final String NOTICES_TXT_FILENAME = "/notices.txt";
    private static final String EULA_TXT_FILENAME = "/eula.txt";
    private static final String UPDATE_MANIFEST_FILENAME = "/updatemanifest.umf";
    private static final Logger LOG;

    public static void main(String[] args) {
        if (args.length > 0) {
            boolean displayEULA = true;
            boolean interactive = true;
            boolean createManifest = false;
            UpdateInstaller installer = new UpdateInstaller();
            for (int argc = 0; argc < args.length; ++argc) {
                if (args[argc].startsWith("-d")) {
                    installer.setInstallDir(args[++argc].replace("\\\\", "/"));
                    continue;
                }
                if (args[argc].startsWith("-u")) {
                    installer.setUninstall(true);
                    continue;
                }
                if (args[argc].startsWith("-c")) {
                    createManifest = true;
                    continue;
                }
                if (args[argc].toLowerCase().startsWith("-noeula")) {
                    displayEULA = false;
                    LOG.info(Messages.get("update.skipEula"));
                    continue;
                }
                if (args[argc].toLowerCase().startsWith("-noninteractive")) {
                    interactive = false;
                    LOG.info(Messages.get("update.skipNonInteractive"));
                    continue;
                }
                if (!args[argc].startsWith("-h")) continue;
                UpdateInstaller.printUsage();
                System.exit(0);
            }
            if (createManifest) {
                LOG.info("Creating Manifest new manifest from " + installer.getInstallDir() + " and exiting.");
                installer.createManifest();
                System.exit(0);
            }
            String versionFileName = installer.getInstallDir() + "/" + WMS_VERSION_JAR;
            String updateVersionFileName = "../files/lib/wms-bootstrap.jar";
            UpdateInstaller.validateUpdateVersionGreaterThanInstalledVersion(versionFileName, updateVersionFileName);
            String installDirName = null;
            String installedVersionStr = null;
            try {
                File test = new File(installer.getInstallDir());
                installDirName = test.getCanonicalFile().toString();
                installedVersionStr = UpdateInstaller.getVersionString(versionFileName);
                LOG.info("");
                if (installer.isUninstall) {
                    LOG.info(String.format(Messages.get("update.uninstallVersion"), installedVersionStr));
                    LOG.info("");
                    LOG.info(String.format(Messages.get("update.uninstallationDir"), installDirName));
                } else {
                    LOG.info(String.format(Messages.get("update.updateInstallDir"), installDirName));
                    LOG.info("");
                    LOG.info(String.format(Messages.get("update.currentVersion"), installedVersionStr));
                    LOG.info("");
                    LOG.info(String.format(Messages.get("update.newVersion"), UpdateInstaller.getVersionString(updateVersionFileName)));
                }
                LOG.info("");
            }
            catch (IOException e) {
                LOG.error(String.format(Messages.get("update.installDirDNE"), installer.getInstallDir()));
                System.exit(-1);
            }
            if (interactive && !installer.isUninstall) {
                if (installer.userWantsToAbort()) {
                    LOG.info(Messages.get("update.userAborted"));
                    System.exit(-1);
                }
                if (displayEULA) {
                    installer.displayNotices();
                    if (!installer.acceptEULAIfPresent()) {
                        LOG.info(Messages.get("update.userDeclinedEULA"));
                        System.exit(-1);
                    }
                }
            }
            String osFilter = null;
            String os = System.getProperty("com.wowza.wms.native.base");
            if (os != null) {
                if (os.startsWith("win")) {
                    osFilter = "windows";
                } else if (os.startsWith("linux")) {
                    osFilter = "linux";
                } else if (os.startsWith("osx")) {
                    osFilter = "mac";
                } else {
                    LOG.error(Messages.get("update.unknownOS"));
                    System.exit(-1);
                }
            } else {
                LOG.error(Messages.get("update.unknownOS"));
                System.exit(-1);
            }
            LOG.info(String.format(Messages.get("update.detectedOS"), osFilter));
            installer.run(osFilter);
        } else {
            UpdateInstaller.printUsage();
        }
    }

    private static void validateUpdateVersionGreaterThanInstalledVersion(String versionFileName, String updateVersionFileName) {
        try {
            int majorVersion;
            String wowzaVersion = UpdateInstaller.getJarManifestProperty(versionFileName, Attributes.Name.IMPLEMENTATION_VERSION);
            String[] versionBits = wowzaVersion.split("\\.");
            if (versionBits.length >= 0 && (majorVersion = Integer.parseInt(versionBits[0])) < 4) {
                LOG.error(Messages.get("update.oldVersionWMS"));
                System.exit(-1);
            }
            int installedBuild = UpdateInstaller.getBuildNumber(versionFileName);
            int updateBuild = UpdateInstaller.getBuildNumber(updateVersionFileName);
            if (updateBuild < installedBuild) {
                LOG.error(Messages.get("update.installedNewerThanUpdateVersion"));
                LOG.info(String.format(Messages.get("update.installedVersion"), installedBuild));
                LOG.info(String.format(Messages.get("update.updateVersion"), updateBuild));
                System.exit(-1);
            }
        }
        catch (Exception e) {
            LOG.warn(Messages.get("update.errorDetectingVersion"));
            LOG.debug(Messages.get("update.debugErrorDetectingVersion"), e);
            System.exit(-1);
        }
    }

    private void uninstall(String osFilter) {
        if (!this.installedVersionSameAsUpdateVersion()) {
            LOG.error(Messages.get("update.uninstallVersionDoesNotMatch"));
            return;
        }
        String backupDir = this.installDir + "/" + "updates" + "/" + "backup" + "/";
        String name = backupDir + ReleaseInfo.getVersion() + ".zip";
        File restoreFrom = new File(name);
        HashMap<Integer, File> indexToFile = new HashMap<Integer, File>();
        int attempt = 0;
        while (restoreFrom.exists()) {
            LOG.info(String.format(Messages.get("update.detectedBackupFile"), restoreFrom.getName()));
            indexToFile.put(attempt, restoreFrom);
            restoreFrom = new File(backupDir + ReleaseInfo.getVersion() + "-" + ++attempt + ".zip");
        }
        if (indexToFile.size() == 1) {
            try {
                LOG.info(String.format(Messages.get("update.restoreFromFile"), ((File)indexToFile.get(0)).getCanonicalPath()));
                LOG.info(String.format(Messages.get("update.restoreToVersion"), this.getVersionFromFile((File)indexToFile.get(0))));
                this.rollback(((File)indexToFile.get(0)).getCanonicalPath(), osFilter, true);
                LOG.info(Messages.get("update.restoreComplete"));
            }
            catch (IOException e) {
                LOG.error(String.format(Messages.get("update.errorRestoring"), ((File)indexToFile.get(0)).getAbsolutePath()), e);
            }
        } else if (indexToFile.size() > 1) {
            try {
                restoreFrom = this.getFileFromUser(indexToFile);
                LOG.info(String.format(Messages.get("update.restoreFromFile"), restoreFrom.getCanonicalPath()));
                LOG.info(String.format(Messages.get("update.restoreToVersion"), this.getVersionFromFile(restoreFrom)));
                this.rollback(restoreFrom.getCanonicalPath(), osFilter, true);
                LOG.info(Messages.get("update.restoreComplete"));
            }
            catch (IOException e) {
                LOG.error(String.format(Messages.get("update.errorRestoring"), restoreFrom.getAbsolutePath()), e);
            }
        } else {
            LOG.warn(Messages.get("update.noBackupFilesFound"));
        }
    }

    private void run(String osFilter) {
        block9: {
            if (!this.loadManifest()) break block9;
            if (this.isUninstall) {
                this.uninstall(osFilter);
                return;
            }
            LOG.info(Messages.get("update.checkVersions"));
            VersionCheck checker = new VersionCheck();
            checker.setOsFilter(osFilter);
            checker.setInstallDir(this.installDir);
            checker.setManifest(this.updateManifest);
            if (!checker.checkVersions()) {
                ArrayList<String> warnings;
                ArrayList<String> errors = checker.getErrors();
                if (errors != null) {
                    for (String error : errors) {
                        LOG.debug("Error: " + error);
                    }
                }
                if ((warnings = checker.getWarnings()) != null) {
                    for (String warning : warnings) {
                        LOG.debug("Warning: " + warning);
                    }
                }
                LOG.error(Messages.get("update.failedVersionCheck"));
            } else {
                String backupName = this.backupFiles(osFilter);
                try {
                    LOG.info(Messages.get("update.updateProceeding"));
                    this.updateOrCreateFiles(osFilter);
                    this.deleteFiles(osFilter);
                }
                catch (Exception e) {
                    LOG.error(Messages.get("update.cannotComplete"));
                    LOG.debug(Messages.get("update.generalError"), e);
                    this.rollback(backupName, osFilter, false);
                    break block9;
                }
                this.updateFileOwnerAndPermissions(osFilter);
                LOG.info(Messages.get("update.completedSuccessfully"));
                LOG.info(Messages.get("update.dontlosethis").replaceAll("%n", System.getProperty("line.separator")));
            }
        }
    }

    private void updateFileOwnerAndPermissions(String osFilter) {
        LOG.info(Messages.get("update.restoreFilePermissions"));
        try {
            ProcessBuilder pb = null;
            if (osFilter.equals("windows")) {
                if (new File("updatepermissions.bat").exists()) {
                    pb = new ProcessBuilder("updatepermissions.bat", this.installDir);
                } else {
                    LOG.error(Messages.get("update.updatePermissionsScriptNotFound"));
                }
            } else if (new File("updatepermissions.sh").exists()) {
                pb = new ProcessBuilder("/bin/bash", "updatepermissions.sh", osFilter, this.installDir);
            } else {
                LOG.error(Messages.get("update.updatePermissionsScriptNotFound"));
            }
            pb.redirectErrorStream(true);
            pb.start();
        }
        catch (IOException e) {
            LOG.info(Messages.get("update.restorePermissionsFailed"));
            LOG.debug(Messages.get("update.generalError"), e);
        }
    }

    private void rollback(String backupFileName, String osFilter, boolean askUser) {
        if (askUser && this.userWantsToAbort()) {
            LOG.debug(Messages.get("update.userAborted"));
            return;
        }
        try {
            Iterator<UpdateManifestEntry> entries = this.updateManifest.iteratorByActionAndOS(osFilter, "install");
            while (entries.hasNext()) {
                UpdateManifestEntry entry = entries.next();
                String dstFileName = this.installDir + "/" + entry.getDestination();
                try {
                    File dstFile = new File(dstFileName);
                    if (!dstFile.exists()) continue;
                    dstFile.delete();
                }
                catch (Exception e) {
                    LOG.warn(String.format(Messages.get("update.couldNotRestoreFile"), dstFileName), e);
                }
            }
            LOG.info(String.format(Messages.get("update.restoreFromFile"), backupFileName));
            File backupFile = new File(backupFileName);
            if (backupFile.exists()) {
                this.restoreFromBackup(backupFile);
            } else {
                LOG.error(Messages.get("update.noBackupFilesFound"));
            }
        }
        catch (Exception e) {
            LOG.error(Messages.get("update.generalError"), e);
        }
    }

    private void restoreFromBackup(File backupFile) {
        byte[] buffer = new byte[4096];
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(backupFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(this.installDir + "/" + fileName);
                LOG.debug(String.format(Messages.get("update.restoringFile"), newFile.getCanonicalPath()));
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            LOG.error(String.format(Messages.get("update.errorRestoring"), backupFile.getAbsolutePath()));
            LOG.debug(Messages.get("update.generalError"), ex);
        }
    }

    private void updateOrCreateFiles(String osFilter) throws IOException {
        ArrayList<String> actionFilters = new ArrayList<String>(){
            {
                this.add("install");
                this.add("update");
            }
        };
        Iterator<UpdateManifestEntry> entries = this.updateManifest.iteratorByActionAndOS(osFilter, (List<String>)actionFilters);
        while (entries.hasNext()) {
            UpdateManifestEntry entry = entries.next();
            LOG.debug(String.format(Messages.get("update.updatingFile"), entry.getDestination()));
            String srcFileName = "../files/" + entry.getSourceFile();
            String dstFileName = this.installDir + "/" + entry.getDestination();
            File srcFile = new File(srcFileName);
            File dstFile = new File(dstFileName);
            if (!srcFile.exists()) {
                LOG.debug(String.format(Messages.get("update.sourceFileNotFound"), srcFileName));
            }
            FileUtil.copyFile(srcFile, dstFile);
        }
    }

    private void deleteFiles(String osFilter) throws IOException {
        Iterator<UpdateManifestEntry> entries = this.updateManifest.iteratorByActionAndOS(osFilter, "delete");
        while (entries.hasNext()) {
            UpdateManifestEntry entry = entries.next();
            LOG.debug(String.format(Messages.get("update.deleteFile"), entry.getDestination()));
            String dstFileName = this.installDir + "/" + entry.getDestination();
            File dstFile = new File(dstFileName);
            if (!dstFile.exists() || dstFile.delete()) continue;
            LOG.error(String.format(Messages.get("update.cannotDeleteFile"), dstFileName));
            throw new IOException("Cannot delete: " + dstFileName);
        }
    }

    private String backupFiles(String osFilter) {
        LOG.info(Messages.get("update.creatingBackup"));
        ArrayList<String> actionFilters = new ArrayList<String>(){
            {
                this.add("delete");
                this.add("update");
            }
        };
        Iterator<UpdateManifestEntry> entries = this.updateManifest.iteratorByActionAndOS(osFilter, (List<String>)actionFilters);
        ArrayList<UpdateManifestEntry> backupFiles = new ArrayList<UpdateManifestEntry>();
        while (entries.hasNext()) {
            UpdateManifestEntry entry = entries.next();
            backupFiles.add(entry);
        }
        BackupCreator backup = new BackupCreator(backupFiles, this.installDir, ReleaseInfo.getVersion());
        if (!backup.backup()) {
            LOG.error(Messages.get("update.backupFailed"));
            System.exit(-1);
        }
        return backup.getBackupFileName();
    }

    private boolean loadManifest() {
        boolean retVal = false;
        InputStream inStream = UpdateInstaller.class.getResourceAsStream(UPDATE_MANIFEST_FILENAME);
        try {
            this.updateManifest = UpdateManifest.readManifest(inStream);
            retVal = true;
        }
        catch (JsonParseException e) {
            this.updateManifest = null;
            LOG.error(Messages.get("update.manifestError"), e);
        }
        catch (JsonMappingException e) {
            this.updateManifest = null;
            LOG.error(Messages.get("update.manifestError"), e);
        }
        catch (IOException e) {
            this.updateManifest = null;
            LOG.error(Messages.get("update.manifestError"), e);
        }
        return retVal;
    }

    private static void configureLogging() {
        try {
            Properties prop = new Properties();
            prop.load(UpdateInstaller.class.getResourceAsStream("log4j.properties"));
            PropertyConfigurator.configure(prop);
        }
        catch (Exception e) {
            BasicConfigurator.configure();
        }
    }

    public static void printUsage() {
        String ver = "";
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    URL url = resEnum.nextElement();
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    Manifest manifest = new Manifest(is);
                    Attributes mainAttribs = manifest.getMainAttributes();
                    ver = mainAttribs.getValue("Specification-Version");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            ver = "";
        }
        System.out.println(String.format(Messages.get("usage"), ver));
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String path) {
        this.installDir = path.replaceAll("\\\\", "/");
    }

    public void setUninstall(boolean uninstall) {
        LOG.debug("uninstall set to: " + uninstall);
        this.isUninstall = uninstall;
    }

    public boolean isUninsitall() {
        return this.isUninstall;
    }

    private boolean userWantsToAbort() {
        LOG.info(Messages.get("update.continuePrompt"));
        return !this.yesNo();
    }

    private boolean yesNo() {
        Scanner scanner = new Scanner(System.in);
        if (scanner.hasNext()) {
            String line = scanner.next();
            return line.matches("([yY])|([yY][eE][sS])");
        }
        return false;
    }

    private void displayNotices() {
        this.displayFile(NOTICES_TXT_FILENAME);
        LOG.info(Messages.get("update.pausePrompt"));
        this.readLine();
    }

    private String readLine() {
        if (this.c != null) {
            return this.c.readLine();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            LOG.error("Error reading from console", e);
            return null;
        }
    }

    private boolean acceptEULAIfPresent() {
        if (this.displayFile(EULA_TXT_FILENAME)) {
            LOG.info(Messages.get("update.acceptEula"));
            return this.yesNo();
        }
        return true;
    }

    private boolean displayFile(String file) {
        try {
            InputStream inStream = UpdateInstaller.class.getResourceAsStream(file);
            if (inStream == null) {
                LOG.debug("No notices to display");
                return false;
            }
            InputStreamReader reader = new InputStreamReader(inStream, "UTF-8");
            BufferedReader br = new BufferedReader(reader);
            int outcount = 0;
            while (br.ready()) {
                LOG.info(br.readLine());
                if (++outcount <= 24) continue;
                LOG.info(Messages.get("update.pausePrompt"));
                this.readLine();
                outcount = 0;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Error displaying file " + file, e);
            return false;
        }
    }

    private void createManifest() {
        File configFile = new File("ManifestBuilderConfig.json");
        ManifestBuilderConfig config = ManifestBuilderConfig.loadConfig(configFile);
        File manifestFile = new File("updatemanifest.umf");
        File srcDir = new File(this.installDir);
        if (!srcDir.exists()) {
            try {
                System.out.println("Install doesn't exists: " + srcDir.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            UpdateManifest newMF = ManifestBuilder.buildManifest(srcDir, config);
            if (this.loadManifest()) {
                UpdateManifest currMF = (UpdateManifest)this.updateManifest.clone();
                UpdateManifest installDirMF = newMF;
                newMF = new UpdateManifest();
                for (UpdateManifestEntry entry : this.updateManifest) {
                    if (!installDirMF.contains(entry)) continue;
                    entry.setAction("update");
                    newMF.addManifestEntry(entry);
                    installDirMF.removeEntry(entry);
                    currMF.removeEntry(entry);
                }
                for (UpdateManifestEntry entry : installDirMF) {
                    entry.setAction("install");
                    entry.setMinimumVersion(null);
                    newMF.addManifestEntry(entry);
                    System.out.println("Changed to Install: " + entry);
                }
                for (UpdateManifestEntry entry : currMF) {
                    entry.setAction("delete");
                    entry.setMinimumVersion(null);
                    newMF.addManifestEntry(entry);
                    System.out.println("Added for Delete: " + entry);
                }
            }
            newMF.writeManifest(manifestFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getFileFromUser(Map<Integer, File> indexToFile) {
        ArrayList<Integer> indices = new ArrayList<Integer>(indexToFile.keySet());
        Collections.sort(indices);
        for (Integer idx : indices) {
            File fname = indexToFile.get(idx);
            String version = this.getVersionFromFile(fname);
            LOG.info(String.format("%d: %s ( %s )", idx + 1, version, fname.getName()));
        }
        LOG.info(String.format(Messages.get("backup.selectFileToUse"), indices.size()));
        while (true) {
            try {
                String resp;
                int idx;
                do {
                    if (!(resp = this.readLine()).equalsIgnoreCase("q")) continue;
                    LOG.info(Messages.get("update.userAborted"));
                    System.exit(-1);
                } while ((idx = Integer.parseInt(resp)) > indices.size() || idx <= 0);
                return indexToFile.get(idx - 1);
            }
            catch (Exception e) {
                LOG.debug("User entered invalid selection", e);
                continue;
            }
            break;
        }
    }

    private String getVersionFromFile(File backupFile) {
        if (!backupFile.exists() || !backupFile.isFile()) {
            LOG.error(Messages.get("backup.badBackupFile"));
            return "Unknown";
        }
        String version = "Not found";
        try {
            ZipFile zip = new ZipFile(backupFile);
            Enumeration<? extends ZipEntry> zipE = zip.entries();
            while (zipE.hasMoreElements()) {
                ZipEntry ze = zipE.nextElement();
                if (!ze.getName().endsWith(WMS_VERSION_JAR)) continue;
                JarInputStream jarIn = new JarInputStream(zip.getInputStream(ze));
                Manifest fileMan = jarIn.getManifest();
                Attributes fileAtr = fileMan.getMainAttributes();
                version = UpdateInstaller.toVersionString(fileAtr.getValue(Attributes.Name.SPECIFICATION_TITLE), fileAtr.getValue(Attributes.Name.SPECIFICATION_VERSION), fileAtr.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                jarIn.close();
                LOG.debug(String.format("Read version %s from file %s", version, backupFile));
                break;
            }
            zip.close();
            return version;
        }
        catch (IOException ex) {
            LOG.error(String.format(Messages.get("update.errorReadingFileVersion"), backupFile.getAbsolutePath()));
            LOG.debug("IOException", ex);
            return "Unknown";
        }
    }

    public static String toVersionString(String specTitle, String specVersion, String implVersion) {
        return String.format("%s %s - Build %s", specTitle, specVersion, implVersion);
    }

    private boolean installedVersionSameAsUpdateVersion() {
        LOG.debug(Messages.get("update.verifyVersions"));
        String installedVersion = "install";
        String updateVersion = "update";
        String versionFileName = this.installDir + "/" + WMS_VERSION_JAR;
        try {
            installedVersion = UpdateInstaller.getVersionString(versionFileName);
            LOG.debug(String.format(Messages.get("update.installedVersion"), installedVersion));
            versionFileName = "../files/lib/wms-bootstrap.jar";
            updateVersion = UpdateInstaller.getVersionString(versionFileName);
            LOG.debug(String.format(Messages.get("update.updateVersion"), updateVersion));
            return installedVersion.equals(updateVersion);
        }
        catch (Exception e) {
            LOG.error(Messages.get("update.failedVersionCheck"));
            LOG.error(String.format(Messages.get("update.errorReadingFileVersion"), versionFileName));
            return false;
        }
    }

    public static String getVersionString(String versionFileName) throws IOException {
        JarFile instJar = new JarFile(versionFileName);
        Manifest mf = instJar.getManifest();
        Attributes fileAtr = mf.getMainAttributes();
        String installedVersion = UpdateInstaller.toVersionString(fileAtr.getValue(Attributes.Name.SPECIFICATION_TITLE), fileAtr.getValue(Attributes.Name.SPECIFICATION_VERSION), fileAtr.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
        return installedVersion;
    }

    public static int getBuildNumber(String versionFileName) throws IOException {
        int installedVersion = Integer.MAX_VALUE;
        try {
            installedVersion = Integer.parseInt(UpdateInstaller.getJarManifestProperty(versionFileName, Attributes.Name.IMPLEMENTATION_VERSION), 10);
        }
        catch (NumberFormatException e) {
            LOG.error(String.format(Messages.get("update.errorReadingFileVersion"), versionFileName), e);
        }
        return installedVersion;
    }

    public static String getJarManifestProperty(String jarFilename, Attributes.Name property) throws IOException {
        String retVal = null;
        JarFile instJar = new JarFile(jarFilename);
        Manifest mf = instJar.getManifest();
        Attributes fileAtr = mf.getMainAttributes();
        if (fileAtr.containsKey(property)) {
            retVal = fileAtr.getValue(property);
        }
        return retVal;
    }

    static {
        UpdateInstaller.configureLogging();
        LOG = Logger.getLogger(UpdateInstaller.class);
    }
}

