/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.updatetool;

import com.wowza.updatetool.Messages;
import com.wowza.updatetool.manifest.UpdateManifest;
import com.wowza.updatetool.manifest.UpdateManifestEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class VersionCheck {
    private String installDir;
    private UpdateManifest manifest;
    private ArrayList<String> errors;
    private ArrayList<String> warnings;
    private String osFilter;

    private void addError(String error) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        this.errors.add(error);
    }

    private void addWarning(String warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList();
        }
        this.warnings.add(warning);
    }

    public boolean checkVersions() {
        boolean retVal = true;
        ArrayList<String> actionFilters = new ArrayList<String>();
        actionFilters.add("update");
        actionFilters.add("delete");
        Iterator<UpdateManifestEntry> itr = this.manifest.iteratorByActionAndOS(this.osFilter, actionFilters);
        while (itr.hasNext()) {
            try {
                UpdateManifestEntry entry = itr.next();
                File file = new File(this.installDir + File.separator + entry.getDestination());
                if (file.exists()) {
                    if (!file.getName().toLowerCase().endsWith(".jar") && !file.getName().toLowerCase().endsWith(".war")) continue;
                    String impVer = VersionCheck.getJarOrWarFileVersion(file);
                    if (this.checkVersion(entry.getMinimumVersion(), impVer)) continue;
                    this.addError(String.format(Messages.get("versionCheck.incorrectVersion"), file.getCanonicalPath(), impVer, entry.getMinimumVersion()));
                    continue;
                }
                this.addWarning(String.format(Messages.get("update.fileNotFound"), file.getCanonicalPath()));
            }
            catch (Exception e) {
                this.addError("checkVersions() Unexpected error: " + e);
            }
        }
        if (this.errors != null) {
            retVal = false;
        }
        return retVal;
    }

    public static String getJarOrWarFileVersion(File file) {
        String retVal = null;
        try {
            JarFile jar = new JarFile(file);
            Manifest fileMan = jar.getManifest();
            Attributes fileAtr = fileMan.getMainAttributes();
            retVal = fileAtr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            jar.close();
        }
        catch (Exception e) {
            retVal = null;
        }
        return retVal;
    }

    private boolean checkVersion(String minimumVersion, String currentVersion) {
        boolean retVal;
        block7: {
            retVal = false;
            if (minimumVersion == null) {
                retVal = true;
            } else {
                try {
                    Long minVer = Long.parseLong(minimumVersion);
                    Long curVer = Long.parseLong(currentVersion);
                    if (minVer > curVer) break block7;
                    retVal = true;
                }
                catch (Exception e) {
                    String[] minVer = minimumVersion.split("\\.");
                    String[] curVer = currentVersion.split("\\.");
                    int dots = Math.min(minVer.length, curVer.length);
                    for (int idx = 0; idx < dots; ++idx) {
                        retVal = true;
                        try {
                            int minDigit = Integer.parseInt(minVer[idx]);
                            int curDigit = Integer.parseInt(curVer[idx]);
                            if (minDigit <= curDigit) continue;
                            retVal = false;
                        }
                        catch (Exception ex) {
                            if (minimumVersion.equals(currentVersion)) break;
                            retVal = false;
                        }
                        break;
                    }
                }
            }
        }
        return retVal;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String installDir) {
        this.installDir = installDir;
    }

    public UpdateManifest getManifest() {
        return this.manifest;
    }

    public void setManifest(UpdateManifest manifest) {
        this.manifest = manifest;
    }

    public String getOsFilter() {
        return this.osFilter;
    }

    public void setOsFilter(String osFilter) {
        this.osFilter = osFilter;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public ArrayList<String> getWarnings() {
        return this.warnings;
    }
}

