/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.updatetool.manifest;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.wowza.updatetool.manifest.UpdateManifestEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UpdateManifest
implements Iterable<UpdateManifestEntry>,
Cloneable {
    public LinkedList<UpdateManifestEntry> entries = null;

    public static UpdateManifest readManifest(InputStream inStream) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        return mapper.readValue(inStream, UpdateManifest.class);
    }

    public void addManifestEntry(UpdateManifestEntry entry) {
        if (this.entries == null) {
            this.entries = new LinkedList();
        }
        this.entries.add(entry);
    }

    public void removeEntry(UpdateManifestEntry entry) {
        this.entries.remove(entry);
    }

    public void writeManifest(File file) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        try {
            mapper.writeValue(file, (Object)this);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Iterator<UpdateManifestEntry> iterator() {
        return new UpdateManifestIterator().iterator();
    }

    public Iterator<UpdateManifestEntry> iteratorByOS(String osDependency) {
        UpdateManifestIterator itr = new UpdateManifestIterator();
        itr.setOSFilter(osDependency);
        return itr.iterator();
    }

    public Iterator<UpdateManifestEntry> iteratorByAction(String action) {
        UpdateManifestIterator itr = new UpdateManifestIterator();
        itr.addActionFilter(action);
        return itr.iterator();
    }

    public Iterator<UpdateManifestEntry> iteratorByActionAndOS(String osFilter, String actionFilter) {
        UpdateManifestIterator itr = new UpdateManifestIterator();
        itr.setOSFilter(osFilter);
        itr.addActionFilter(actionFilter);
        return itr.iterator();
    }

    public Iterator<UpdateManifestEntry> iteratorByActionAndOS(String osFilter, List<String> actionFilters) {
        UpdateManifestIterator itr = new UpdateManifestIterator();
        itr.setOSFilter(osFilter);
        itr.addActionFilters(actionFilters);
        return itr.iterator();
    }

    public boolean contains(UpdateManifestEntry entry) {
        return this.entries.contains(entry);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UpdateManifest:\n");
        if (this.entries == null) {
            sb.append("Empty.");
        } else {
            try {
                for (UpdateManifestEntry entry : this.entries) {
                    sb.append("\t" + entry.toString() + "\n");
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return sb.toString();
    }

    public LinkedList<UpdateManifestEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(LinkedList<UpdateManifestEntry> entries) {
        this.entries = entries;
    }

    public Object clone() {
        UpdateManifest clone = new UpdateManifest();
        clone.entries = new LinkedList();
        clone.entries.addAll(this.entries);
        return clone;
    }

    private class UpdateManifestIterator
    implements Iterable<UpdateManifestEntry> {
        private LinkedList<UpdateManifestEntry> filteredEntries = null;
        private String osFilter = null;
        private ArrayList<String> actionFilters = null;

        private UpdateManifestIterator() {
        }

        public void setOSFilter(String osFilter) {
            this.osFilter = osFilter;
        }

        public void addActionFilter(String actionFilter) {
            if (actionFilter != null) {
                if (this.actionFilters == null) {
                    this.actionFilters = new ArrayList();
                }
                this.actionFilters.add(actionFilter);
            }
        }

        public void addActionFilters(List<String> actionFilters) {
            if (actionFilters != null && actionFilters.size() > 0) {
                if (this.actionFilters == null) {
                    this.actionFilters = new ArrayList();
                }
                this.actionFilters.addAll(actionFilters);
            }
        }

        @Override
        public Iterator<UpdateManifestEntry> iterator() {
            this.filteredEntries = new LinkedList();
            for (UpdateManifestEntry entry : UpdateManifest.this.entries) {
                List<String> osDeps;
                boolean add = true;
                if (this.actionFilters != null && !this.actionFilters.contains(entry.getAction())) {
                    add = false;
                }
                if (this.osFilter != null && (osDeps = entry.getOsDepenencys()) != null && osDeps.size() > 0 && !osDeps.contains(this.osFilter)) {
                    add = false;
                }
                if (!add) continue;
                this.filteredEntries.add(entry);
            }
            return this.filteredEntries.iterator();
        }
    }
}

