/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.updatetool.manifest.builder;

import com.wowza.updatetool.VersionCheck;
import com.wowza.updatetool.manifest.UpdateManifest;
import com.wowza.updatetool.manifest.UpdateManifestEntry;
import com.wowza.updatetool.manifest.builder.ManifestBuilderConfig;
import java.io.File;
import java.io.IOException;

public class ManifestBuilder {
    public static UpdateManifest buildManifest(File srcDir, ManifestBuilderConfig config) throws IOException {
        UpdateManifest umf = new UpdateManifest();
        ManifestBuilder.getManifestEntries(umf, srcDir, null, config);
        return umf;
    }

    private static void getManifestEntries(UpdateManifest umf, File srcDir, String relativeRoot, ManifestBuilderConfig config) throws IOException {
        String dirName = srcDir.getCanonicalPath().replaceAll("\\\\", "/").toLowerCase();
        System.out.println("Checking: " + dirName);
        for (String skipDirName : config.getIgnoreDirectories()) {
            if (!dirName.toLowerCase().endsWith(skipDirName)) continue;
            return;
        }
        String[] files = srcDir.list();
        if (files != null) {
            block1: for (String file : files) {
                File temp = new File(srcDir.getAbsoluteFile() + "/" + file);
                if (temp.isFile()) {
                    String fileName = temp.getCanonicalPath().toLowerCase().replaceAll("\\\\", "/");
                    if (config.isIgnoreFile(fileName)) continue;
                    for (String ext : config.getExtensions()) {
                        if (!fileName.endsWith(ext)) continue;
                        String name = (relativeRoot == null ? "" : relativeRoot + "/") + temp.getName();
                        UpdateManifestEntry entry = new UpdateManifestEntry();
                        entry.setDestination(name);
                        entry.setSourceFile(name);
                        entry.setMinimumVersion(VersionCheck.getJarOrWarFileVersion(new File(srcDir.getCanonicalPath() + "/" + temp.getName())));
                        entry.setAction("update");
                        if (relativeRoot != null) {
                            entry.setOsDepenency(config.getDirOsDependency(relativeRoot));
                        }
                        umf.addManifestEntry(entry);
                        System.out.println("Added: " + entry);
                        continue block1;
                    }
                    continue;
                }
                int lastSlash = temp.getCanonicalPath().replaceAll("\\\\", "/").lastIndexOf("/");
                String subDirName = temp.getCanonicalPath().substring(lastSlash + 1, temp.getCanonicalPath().length());
                ManifestBuilder.getManifestEntries(umf, temp, relativeRoot == null ? subDirName : relativeRoot + "/" + subDirName, config);
            }
        }
    }
}

