/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.updatetool.manifest.builder;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ManifestBuilderConfig {
    private ArrayList<String> extensions = null;
    private ArrayList<String> ignoreDirectories = null;
    private ArrayList<String> ignoreFiles = null;
    private HashMap<String, String> osDependentDirs = null;

    public ArrayList<String> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(ArrayList<String> extensions) {
        this.extensions = extensions;
    }

    public ArrayList<String> getIgnoreDirectories() {
        return this.ignoreDirectories;
    }

    public void setIgnoreDirectories(ArrayList<String> ignoreDirectories) {
        this.ignoreDirectories = ignoreDirectories;
    }

    public ArrayList<String> getIgnoreFiles() {
        return this.ignoreFiles;
    }

    public void setIgnoreFiles(ArrayList<String> ignoreFiles) {
        this.ignoreFiles = ignoreFiles;
    }

    public HashMap<String, String> getOsDependentDirs() {
        return this.osDependentDirs;
    }

    public void setOsDependentDir(HashMap<String, String> osDependentDirs) {
        this.osDependentDirs = osDependentDirs;
    }

    public void addExtension(String ext) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        this.extensions.add(ext);
    }

    public void addIgnoreDirectory(String dir) {
        if (this.ignoreDirectories == null) {
            this.ignoreDirectories = new ArrayList();
        }
        this.ignoreDirectories.add(dir);
    }

    public void addIgnoreFile(String file) {
        if (this.ignoreFiles == null) {
            this.ignoreFiles = new ArrayList();
        }
        this.ignoreFiles.add(file);
    }

    public boolean isIgnoreFile(String fileName) {
        boolean retVal = false;
        for (String file : this.ignoreFiles) {
            if (!fileName.toLowerCase().endsWith(file)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public void addOsDependentDir(String os, String dir) {
        if (this.osDependentDirs == null) {
            this.osDependentDirs = new HashMap();
        }
        this.osDependentDirs.put(dir, os);
    }

    public String getDirOsDependency(String dir) {
        String retVal = null;
        if (this.osDependentDirs != null) {
            retVal = this.osDependentDirs.get(dir);
        }
        return retVal;
    }

    public static ManifestBuilderConfig loadConfig(File file) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readValue(file, ManifestBuilderConfig.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean saveConfig(File file) {
        boolean retVal = false;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        try {
            mapper.writeValue(file, (Object)this);
            retVal = true;
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static void saveDefaultConfig(File file) {
        new ManifestBuilderConfig(){
            {
                this.addExtension(".jar");
                this.addExtension(".war");
                this.addExtension(".so");
                this.addExtension(".list");
                this.addExtension(".0");
                this.addExtension(".1");
                this.addExtension(".6");
                this.addExtension(".dll");
                this.addOsDependentDir("windows", "lib-native/win64");
                this.addOsDependentDir("linux", "lib-native/linux64");
                this.addIgnoreDirectory("applications");
                this.addIgnoreDirectory("bin");
                this.addIgnoreDirectory("conf");
                this.addIgnoreDirectory("content");
                this.addIgnoreDirectory("documentation");
                this.addIgnoreDirectory("examples");
                this.addIgnoreDirectory("keys");
                this.addIgnoreDirectory("legal");
                this.addIgnoreDirectory("logs");
                this.addIgnoreDirectory("mediacache");
                this.addIgnoreDirectory("stats");
                this.addIgnoreDirectory("transcoder");
                this.addIgnoreDirectory("updates");
                this.addIgnoreDirectory("manager/bin");
                this.addIgnoreDirectory("manager/conf");
                this.addIgnoreDirectory("manager/logs");
                this.addIgnoreDirectory("manager/temp");
                this.addIgnoreFile("lib/wms-ant.jar");
                this.addIgnoreFile("lib/wms-debugger.jar");
                this.addIgnoreFile("lib/wms-httpstreamer-webmstreaming.jar");
                this.addIgnoreFile("lib/wms-mediareader-webm.jar");
                this.addIgnoreFile("lib/wms-performance.jar");
                this.addIgnoreFile("lib/wms-plugin-allowextension.jar");
                this.addIgnoreFile("lib/wms-plugin-amazonutils.jar");
                this.addIgnoreFile("lib/wms-plugin-blogcheese.jar");
                this.addIgnoreFile("lib/wms-plugin-bwcheck.jar");
                this.addIgnoreFile("lib/wms-plugin-collection.jar");
                this.addIgnoreFile("lib/wms-plugin-crossdomain.jar");
                this.addIgnoreFile("lib/wms-plugin-devchat.jar");
                this.addIgnoreFile("lib/wms-plugin-dvrreporter.jar");
                this.addIgnoreFile("lib/wms-plugin-example.jar");
                this.addIgnoreFile("lib/wms-plugin-fastsharedobject.jar");
                this.addIgnoreFile("lib/wms-plugin-httpdemopublisher.jar");
                this.addIgnoreFile("lib/wms-plugin-idledisconnect.jar");
                this.addIgnoreFile("lib/wms-plugin-jsonutils.jar");
                this.addIgnoreFile("lib/wms-plugin-junit-runner.jar");
                this.addIgnoreFile("lib/wms-plugin-kaneva.jar");
                this.addIgnoreFile("lib/wms-plugin-limitrecordstream.jar");
                this.addIgnoreFile("lib/wms-plugin-liveforceappend.jar");
                this.addIgnoreFile("lib/wms-plugin-liverepeaterlogging.jar");
                this.addIgnoreFile("lib/wms-plugin-liveseek.jar");
                this.addIgnoreFile("lib/wms-plugin-mediacasterstreammanager.jar");
                this.addIgnoreFile("lib/wms-plugin-memorycleanup.jar");
                this.addIgnoreFile("lib/wms-plugin-mpeg2.jar");
                this.addIgnoreFile("lib/wms-plugin-repeaterstats.jar");
                this.addIgnoreFile("lib/wms-plugin-rtpcaster.jar");
                this.addIgnoreFile("lib/wms-plugin-rtpfakertcprr.jar");
                this.addIgnoreFile("lib/wms-plugin-rtpprovideroverride.jar");
                this.addIgnoreFile("lib/wms-plugin-samplessl.jar");
                this.addIgnoreFile("lib/wms-plugin-serversideexamples.jar");
                this.addIgnoreFile("lib/wms-plugin-sharedobjautopurge.jar");
                this.addIgnoreFile("lib/wms-plugin-streamtest.jar");
                this.addIgnoreFile("lib/wms-plugin-test2.jar");
                this.addIgnoreFile("lib/wms-plugin-textchat.jar");
                this.addIgnoreFile("lib/wms-plugin-transcoderoverlaydemo.jar");
                this.addIgnoreFile("lib/wms-plugin-wchat.jar");
                this.addIgnoreFile("lib/wms-plugin-winmedia.jar");
                this.addIgnoreFile("manager/lib/wms-winstone-1.0.5-boot.jar");
                this.addIgnoreFile("manager/lib/lib/activation-1.1.jar");
                this.addIgnoreFile("manager/lib/lib/jndi-1.0.5.jar");
                this.addIgnoreFile("manager/lib/lib/log4j-1.2.16.jar");
                this.addIgnoreFile("manager/lib/lib/mail-1.4.1.jar");
                this.addIgnoreFile("manager/lib/lib/slf4j-api-1.6.4.jar");
                this.addIgnoreFile("manager/lib/lib/slf4j-log4j12-1.6.4.jar");
                this.addIgnoreFile("manager/lib/lib/wms-winstone-1.0.5.jar");
            }
        }.saveConfig(file);
    }
}

