/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.rtp;

import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.util.JSON;
import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import com.wowza.wms.stream.live.LivePlayer;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RTPPlayer
extends LivePlayer {
    private long a = -1L;
    private long b = -1L;
    private long c = -1L;
    private long d = -1L;
    private long e = -1L;
    private PlaylistCursor f = null;
    private long[] g = null;
    private PlaylistWriteControl h = null;
    private PlaylistReaderWriteResults i = null;
    private long j = 0L;
    private PacketTimecodeDebug k = null;

    /*
     * Enabled aggressive block sorting
     */
    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        super.init(iMediaStream, mediaStreamMap);
        this.waitForKeyFrame = false;
        this.isEnhancedSeekCapable = false;
        this.isDebugLog = WMSLoggerFactory.getLogger(LivePlayer.class).isDebugEnabled();
        if (iMediaStream == null) return;
        WMSProperties wMSProperties = iMediaStream.getProperties();
        if (wMSProperties == null) return;
        boolean bl = false;
        bl = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"uwqarYbl~urrzLK\u0010\u0011# / 2\u0013!$/8", (int)(82 + 95)), bl);
        if (!bl) {
            if (!this.isDebugLog) return;
        }
        this.k = new PacketTimecodeDebug();
    }

    public RTPPlayer(IMediaStreamPlay iMediaStreamPlay) {
        super(iMediaStreamPlay);
    }

    public boolean play(IMediaStream iMediaStream) {
        return true;
    }

    public boolean play() {
        return true;
    }

    public void setRTPTargetAudioPacketSeq(long l) {
        this.a = l;
    }

    public void setRTPTargetVideoPacketSeq(long l) {
        this.b = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getNextVideoSequence() {
        IMediaStream iMediaStream = this.stream.getParent();
        RTPStream rTPStream = iMediaStream.getRTPStream();
        RTPTrack rTPTrack = null;
        RTPTrack rTPTrack2 = null;
        RTPTrack rTPTrack3 = null;
        IRTPPacketizer iRTPPacketizer = null;
        IRTPPacketizer iRTPPacketizer2 = null;
        rTPTrack3 = rTPStream.getStreamTrack();
        if (rTPTrack3 != null) {
            rTPTrack = rTPTrack3;
            rTPTrack2 = rTPTrack3;
        } else {
            rTPTrack = rTPStream.getVideoTrack();
            rTPTrack2 = rTPStream.getAudioTrack();
        }
        if (rTPTrack != null) {
            iRTPPacketizer = rTPTrack.getRTPPacketizer();
        }
        if (rTPTrack2 != null) {
            iRTPPacketizer2 = rTPTrack2.getRTPPacketizer();
        }
        if (iRTPPacketizer == null) {
            return 1;
        }
        int n = iRTPPacketizer.getNextSequence();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getNextAudioSequence() {
        IMediaStream iMediaStream = this.stream.getParent();
        RTPStream rTPStream = iMediaStream.getRTPStream();
        RTPTrack rTPTrack = null;
        RTPTrack rTPTrack2 = null;
        RTPTrack rTPTrack3 = null;
        IRTPPacketizer iRTPPacketizer = null;
        IRTPPacketizer iRTPPacketizer2 = null;
        rTPTrack3 = rTPStream.getStreamTrack();
        if (rTPTrack3 != null) {
            rTPTrack = rTPTrack3;
            rTPTrack2 = rTPTrack3;
        } else {
            rTPTrack = rTPStream.getVideoTrack();
            rTPTrack2 = rTPStream.getAudioTrack();
        }
        if (rTPTrack != null) {
            iRTPPacketizer = rTPTrack.getRTPPacketizer();
        }
        if (rTPTrack2 != null) {
            iRTPPacketizer2 = rTPTrack2.getRTPPacketizer();
        }
        if (iRTPPacketizer2 == null) {
            return 1;
        }
        int n = iRTPPacketizer2.getNextSequence();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resetInternal(boolean bl, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            this.a = -1L;
            this.b = -1L;
            this.c = -1L;
            this.d = -1L;
            this.e = -1L;
            this.f = null;
            this.g = null;
            this.h = null;
            this.i = null;
            super.resetInternal(bl, bl2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startVODStreaming(RTPStream rTPStream) {
        Object object = this.lock;
        synchronized (object) {
            if (this.f != null) return;
            this.d = rTPStream.getVODStartTimeTC();
            this.e = -1L;
            this.playLen = rTPStream.getVODPlayLen();
            this.f = new PlaylistCursor();
            this.g = new long[8];
            this.h = this.f.getWriteControl();
            this.i = this.f.getWriteResults();
            this.waitForBufferFill = false;
            this.instantOn = false;
            this.waitForKeyFrame = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AMFPacket> peekVODPackets(RTPStream rTPStream, long l) {
        ArrayList<AMFPacket> arrayList = new ArrayList<AMFPacket>();
        Object object = this.lock;
        synchronized (object) {
            this.startVODStreaming(rTPStream);
            long l2 = this.e >= 0L ? this.e : this.d;
            long l3 = l2 + l;
            this.h.setMaxTC(l3);
            IMediaReader iMediaReader = rTPStream.getMediaReader();
            IMediaReaderStreamPosition iMediaReaderStreamPosition = iMediaReader.getStreamPosition();
            iMediaReader.writePackets(arrayList, this.f, this.h, this.i, this.g, null);
            iMediaReader.setStreamPosition(iMediaReaderStreamPosition);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetVODThrottling(long l) {
        Object object = this.lock;
        synchronized (object) {
            long l2 = this.e >= 0L ? this.e : l;
            this.d = l2;
            this.c = System.currentTimeMillis() - 500L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playAll(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, long[] var6_6) {
        block109: {
            var7_7 = 0;
            if (!this.stream.getParent().isOpen()) {
                return 0;
            }
            if (this.playlistEnd) {
                return 0;
            }
            var8_8 = this.stream.getParent();
            var9_9 = var8_8.getRTPStream();
            var10_10 = var9_9.getSession();
            var11_11 = null;
            var12_12 = null;
            var13_13 = false;
            var14_14 = System.currentTimeMillis();
            var16_15 = false;
            var17_16 = 0;
            var18_17 = 0;
            var19_18 = null;
            var20_19 = null;
            var21_20 = null;
            var22_21 = null;
            var23_22 = null;
            var21_20 = var9_9.getStreamTrack();
            if (var21_20 != null) {
                var19_18 = var21_20;
                var20_19 = var21_20;
            } else {
                var19_18 = var9_9.getVideoTrack();
                var20_19 = var9_9.getAudioTrack();
            }
            if (var19_18 != null) {
                var22_21 = var19_18.getRTPPacketizer();
                if (var19_18.isInterleaved()) {
                    var16_15 = true;
                }
            }
            if (var20_19 != null) {
                var23_22 = var20_19.getRTPPacketizer();
                if (var20_19.isInterleaved()) {
                    var16_15 = true;
                }
            }
            var24_23 = -1L;
            var26_24 = 7;
            var27_25 = false;
            var28_26 = 0L;
            var30_27 = null;
            var31_28 = null;
            var32_29 = null;
            var33_30 = Base64.lastIndexOf((int)(49 * 3), (String)"``gsvu") + this.stream.getParent().getSrc();
            var34_31 = null;
            var35_32 = 0L;
            var37_33 = 0;
            var38_34 = 0;
            var39_35 = true;
            var40_37 = this.lock;
            synchronized (var40_37) {
                block111: {
                    ** try [egrp 2[TRYBLOCK] [2 : 173->1984)] { 
lbl53:
                    // 1 sources

                    {
                        var41_38 = var9_9.isResetPlayStream();
                        if (var41_38) {
                            this.resetInternal(true, false);
                            var9_9.setResetPlayStream(false);
                        }
                        var13_13 = var9_9.isLive();
                        var42_41 = var9_9.isPaused();
                        var43_43 = var9_9.isStreamStarted();
                        if (var42_41 || !var43_43 || var13_13 && var1_1 == null) break block109;
                        if (this.c < 0L) {
                            this.c = var14_14;
                        }
                        if (var13_13) {
                            var11_11 = this.getPlayPackets(var1_1);
                            var12_12 = var1_1.getLastKeyFrame();
                        } else {
                            this.startVODStreaming(var9_9);
                            var44_49 = this.d + (var14_14 - this.c);
                            this.h.setMaxTC(var44_49);
                            this.e = var44_49;
                            var11_11 = new ArrayList<E>();
                            var9_9.getMediaReader().writePackets(var11_11, this.f, this.h, this.i, this.g, null);
                        }
                        if (this.k != null) {
                            var44_49 = 0L;
                            if (this.k.i >= 0L) {
                                var44_49 = var14_14 - this.k.i;
                            }
                            this.k.i = var14_14;
                            var46_58 = 0L;
                            if (var13_13 && var11_11 != null && (var48_69 = var11_11.size()) > 0) {
                                var46_58 = ((AMFPacket)var11_11.get(var48_69 - 1)).getSeq();
                            }
                            var48_66 = Base64.lastIndexOf((int)(-50 - -59), (String)"[^[\\aovuc<agpxsC") + (var1_1 == null ? Base64.lastIndexOf((int)(10 - -11), (String)"`x|vvmu") : var1_1.getContextStr()) + Base64.lastIndexOf((int)(88 + -87), (String)"\\8#vq<") + var44_49 + Base64.lastIndexOf((int)(1093 / 222), (String)"$vcv2") + var46_58;
                            if (this.isDebugLog) {
                                WMSLoggerFactory.getLogger(null).debug(var48_66);
                            } else {
                                WMSLoggerFactory.getLogger(null).info(var48_66);
                            }
                        }
                        if (var11_11 == null) break block109;
                        var38_34 = var11_11.size();
                        if (var38_34 <= 0) {
                            this.bufferEmptyOnce = true;
                            break block109;
                        }
                        if (this.sendFirstKeyFrame) {
                            this.lastReceiveAudio = this.stream.getParent().isReceiveAudio();
                            this.lastReceiveVideo = this.stream.getParent().isReceiveVideo();
                        }
                        if (var16_15) {
                            var32_29 = var10_10.getRTPWriteListener();
                        }
                        var34_31 = (AMFPacket)var11_11.get(0);
                        if (!this.waitForBufferFill || !this.sendFirstKeyFrame) ** GOTO lbl460
                        var44_48 = true;
                        var45_54 = Math.min((long)this.stream.getParent().getBufferTime(), (long)this.maximumLiveLatency);
                        if (this.waitForBufferFillStarTime == -1L) {
                            this.waitForBufferFillStarTime = var14_14;
                        } else if (var14_14 - this.waitForBufferFillStarTime > var45_54 && !this.waitForBufferKeyFrame) {
                            var44_48 = false;
                        }
                        if (var44_48 && var45_54 > 0L) {
                            var47_63 = (AMFPacket)var11_11.get(var38_34 - 1);
                            if (var47_63.getAbsTimecode() - var34_31.getAbsTimecode() < var45_54) break block109;
                            if (this.waitForBufferKeyFrame && var12_12 == null) {
                                var48_67 = 0;
                                var49_72 = 0;
                                break block110;
                            }
                        }
                        ** GOTO lbl460
                    }
lbl118:
                    // 1 sources

                    catch (Exception var41_39) {
                        var42_42 = JSON.regionMatches((String)"|d`bbya", (int)(11 * 27));
                        var43_44 = var41_39;
                        if (var43_44 == null) break block111;
                    }
                    var44_52 = var43_44.getStackTrace();
                    if (var44_52 != null && var44_52.length > 0) {
                        var42_42 = var44_52[0].getClassName() + "." + var44_52[0].getMethodName() + "(" + var44_52[0].getFileName() + ":" + var44_52[0].getLineNumber() + ")";
                    }
                    var42_42 = var43_44.toString() + Base64.lastIndexOf((int)(73 + 111), (String)"81") + var42_42 + ")";
                }
                WMSLoggerFactory.getLogger(RTPPlayer.class).error(Base64.lastIndexOf((int)(57 * 57), (String)"CFCDywn}k4kp|g^,-xc") + var42_42, (Throwable)var41_39);
                break block109;
            }
            {
                while (true) {
                    // ** MonitorExit[var44_45] (shouldn't be in output)
                    if (!var43_43) ** GOTO lbl-1000
                    return var7_7;
                    break;
                }
            }
lbl134:
            // 1 sources

            while (true) {
                var40_36 = -1L;
                var42_40 = var37_33;
lbl-1000:
                // 2 sources

                {
                    var43_43 = true;
                }
                synchronized (this.lock) {
                    block139: {
                        block138: {
                            block124: {
                                block134: {
                                    block135: {
                                        block137: {
                                            block133: {
                                                block136: {
                                                    block130: {
                                                        block132: {
                                                            block131: {
                                                                block129: {
                                                                    block127: {
                                                                        block128: {
                                                                            block126: {
                                                                                block116: {
                                                                                    block125: {
                                                                                        block121: {
                                                                                            block122: {
                                                                                                block123: {
                                                                                                    block114: {
                                                                                                        block115: {
                                                                                                            block113: {
                                                                                                                block112: {
                                                                                                                    var45_53 = var9_9.isResetPlayStream();
                                                                                                                    if (var45_53) break block112;
                                                                                                                    break block113;
                                                                                                                }
lbl147:
                                                                                                                // 4 sources

                                                                                                                while (true) {
                                                                                                                    if (!var43_43) ** continue;
                                                                                                                    if (var26_24 == 0) break block114;
                                                                                                                    break block115;
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            if (var42_40 >= var38_34) ** GOTO lbl147
                                                                                                            var34_31 = (AMFPacket)var11_11.get(var42_40);
                                                                                                            if (this.lastReceiveVideo == this.stream.getParent().isReceiveVideo() || !this.stream.getParent().isReceiveVideo()) break block121;
                                                                                                            break block122;
                                                                                                        }
                                                                                                        if (var26_24 != 1) break block123;
                                                                                                    }
                                                                                                    this.waitForKeyFrame = true;
                                                                                                }
                                                                                                if (var40_36 != -1L) {
                                                                                                    this.lastSeq = var40_36;
                                                                                                }
                                                                                                if (var21_20 != null) {
                                                                                                    var7_7 += var22_21.flushPackets(var2_2, var1_1, var21_20);
                                                                                                } else {
                                                                                                    if (var22_21 != null) {
                                                                                                        var7_7 += var22_21.flushPackets(var2_2, var1_1, var19_18);
                                                                                                    }
                                                                                                    if (var23_22 != null) {
                                                                                                        var7_7 += var23_22.flushPackets(var2_2, var1_1, var20_19);
                                                                                                    }
                                                                                                }
                                                                                                if (!var13_13 && var24_23 >= 0L) {
                                                                                                    var9_9.setVODLastTimeTC(var24_23);
                                                                                                }
                                                                                                if (this.isDebugLog) {
                                                                                                    var45_56 = System.currentTimeMillis();
                                                                                                    var47_65 = this.lastSendTime != -1L ? var45_56 - this.lastSendTime : 0L;
                                                                                                    this.lastSendTime = var45_56;
                                                                                                    WMSLoggerFactory.getLogger(LivePlayer.class).debug(Base64.lastIndexOf((int)(33 - -30), (String)"l%/&\u0018") + this.stream.getParent().getClientId() + Base64.lastIndexOf((int)(36 - -30), (String)"\u001fyd6/=-s") + var7_7 + JSON.regionMatches((String)"*meazjb+", (int)(44 - 2)) + var26_24 + JSON.regionMatches((String)"/dx\u007fv.", (int)(-48 + 95)) + var47_65 + Base64.lastIndexOf((int)(861 / 143), (String)"&sGolxiy4") + var28_26);
                                                                                                }
                                                                                                if (var16_15 == false) return var7_7;
                                                                                                if (var31_28 == null) return var7_7;
                                                                                                var31_28.totalLen = var7_7;
                                                                                                this.lastSentLiveTracker = var31_28;
                                                                                                var32_29.getPendingTracker().putInfo(var33_30, var31_28);
                                                                                                // ** MonitorExit[var44_45] (shouldn't be in output)
                                                                                                return var7_7;
                                                                                            }
                                                                                            this.waitForKeyFrame = true;
                                                                                        }
                                                                                        var46_61 = var34_31.getAbsTimecode();
                                                                                        var48_71 = 0L;
                                                                                        var50_76 = var34_31.getType();
                                                                                        var51_78 = false;
                                                                                        var52_79 = true;
                                                                                        switch (var50_76) {
                                                                                            default: {
                                                                                                WMSLoggerFactory.getLogger(MediaStreamLivePlay.class).info(Base64.lastIndexOf((int)(13 * 25), (String)"\f(!'sj\u001c\u0001\u001e\u001c*#!\u0001'&07:+cz4)).*4\u0012+-#)#}h<$ \"\"9!p!30?0\"w, *>f}") + var34_31.getType());
                                                                                                break;
                                                                                            }
                                                                                            case 8: {
                                                                                                if (!this.stream.getParent().isReceiveAudio() || var27_25) break;
                                                                                                this.lastTC = var48_71 = var46_61;
                                                                                                this.lastAudioTC = var48_71;
                                                                                                var6_6[0] = var6_6[0] + (long)var34_31.getSize();
                                                                                                var6_6[1] = var6_6[1] + 1L;
                                                                                                var51_78 = true;
                                                                                                break;
                                                                                            }
                                                                                            case 15: 
                                                                                            case 18: {
                                                                                                this.lastTC = var48_71 = var46_61;
                                                                                                this.lastDataTC = var48_71;
                                                                                                var6_6[4] = var6_6[4] + (long)var34_31.getSize();
                                                                                                var6_6[5] = var6_6[5] + 1L;
                                                                                                var51_78 = true;
                                                                                                break;
                                                                                            }
                                                                                            case 9: {
                                                                                                if (!this.stream.getParent().isReceiveVideo()) break;
                                                                                                var53_82 = var34_31.getFirstByte();
                                                                                                var52_79 = var26_24 == 7;
                                                                                                if (!var52_79) {
                                                                                                    var52_79 = this.testVideoFrame(var26_24, var53_82);
                                                                                                }
                                                                                                if (!var52_79) ** GOTO lbl222
                                                                                                if (!this.waitForKeyFrame) ** GOTO lbl227
                                                                                                if (!FLVUtils.isVideoKeyFrame((AMFPacket)var34_31)) break;
                                                                                                ** GOTO lbl225
lbl222:
                                                                                                // 1 sources

                                                                                                var6_6[6] = var6_6[6] + (long)var34_31.getSize();
                                                                                                var6_6[7] = var6_6[7] + 1L;
                                                                                                break;
lbl225:
                                                                                                // 1 sources

                                                                                                WMSLoggerFactory.getLogger(LivePlayer.class).debug(Base64.lastIndexOf((int)(14 + 105), (String)" 90.\u001d3/\u0015:yGpbi`<'nf\u007feh"));
                                                                                                this.waitForKeyFrame = false;
lbl227:
                                                                                                // 2 sources

                                                                                                this.lastTC = var48_71 = var46_61;
                                                                                                this.lastVideoTC = var48_71;
                                                                                                var6_6[2] = var6_6[2] + (long)var34_31.getSize();
                                                                                                var6_6[3] = var6_6[3] + 1L;
                                                                                                var51_78 = true;
                                                                                            }
                                                                                        }
                                                                                        if (!var51_78) break block124;
                                                                                        if (!this.sentPlayStart) break block125;
lbl234:
                                                                                        // 2 sources

                                                                                        while (var16_15) {
                                                                                            if (var31_28 == null) {
                                                                                                var31_28 = new LivePlayer.LiveTracker((LivePlayer)this);
                                                                                                var31_28.firstTC = var46_61;
                                                                                            }
                                                                                            var31_28.lastTC = var46_61;
                                                                                            break block116;
                                                                                        }
                                                                                        break block116;
                                                                                    }
                                                                                    if (this.sendPlayStop) {
                                                                                        this.sendPlayStop = false;
                                                                                    }
                                                                                    this.sentPlayStart = true;
                                                                                    this.sendPlayStop = true;
                                                                                    ** GOTO lbl234
                                                                                }
                                                                                if (!this.sendFirstKeyFrame) break block126;
                                                                                if (!var13_13 || var30_27 != null) break block127;
                                                                                break block128;
                                                                            }
                                                                            if (this.lastReceiveAudio != this.stream.getParent().isReceiveAudio() && (var53_87 = new AMFPacket(8, var13_13 != false ? var1_1.getSrc() : 0, 0)) != null) {
                                                                                var6_6[0] = var6_6[0] + 0L;
                                                                                var6_6[1] = var6_6[1] + 1L;
                                                                            }
                                                                            break block129;
                                                                        }
                                                                        var30_27 = this.getLastKeyFrame(var1_1);
                                                                    }
                                                                    if (!this.stream.getParent().isReceiveVideo()) {
                                                                        var30_27 = null;
                                                                    }
                                                                    if (var30_27 != null) {
                                                                        if (this.sendFirstVideoFrame) {
                                                                            if (var13_13 && (var53_81 = var1_1.getVideoCodecConfigPacket(var30_27.getAbsTimecode())) != null && var22_21 != null) {
                                                                                var7_7 += var22_21.handleAMFPacket(var2_2, var1_1, var19_18, var53_81, var48_71);
                                                                            }
                                                                            this.sendFirstVideoFrame = false;
                                                                        }
                                                                        var6_6[2] = var6_6[2] + (long)var30_27.getSize();
                                                                        var6_6[3] = var6_6[3] + 1L;
                                                                    }
                                                                    if (var16_15) {
                                                                        this.trackerStartSeq = var31_28.trackerSeq;
                                                                    }
                                                                    this.sendFirstKeyFrame = false;
                                                                }
                                                                if (!this.sendFirstAudioFrame && !this.sendFirstVideoFrame) break block130;
                                                                if (var50_76 != 8 || !this.sendFirstAudioFrame) break block131;
                                                                break block132;
                                                            }
                                                            if (var50_76 == 9 && this.sendFirstVideoFrame) {
                                                                if (var13_13 && (var53_85 = var1_1.getVideoCodecConfigPacket(var34_31.getAbsTimecode())) != null && var22_21 != null) {
                                                                    var7_7 += var22_21.handleAMFPacket(var2_2, var1_1, var19_18, var53_85, var48_71);
                                                                }
                                                                this.sendFirstVideoFrame = false;
                                                            }
                                                            break block130;
                                                        }
                                                        var53_86 = new AMFPacket(8, !var13_13 ? 0 : var1_1.getSrc(), 0);
                                                        if (var53_86 != null) {
                                                            var6_6[0] = var6_6[0] + 0L;
                                                            var6_6[1] = var6_6[1] + 1L;
                                                        }
                                                        if (var13_13 && (var54_88 = var1_1.getAudioCodecConfigPacket(var34_31.getAbsTimecode())) != null && var23_22 != null) {
                                                            var7_7 += var23_22.handleAMFPacket(var2_2, var1_1, var20_19, var54_88, var48_71);
                                                        }
                                                        this.sendFirstAudioFrame = false;
                                                    }
                                                    if (var50_76 == 9) break block133;
                                                    if (var50_76 != 8) break block134;
                                                    if (this.k == null) break block135;
                                                    var53_83 = System.currentTimeMillis();
                                                    if (this.k.h >= 30) break block136;
                                                    this.k.e = var53_83;
                                                    this.k.f = var48_71;
                                                    ++this.k.h;
                                                    this.k.g = var48_71;
                                                    break block135;
                                                }
                                                var55_90 = StringUtils.intToHexStr((int)(var34_31.getFirstByte() & 255), (int)2);
                                                var56_92 = StringUtils.intToStr((int)var34_31.getSize(), (int)5);
                                                var57_94 = this.k.e + (var48_71 - this.k.f) - var53_83;
                                                var59_95 = var57_94 + "";
                                                if (var57_94 <= 0L) break block137;
                                                var59_95 = " " + var57_94;
                                                break block137;
                                            }
                                            if (this.k != null) {
                                                var53_84 = System.currentTimeMillis();
                                                if (this.k.d < 30) {
                                                    this.k.a = var53_84;
                                                    this.k.b = var48_71;
                                                    this.k.c = var48_71;
                                                    ++this.k.d;
                                                } else {
                                                    var55_91 = StringUtils.intToHexStr((int)(var34_31.getFirstByte() & 255), (int)2);
                                                    var56_92 = StringUtils.intToStr((int)var34_31.getSize(), (int)5);
                                                    var57_94 = this.k.a + (var48_71 - this.k.b) - var53_84;
                                                    var59_95 = var57_94 + "";
                                                    if (var57_94 > 0L) {
                                                        var59_95 = " " + var57_94;
                                                    }
                                                    var60_96 = var48_71 - this.k.c;
                                                    var62_97 = Base64.lastIndexOf((int)(64 + 91), (String)"IHMNsaxgq*socmfQ") + (var1_1 == null ? JSON.regionMatches((String)"$<8::!9", (int)(6 + 75)) : var1_1.getContextStr()) + JSON.regionMatches((String)"Y?&ol{0;t", (int)(1049 / 210)) + var55_91 + Base64.lastIndexOf((int)(3 * 3), (String)")yq6") + var56_92 + JSON.regionMatches((String)"%rd", (int)(1352 / 244)) + var48_71 + "/" + var60_96 + ":" + var53_84 + ":" + var59_95;
                                                    if (!this.isDebugLog) {
                                                        WMSLoggerFactory.getLogger(null).info(var62_97);
                                                    } else {
                                                        WMSLoggerFactory.getLogger(null).debug(var62_97);
                                                    }
                                                    this.k.c = var48_71;
                                                }
                                            }
                                            if (var22_21 != null) {
                                                var7_7 += var22_21.handleAMFPacket(var2_2, var1_1, var19_18, var34_31, var48_71);
                                            }
                                            ++var18_17;
                                            var24_23 = var48_71;
                                            break block134;
                                        }
                                        var60_96 = var48_71 - this.k.g;
                                        var62_97 = JSON.regionMatches((String)"TSXYfjuh|!qdvz{N", (int)(650 / 108)) + (var1_1 == null ? JSON.regionMatches((String)".26007/", (int)(51 * 57)) : var1_1.getContextStr()) + Base64.lastIndexOf((int)(21 - -46), (String)"\u001e~e.#:sz3") + var55_90 + Base64.lastIndexOf((int)(104 + -12), (String)"|.$e") + var56_92 + JSON.regionMatches((String)"#pf", (int)(477 / 126)) + var48_71 + "/" + var60_96 + ":" + var53_83 + ":" + var59_95;
                                        if (this.isDebugLog) {
                                            WMSLoggerFactory.getLogger(null).debug(var62_97);
                                        } else {
                                            WMSLoggerFactory.getLogger(null).info(var62_97);
                                        }
                                        this.k.g = var48_71;
                                    }
                                    if (var23_22 != null) {
                                        var7_7 += var23_22.handleAMFPacket(var2_2, var1_1, var20_19, var34_31, var48_71);
                                    }
                                    ++var17_16;
                                    var24_23 = var48_71;
                                }
                                this.lastReceiveAudio = this.stream.getParent().isReceiveAudio();
                                this.lastReceiveVideo = this.stream.getParent().isReceiveVideo();
                            }
                            this.lastReceiveAudio = this.stream.getParent().isReceiveAudio();
                            this.lastReceiveVideo = this.stream.getParent().isReceiveVideo();
                            var40_36 = var34_31.getSeq();
                            if (!(this.playLen > 0.0) || var48_71 < Math.round(this.playLen)) break block138;
                            if (this.stream.getParent().isSendPlayStopLogEvent()) {
                                this.stream.getParent().setSendPlayStopLogEvent(false);
                                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), JSON.regionMatches((String)"vrumhg", (int)(1181 / 230)), "stop", 200, this.stream.getParent().getName());
                                this.stream.getParent().notifyActionStop();
                            }
                            break block139;
                        }
                        ++var42_40;
                        var43_43 = false;
                        ** GOTO lbl147
                    }
                    this.playlistEnd = true;
                    ** continue;
                }
                break;
            }
lbl-1000:
            // 1 sources

            {
                block117: {
                    block119: {
                        block118: {
                            while ((var34_31 = (AMFPacket)var11_11.get(var37_33)).getSeq() != this.lastSeq + 1L) {
                                this.waitForKeyFrame = true;
                                break block117;
                            }
                            break block117;
lbl372:
                            // 1 sources

                            while (var26_24 == 3) {
                                ** GOTO lbl380
                            }
                            break block119;
lbl375:
                            // 2 sources

                            while (true) {
                                this.lastTCFilter = var26_24;
                                if (!this.disableLowBandwidthThrottling) break block118;
                                var26_24 = 7;
                                break block118;
lbl380:
                                // 2 sources

                                while (true) {
                                    var26_24 = 1;
                                    this.waitForKeyFrame = true;
                                    break block119;
                                    break;
                                }
                                break;
                            }
lbl384:
                            // 2 sources

                            while (true) {
                                var37_33 = var47_64 < 0 ? 0 : var47_64;
                                ** GOTO lbl479
                                while (true) {
                                    v0 = (LivePlayer.LiveTracker)var44_50.getInfo(var33_30);
                                    ** GOTO lbl438
                                    break;
                                }
                                break;
                            }
lbl390:
                            // 2 sources

                            while (true) {
                                var37_33 = v1;
                                if (var37_33 < 0) {
                                    var37_33 = 0;
                                }
                                if (var37_33 >= var38_34) {
                                    break block109;
lbl396:
                                    // 5 sources

                                    while (var50_75 == 9 && (var55_89 = FLVUtils.isVideoKeyFrame((AMFPacket)var34_31))) {
                                        var30_27 = var34_31;
                                        break block120;
                                    }
                                    break block120;
                                }
                                ** GOTO lbl465
                                break;
                            }
                        }
lbl402:
                        // 3 sources

                        while (true) {
                            this.lastTCOffset = var28_26;
                            var44_47 = this.stream.getParent().getReceiveVideoFPS();
                            if (var44_47 >= -1) break;
                            if (var44_47 == -2 && var26_24 == 7) {
                                var26_24 = 3;
                                break;
                            }
                            if (var44_47 != -3) break;
                            if (var26_24 == 7) ** continue;
                            ** GOTO lbl372
                            break;
                        }
                    }
                    var39_35 = false;
                    break block109;
lbl415:
                    // 2 sources

                    while (true) {
                        --var46_60;
                        ** GOTO lbl473
                        while (true) {
                            block141: {
                                block140: {
                                    var51_77 = var34_31.getAbsTimecode();
                                    var53_80 = var34_31.getSeq();
                                    if (var44_51 != -1L) break block140;
                                    var44_51 = var51_77;
                                    ** GOTO lbl396
                                }
                                if (var47_64 == -1) {
                                    this.trackerBufferTime = var44_51 - var51_77;
                                }
                                if (var47_64 != -1) ** GOTO lbl396
                                if (this.a < 0L) break block141;
                                if (var53_80 >= this.a) {
                                    var47_64 = var46_60;
                                }
                                ** GOTO lbl396
                            }
                            if (var44_51 - var51_77 <= var48_70) ** GOTO lbl396
                            var47_64 = var46_60;
                            ** GOTO lbl396
                            break;
                        }
                        break;
                    }
lbl436:
                    // 1 sources

                    while (true) {
                        v0 = null;
lbl438:
                        // 2 sources

                        if ((var45_55 = v0) == null || this.lastSentLiveTracker == null || var45_55.trackerSeq < this.trackerStartSeq) ** GOTO lbl402
                        var46_59 = var44_50.getSent();
                        var50_73 = var45_55.firstTC + (var45_55.lastTC - var45_55.firstTC) * var46_59 / (var48_68 = var44_50.getSize());
                        var28_26 = this.lastSentLiveTracker.lastTC - var50_73 - this.trackerBufferTime;
                        if (var28_26 > (long)this.behindDropAudio) {
                            var27_25 = true;
                        }
                        if (var28_26 > (long)this.behindDropKFrames) {
                            var26_24 = 0;
                        } else if (var28_26 > (long)this.behindDropPFrames) {
                            var26_24 = 1;
                        } else if (var28_26 > (long)this.behindDropDFrames) {
                            var26_24 = 3;
                        }
                        if (this.lastTCFilter == var26_24) ** GOTO lbl375
                        WMSLoggerFactory.getLogger(LivePlayer.class).debug(JSON.regionMatches((String)"Aae~n~V", (int)(61 * 51)) + var33_30 + Base64.lastIndexOf((int)(34 + 68), (String)"\u001b}h/#'8(<ux") + this.lastTCFilter + "-" + var26_24 + Base64.lastIndexOf((int)(16 - 58), (String)"\u007fw7?<(9)d") + var28_26 + JSON.regionMatches((String)";oxpkTB8", (int)(46 + -19)) + this.lastSentLiveTracker.lastTC + Base64.lastIndexOf((int)(835 / 174), (String)"$wcdm`|nhYM5") + var45_55.lastTC + JSON.regionMatches((String)"&e}oln~Ygbu+", (int)(987 / 157)) + this.trackerBufferTime + Base64.lastIndexOf((int)(-38 - 6), (String)"t!5m") + this.lastTC);
                        ** continue;
                        break;
                    }
                    while (true) {
                        v1 = (int)(this.lastSeq - var35_32 + 1L);
                        ** GOTO lbl390
                        break;
                    }
lbl458:
                    // 2 sources

                    while (true) {
                        block144: {
                            block143: {
                                block142: {
                                    if (var48_67 > 2) break block109;
lbl460:
                                    // 3 sources

                                    var35_32 = var34_31.getSeq();
                                    var37_33 = 0;
                                    if (!var13_13) break block142;
                                    if (this.lastSeq != -1L) ** continue;
                                    break block143;
                                }
                                if (this.bufferEmptyOnce && !this.waitForBufferFill) break block144;
                                if (!this.instantOn || !this.sendFirstKeyFrame) break block144;
                                var44_51 = -1L;
                                var46_60 = var38_34 - 1;
                                var47_64 = -1;
                                this.trackerBufferTime = 0L;
                                var48_70 = 0L;
lbl473:
                                // 2 sources

                                if (var46_60 < 0) ** GOTO lbl384
                                if ((var50_75 = (var34_31 = (AMFPacket)var11_11.get(var46_60)).getType()) == 9 || var50_75 == 8) ** continue;
                                ** GOTO lbl415
                            }
                            v1 = 0;
                            ** continue;
                        }
                        if (var13_13 && var37_33 == 0 && this.lastSeq != -1L) ** GOTO lbl-1000
                        break;
                    }
                }
                if (var16_15) ** break;
                ** continue;
                if ((var44_50 = var32_29.getLastTracker()) != null) ** continue;
                ** continue;
            }
        }
        ** while (!var39_35)
lbl488:
        // 1 sources

        return 0;
lbl-1000:
        // 1 sources

        {
            block120: {
                block145: {
                    block110: {
                        while (++var48_67 > 2) {
                            ** GOTO lbl458
                        }
                        break block145;
                    }
lbl493:
                    // 2 sources

                    while (true) {
                        if (var49_72 < var38_34) ** break;
                        ** continue;
                        var50_74 = (AMFPacket)var11_11.get(var49_72);
                        if (var50_74.getType() == 9) ** GOTO lbl-1000
                        break;
                    }
                }
                ++var49_72;
                ** continue;
            }
            if (var47_64 != -1) ** break;
            ** continue;
            ** continue;
        }
    }

    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        return this.playAll(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        IMediaStream iMediaStream = this.stream.getParent();
        RTPStream rTPStream = iMediaStream.getRTPStream();
        IMediaStream iMediaStream2 = rTPStream.isLive() ? this.stream.getParent().getStreams().getStream(this.stream.getParent().getName()) : null;
        if (iMediaStream2 == null) {
            if (rTPStream.isLive()) return n;
        }
        return n += this.play(iMediaStream2, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    private class PacketTimecodeDebug {
        long a = -1L;
        long b = -1L;
        long c = -1L;
        int d = 0;
        long e = -1L;
        long f = -1L;
        long g = -1L;
        int h = 0;
        long i = -1L;

        private PacketTimecodeDebug() {
        }
    }
}

