/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.codecconfig;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.JSON;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.mediawriter.h264.codecconfig.QTWriterTrackCodecConfigVideo;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterUtils;
import com.wowza.wms.stream.IMediaStream;
import java.util.Arrays;

public class QTWriterCodecConfigH264
extends QTWriterTrackCodecConfigVideo {
    private static String a = JSON.regionMatches((String)"5#5\u0014", (int)(77 + 39));
    private byte[] b = null;
    private H264CodecConfigInfo c = null;

    private final H264CodecConfigInfo a() {
        return this.c;
    }

    public byte[] getH264CodecConfig() {
        return this.b;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setH264CodecConfig(byte[] byArray) {
        this.b = byArray;
        this.c = byArray != null ? H264Utils.decodeAVCC((byte[])byArray) : null;
        if (this.c == null) return;
        QTWriterCodecConfigH264 qTWriterCodecConfigH264 = this;
        qTWriterCodecConfigH264.setVideoWidth(qTWriterCodecConfigH264.c.width);
        QTWriterCodecConfigH264 qTWriterCodecConfigH2642 = this;
        qTWriterCodecConfigH2642.setVideoHeight(qTWriterCodecConfigH2642.c.height);
        WMSLoggerFactory.getLogger(QTWriterCodecConfigH264.class).debug(JSON.regionMatches((String)"TRPz`~n~E<9$R}wqvUxv\u007fs|2n{kH347GjbbkJeejdi50", (int)(795 / 156)) + this.c.toString());
    }

    public int getH264CodecConfigLength() {
        if (this.b == null) {
            return 0;
        }
        return this.b.length;
    }

    public static void extractH264CodecInfoFromStream(IMediaStream iMediaStream, QTWriterContextTrack qTWriterContextTrack, long l) {
        QTWriterCodecConfigH264.extractH264CodecInfoFromStream(iMediaStream, qTWriterContextTrack, l, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractH264CodecInfoFromStream(IMediaStream iMediaStream, QTWriterContextTrack qTWriterContextTrack, long l, AMFPacket aMFPacket) {
        try {
            int n = 5;
            AMFPacket aMFPacket2 = aMFPacket != null ? aMFPacket : iMediaStream.getVideoCodecConfigPacket(l);
            if (aMFPacket2 == null) {
                return;
            }
            if (aMFPacket2.getSize() < 5) {
                return;
            }
            byte[] byArray = aMFPacket2.getData();
            byte[] byArray2 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            QTWriterCodecConfigH264 qTWriterCodecConfigH264 = new QTWriterCodecConfigH264();
            qTWriterCodecConfigH264.setH264CodecConfig(byArray2);
            qTWriterContextTrack.addCodecConfig(qTWriterCodecConfigH264, true);
            qTWriterContextTrack.setSampleType(0);
            H264CodecConfigInfo h264CodecConfigInfo = qTWriterCodecConfigH264.a();
            if (h264CodecConfigInfo == null) return;
            WMSLoggerFactory.getLogger(QTWriterUtils.class).debug(Base64.lastIndexOf((int)(157 / 50), (String)"RPRtn|lx^xdb|*1Z!\"!,7") + h264CodecConfigInfo.toString());
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error(Base64.lastIndexOf((int)(49 * 21), (String)"TRPz`~n~E<9$R}wqvUxv\u007fs|2xfkr`awL703KfnnoD`i\u007fW`|yFbe}xw@") + qTWriterContextTrack.getContext().getOutPath() + Base64.lastIndexOf((int)(734 / 138), (String)"X&"), (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (!(object instanceof QTWriterCodecConfigH264)) return bl;
        QTWriterCodecConfigH264 qTWriterCodecConfigH264 = (QTWriterCodecConfigH264)object;
        if (Arrays.equals(this.b, qTWriterCodecConfigH264.b)) return super.equals(object);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int parse(byte[] byArray) {
        int n = super.getSize() + 20;
        String string = BufferUtils.byteArrayToString((byte[])byArray, (int)n, (int)4);
        if (!string.equals(Base64.lastIndexOf((int)(31 - 28), (String)"brfE"))) return 0;
        n = super.parse(byArray);
        if (n <= 0) return n;
        int n2 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n);
        byte[] byArray2 = new byte[n2 - 8];
        System.arraycopy(byArray, n += 8, byArray2, 0, n2 - 8);
        this.setH264CodecConfig(byArray2);
        n += n2 - 8;
        return n;
    }
}

