/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.mediacaster;

import com.wowza.util.JSON;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamPlay;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;

public class MediaStreamMediaCasterPlay
extends MediaStreamLivePlay {
    protected String mediaCasterType = JSON.regionMatches((String)" <:##;8)/", (int)(101 + 110));
    protected MediaCasterItem mediaCasterDef = null;
    protected MediaCasterStreamMap mediaCasterStreams = null;

    /*
     * Enabled aggressive block sorting
     */
    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        super.init(iMediaStream, mediaStreamMap);
        WMSProperties wMSProperties = this.getParent().getProperties();
        if (wMSProperties != null) {
            this.mediaCasterType = wMSProperties.getPropertyStr(JSON.regionMatches((String)"(##!(\t*?9+=\u0004(\"6", (int)(17 * 21)), this.mediaCasterType);
        }
        IApplicationInstance iApplicationInstance = mediaStreamMap.getAppInstance();
        this.mediaCasterStreams = iApplicationInstance.getMediaCasterStreams();
        IVHost iVHost = iApplicationInstance.getVHost();
        MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
        this.mediaCasterDef = mediaCasterList.getMediaCasterDef(this.mediaCasterType);
        if (this.mediaCasterDef != null) return;
        WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).error(JSON.regionMatches((String)"\u00130<t u0>6=z\u0016997>C`qwaw&cmoceeyg`~+2", (int)(10 + 102)) + this.mediaCasterType);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startPlay() {
        WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).info(JSON.regionMatches((String)"\u0000++90\u0001'&07:\u0015<>2=\u001e?,tdpShd\u007f=(z~j~y^cqh", (int)(27 * 23)));
        if (((MediaStreamPlay)this).parent.isMediaCasterPlay()) {
            MediaStreamMediaCasterPlay mediaStreamMediaCasterPlay = this;
            this.mediaCasterStreams.registerPlayer((IMediaStreamPlay)mediaStreamMediaCasterPlay, mediaStreamMediaCasterPlay.mediaCasterDef);
        }
        super.startPlay();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void switchPlay() {
        WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).info(JSON.regionMatches((String)"\u0010;;i`Qwv`gjElnbmNo|dt`Cxto-8jmrh~vOl`{", (int)(53 * 41)));
        if (((MediaStreamPlay)this).parent.isMediaCasterPlay()) {
            MediaStreamMediaCasterPlay mediaStreamMediaCasterPlay = this;
            this.mediaCasterStreams.registerPlayer((IMediaStreamPlay)mediaStreamMediaCasterPlay, mediaStreamMediaCasterPlay.mediaCasterDef);
        }
        super.switchPlay();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        WMSLoggerFactory.getLogger(MediaStreamMediaCasterPlay.class).info(JSON.regionMatches((String)"\u00118:6aRvqadkJmmcjOl}{ucB\u007ful,7{uuhy", (int)(20 + 104)));
        super.close();
        if (!((MediaStreamPlay)this).parent.isMediaCasterPlay()) {
            return;
        }
        MediaStreamMediaCasterPlay mediaStreamMediaCasterPlay = this;
        this.mediaCasterStreams.unregisterPlayer((IMediaStreamPlay)mediaStreamMediaCasterPlay, mediaStreamMediaCasterPlay.mediaCasterDef);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        IMediaStream iMediaStream = this.getParent();
        String string = MediaCasterItem.getIdString((String)iMediaStream.getName(), (String)iMediaStream.getLiveStreamPacketizer(), (String)iMediaStream.getLiveStreamRepeater());
        IMediaStream iMediaStream2 = this.getParent().getStreams().getStream(string);
        if (iMediaStream2 == null) {
            return 0;
        }
        int n = super.play(iMediaStream2, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean play() {
        IMediaStream iMediaStream = this.getParent();
        String string = MediaCasterItem.getIdString((String)iMediaStream.getName(), (String)iMediaStream.getLiveStreamPacketizer(), (String)iMediaStream.getLiveStreamRepeater());
        IMediaStream iMediaStream2 = this.getParent().getStreams().getStream(string);
        if (iMediaStream2 == null) {
            return false;
        }
        boolean bl = super.play(iMediaStream2);
        return bl;
    }
}

