/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import edu.emory.mathcs.backport.java.util.WMSArrays;
import edu.emory.mathcs.backport.java.util.concurrent.WMSTimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WMSNanoTimer;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSCondition;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import sun.misc.Perf;

public final class WMSUtils {
    private static final WMSNanoTimer nanoTimer;
    private static final String providerProp = "edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider";

    private WMSUtils() {
    }

    public static long nanoTime() {
        return nanoTimer.nanoTime();
    }

    public static long awaitNanos(WMSCondition wMSCondition, long l) throws InterruptedException {
        if (l <= 0L) {
            return l;
        }
        long l2 = WMSUtils.nanoTime();
        wMSCondition.await(l, WMSTimeUnit.NANOSECONDS);
        return l - (WMSUtils.nanoTime() - l2);
    }

    private static long gcd(long l, long l2) {
        while (l2 > 0L) {
            long l3 = l % l2;
            l = l2;
            l2 = l3;
        }
        return l;
    }

    public static Object[] collectionToArray(Collection collection) {
        int n = collection.size();
        Object[] objectArray = new Object[n];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (true) {
            if (n2 < n && iterator.hasNext()) {
                objectArray[n2++] = iterator.next();
                continue;
            }
            if (!iterator.hasNext()) {
                if (n2 == n) {
                    return objectArray;
                }
                return WMSArrays.copyOf(objectArray, n2, Object[].class);
            }
            int n3 = (objectArray.length / 2 + 1) * 3;
            if (n3 < objectArray.length) {
                if (objectArray.length < Integer.MAX_VALUE) {
                    n3 = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            objectArray = WMSArrays.copyOf(objectArray, n3, Object[].class);
            n = n3;
        }
    }

    public static Object[] collectionToArray(Collection collection, Object[] objectArray) {
        Class<?> clazz = objectArray.getClass();
        int n = collection.size();
        Object[] objectArray2 = objectArray.length >= n ? objectArray : (Object[])Array.newInstance(clazz.getComponentType(), n);
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (true) {
            if (n2 < n && iterator.hasNext()) {
                objectArray2[n2++] = iterator.next();
                continue;
            }
            if (!iterator.hasNext()) {
                if (n2 == n) {
                    return objectArray2;
                }
                if (objectArray2 == objectArray) {
                    objectArray[n2] = null;
                    return objectArray;
                }
                return WMSArrays.copyOf(objectArray2, n2, clazz);
            }
            int n3 = (objectArray2.length / 2 + 1) * 3;
            if (n3 < objectArray2.length) {
                if (objectArray2.length < Integer.MAX_VALUE) {
                    n3 = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            objectArray2 = WMSArrays.copyOf(objectArray2, n3, clazz);
            n = n3;
        }
    }

    static {
        WMSNanoTimer wMSNanoTimer = null;
        try {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(WMSUtils.providerProp);
                }
            });
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                wMSNanoTimer = (WMSNanoTimer)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("WARNING: unable to load the system-property-defined nanotime provider; switching to the default");
            exception.printStackTrace();
        }
        if (wMSNanoTimer == null) {
            try {
                wMSNanoTimer = new SunPerfProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (wMSNanoTimer == null) {
            wMSNanoTimer = new MillisProvider();
        }
        nanoTimer = wMSNanoTimer;
    }

    private static final class MillisProvider
    implements WMSNanoTimer {
        MillisProvider() {
        }

        @Override
        public long nanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private static final class SunPerfProvider
    implements WMSNanoTimer {
        final Perf perf = (Perf)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Perf.getPerf();
            }
        });
        final long multiplier;
        final long divisor;

        SunPerfProvider() {
            long l = 1000000000L;
            long l2 = this.perf.highResFrequency();
            long l3 = WMSUtils.gcd(l, l2);
            this.multiplier = l / l3;
            this.divisor = l2 / l3;
        }

        @Override
        public long nanoTime() {
            long l = this.perf.highResCounter();
            return l / this.divisor * this.multiplier + l % this.divisor * this.multiplier / this.divisor;
        }
    }
}

