/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.textline;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.common.BufferDataException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.util.CharsetUtil;

public class TextLineDecoder
implements ProtocolDecoder {
    private static final String CONTEXT = TextLineDecoder.class.getName() + ".context";
    private final Charset charset;
    private final LineDelimiter delimiter;
    private ByteBuffer delimBuf;
    private int maxLineLength = 1024;

    public TextLineDecoder() {
        this(CharsetUtil.getDefaultCharset(), LineDelimiter.AUTO);
    }

    public TextLineDecoder(Charset charset) {
        this(charset, LineDelimiter.AUTO);
    }

    public TextLineDecoder(Charset charset, LineDelimiter lineDelimiter) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (lineDelimiter == null) {
            throw new NullPointerException("delimiter");
        }
        this.charset = charset;
        this.delimiter = lineDelimiter;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxLineLength: " + n);
        }
        this.maxLineLength = n;
    }

    @Override
    public void decode(IoSession ioSession, ByteBuffer byteBuffer, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
        Context context = this.getContext(ioSession);
        if (LineDelimiter.AUTO.equals(this.delimiter)) {
            context.setMatchCount(this.decodeAuto(byteBuffer, context.getBuffer(), context.getMatchCount(), context.getDecoder(), protocolDecoderOutput));
        } else {
            context.setMatchCount(this.decodeNormal(byteBuffer, context.getBuffer(), context.getMatchCount(), context.getDecoder(), protocolDecoderOutput));
        }
    }

    private Context getContext(IoSession ioSession) {
        Context context = (Context)ioSession.getAttribute(CONTEXT);
        if (context == null) {
            context = new Context();
            ioSession.setAttribute(CONTEXT, context);
        }
        return context;
    }

    @Override
    public void finishDecode(IoSession ioSession, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
    }

    @Override
    public void dispose(IoSession ioSession) throws Exception {
        Context context = (Context)ioSession.getAttribute(CONTEXT);
        if (context != null) {
            context.getBuffer().release();
            ioSession.removeAttribute(CONTEXT);
        }
    }

    private int decodeAuto(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, CharsetDecoder charsetDecoder, ProtocolDecoderOutput protocolDecoderOutput) throws CharacterCodingException {
        int n2 = n;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            boolean bl = false;
            switch (by) {
                case 13: {
                    ++n;
                    break;
                }
                case 10: {
                    ++n;
                    bl = true;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            if (!bl) continue;
            int n5 = byteBuffer.position();
            byteBuffer.limit(n5 - n + n2);
            byteBuffer.position(n3);
            byteBuffer2.put(byteBuffer);
            if (byteBuffer2.position() > this.maxLineLength) {
                throw new BufferDataException("Line is too long: " + byteBuffer2.position());
            }
            byteBuffer2.flip();
            protocolDecoderOutput.write(byteBuffer2.getString(charsetDecoder));
            byteBuffer2.clear();
            byteBuffer.limit(n4);
            byteBuffer.position(n5);
            n3 = n5;
            n = 0;
        }
        byteBuffer.position(n3);
        byteBuffer.limit(byteBuffer.limit() - n + n2);
        byteBuffer2.put(byteBuffer);
        return n;
    }

    private int decodeNormal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, CharsetDecoder charsetDecoder, ProtocolDecoderOutput protocolDecoderOutput) throws CharacterCodingException {
        if (this.delimBuf == null) {
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(2).setAutoExpand(true);
            byteBuffer3.putString(this.delimiter.getValue(), this.charset.newEncoder());
            byteBuffer3.flip();
            this.delimBuf = byteBuffer3;
        }
        int n2 = n;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (this.delimBuf.get(n) == by) {
                if (++n != this.delimBuf.limit()) continue;
                int n5 = byteBuffer.position();
                byteBuffer.limit(n5 - n + n2);
                byteBuffer.position(n3);
                byteBuffer2.put(byteBuffer);
                if (byteBuffer2.position() > this.maxLineLength) {
                    throw new BufferDataException("Line is too long: " + byteBuffer2.position());
                }
                byteBuffer2.flip();
                protocolDecoderOutput.write(byteBuffer2.getString(charsetDecoder));
                byteBuffer2.clear();
                byteBuffer.limit(n4);
                byteBuffer.position(n5);
                n3 = n5;
                n = 0;
                continue;
            }
            n = 0;
        }
        byteBuffer.position(n3);
        byteBuffer.limit(byteBuffer.limit() - n + n2);
        byteBuffer2.put(byteBuffer);
        return n;
    }

    private class Context {
        private final CharsetDecoder decoder;
        private final ByteBuffer buf;
        private int matchCount = 0;

        private Context() {
            this.decoder = TextLineDecoder.this.charset.newDecoder();
            this.buf = ByteBuffer.allocate(80).setAutoExpand(true);
        }

        public CharsetDecoder getDecoder() {
            return this.decoder;
        }

        public ByteBuffer getBuffer() {
            return this.buf;
        }

        public int getMatchCount() {
            return this.matchCount;
        }

        public void setMatchCount(int n) {
            this.matchCount = n;
        }
    }
}

