/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.textline;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.util.CharsetUtil;

public class TextLineEncoder
extends ProtocolEncoderAdapter {
    private static final String ENCODER = TextLineEncoder.class.getName() + ".encoder";
    private final Charset charset;
    private final LineDelimiter delimiter;
    private int maxLineLength = Integer.MAX_VALUE;

    public TextLineEncoder() {
        this(CharsetUtil.getDefaultCharset(), LineDelimiter.UNIX);
    }

    public TextLineEncoder(LineDelimiter lineDelimiter) {
        this(CharsetUtil.getDefaultCharset(), lineDelimiter);
    }

    public TextLineEncoder(Charset charset) {
        this(charset, LineDelimiter.UNIX);
    }

    public TextLineEncoder(Charset charset, LineDelimiter lineDelimiter) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (lineDelimiter == null) {
            throw new NullPointerException("delimiter");
        }
        if (LineDelimiter.AUTO.equals(lineDelimiter)) {
            throw new IllegalArgumentException("AUTO delimiter is not allowed for encoder.");
        }
        this.charset = charset;
        this.delimiter = lineDelimiter;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxLineLength: " + n);
        }
        this.maxLineLength = n;
    }

    @Override
    public void encode(IoSession ioSession, Object object, ProtocolEncoderOutput protocolEncoderOutput) throws Exception {
        CharsetEncoder charsetEncoder = (CharsetEncoder)ioSession.getAttribute(ENCODER);
        if (charsetEncoder == null) {
            charsetEncoder = this.charset.newEncoder();
            ioSession.setAttribute(ENCODER, charsetEncoder);
        }
        String string = object.toString();
        ByteBuffer byteBuffer = ByteBuffer.allocate(string.length()).setAutoExpand(true);
        byteBuffer.putString(string, charsetEncoder);
        if (byteBuffer.position() > this.maxLineLength) {
            throw new IllegalArgumentException("Line length: " + byteBuffer.position());
        }
        byteBuffer.putString(this.delimiter.getValue(), charsetEncoder);
        byteBuffer.flip();
        protocolEncoderOutput.write(byteBuffer);
    }

    public void dispose() throws Exception {
    }
}

