/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.ByteBufferUtil;

public class ExecutorFilter
extends IoFilterAdapter {
    private final Executor executor;
    long lastSendTime = -1L;
    public static Executor forcedThreadPool = null;

    public ExecutorFilter() {
        this(forcedThreadPool != null ? forcedThreadPool : new ThreadPoolExecutor(16, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public ExecutorFilter(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(IoFilter.NextFilter nextFilter, IoSession ioSession, EventType eventType, Object object) {
        Event event = new Event(eventType, nextFilter, object);
        SessionBuffer sessionBuffer = SessionBuffer.getSessionBuffer(ioSession);
        boolean bl = false;
        List list = sessionBuffer.eventQueue;
        synchronized (list) {
            if (eventType == EventType.RECEIVED && object instanceof ByteBuffer) {
                ioSession.incrementMessageBytesWaiting(((ByteBuffer)object).limit());
            }
            sessionBuffer.eventQueue.add(event);
            if (sessionBuffer.processingCompleted) {
                sessionBuffer.processingCompleted = false;
                bl = true;
            }
        }
        if (bl) {
            ioSession.pushInQueue();
            this.executor.execute(new ProcessEventsRunnable(sessionBuffer));
        }
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession ioSession) {
        nextFilter.sessionCreated(ioSession);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession ioSession) {
        this.fireEvent(nextFilter, ioSession, EventType.OPENED, null);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) {
        this.fireEvent(nextFilter, ioSession, EventType.CLOSED, null);
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession ioSession, IdleStatus idleStatus) {
        this.fireEvent(nextFilter, ioSession, EventType.IDLE, idleStatus);
    }

    @Override
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession ioSession, Throwable throwable) {
        this.fireEvent(nextFilter, ioSession, EventType.EXCEPTION, throwable);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
        ByteBufferUtil.acquireIfPossible(object);
        this.fireEvent(nextFilter, ioSession, EventType.RECEIVED, object);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
        ByteBufferUtil.acquireIfPossible(object);
        this.fireEvent(nextFilter, ioSession, EventType.SENT, object);
    }

    protected void processEvent(IoFilter.NextFilter nextFilter, IoSession ioSession, EventType eventType, Object object) {
        if (eventType == EventType.RECEIVED) {
            nextFilter.messageReceived(ioSession, object);
            ByteBufferUtil.releaseIfPossible(object);
        } else if (eventType == EventType.SENT) {
            nextFilter.messageSent(ioSession, object);
            ByteBufferUtil.releaseIfPossible(object);
        } else if (eventType == EventType.EXCEPTION) {
            nextFilter.exceptionCaught(ioSession, (Throwable)object);
        } else if (eventType == EventType.IDLE) {
            nextFilter.sessionIdle(ioSession, (IdleStatus)object);
        } else if (eventType == EventType.OPENED) {
            nextFilter.sessionOpened(ioSession);
        } else if (eventType == EventType.CLOSED) {
            nextFilter.sessionClosed(ioSession);
        }
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) {
        nextFilter.filterWrite(ioSession, writeRequest);
    }

    @Override
    public void filterClose(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        nextFilter.filterClose(ioSession);
    }

    private class ProcessEventsRunnable
    implements Runnable {
        private final SessionBuffer buffer;

        ProcessEventsRunnable(SessionBuffer sessionBuffer) {
            this.buffer = sessionBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Event event;
                List list = this.buffer.eventQueue;
                synchronized (list) {
                    if (this.buffer.eventQueue.isEmpty()) {
                        this.buffer.processingCompleted = true;
                        break;
                    }
                    event = (Event)this.buffer.eventQueue.remove(0);
                }
                if (event.getType() == EventType.RECEIVED && event.getData() instanceof ByteBuffer) {
                    this.buffer.session.descrementMessageBytesWaiting(((ByteBuffer)event.getData()).limit());
                }
                ExecutorFilter.this.processEvent(event.getNextFilter(), this.buffer.session, event.getType(), event.getData());
            }
            this.buffer.session.popInQueue();
        }
    }

    protected static class Event {
        private final EventType type;
        private final IoFilter.NextFilter nextFilter;
        private final Object data;

        Event(EventType eventType, IoFilter.NextFilter nextFilter, Object object) {
            this.type = eventType;
            this.nextFilter = nextFilter;
            this.data = object;
        }

        public Object getData() {
            return this.data;
        }

        public IoFilter.NextFilter getNextFilter() {
            return this.nextFilter;
        }

        public EventType getType() {
            return this.type;
        }
    }

    protected static class EventType {
        public static final EventType OPENED = new EventType("OPENED");
        public static final EventType CLOSED = new EventType("CLOSED");
        public static final EventType READ = new EventType("READ");
        public static final EventType WRITTEN = new EventType("WRITTEN");
        public static final EventType RECEIVED = new EventType("RECEIVED");
        public static final EventType SENT = new EventType("SENT");
        public static final EventType IDLE = new EventType("IDLE");
        public static final EventType EXCEPTION = new EventType("EXCEPTION");
        private final String value;

        private EventType(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class SessionBuffer {
        private static final String KEY = SessionBuffer.class.getName() + ".KEY";
        private final IoSession session;
        private final List eventQueue = new ArrayList();
        private boolean processingCompleted = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static SessionBuffer getSessionBuffer(IoSession ioSession) {
            IoSession ioSession2 = ioSession;
            synchronized (ioSession2) {
                SessionBuffer sessionBuffer = (SessionBuffer)ioSession.getAttribute(KEY);
                if (sessionBuffer == null) {
                    sessionBuffer = new SessionBuffer(ioSession);
                    ioSession.setAttribute(KEY, sessionBuffer);
                }
                return sessionBuffer;
            }
        }

        private SessionBuffer(IoSession ioSession) {
            this.session = ioSession;
        }
    }
}

