/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;

public class SocketSessionConfigImpl
extends BaseIoSessionConfig
implements SocketSessionConfig {
    private static boolean SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
    private static boolean SET_SEND_BUFFER_SIZE_AVAILABLE = false;
    private static boolean GET_TRAFFIC_CLASS_AVAILABLE = false;
    private static boolean SET_TRAFFIC_CLASS_AVAILABLE = false;
    private static boolean DEFAULT_REUSE_ADDRESS;
    private static int DEFAULT_RECEIVE_BUFFER_SIZE;
    private static int DEFAULT_SEND_BUFFER_SIZE;
    private static int DEFAULT_TRAFFIC_CLASS;
    private static boolean DEFAULT_KEEP_ALIVE;
    private static boolean DEFAULT_OOB_INLINE;
    private static int DEFAULT_SO_LINGER;
    private static boolean DEFAULT_TCP_NO_DELAY;
    private boolean reuseAddress = DEFAULT_REUSE_ADDRESS;
    private int receiveBufferSize = DEFAULT_RECEIVE_BUFFER_SIZE;
    private int readBufferSize = DEFAULT_RECEIVE_BUFFER_SIZE;
    private int sendBufferSize = DEFAULT_SEND_BUFFER_SIZE;
    private int trafficClass = DEFAULT_TRAFFIC_CLASS;
    private boolean keepAlive = DEFAULT_KEEP_ALIVE;
    private boolean oobInline = DEFAULT_OOB_INLINE;
    private int soLinger = DEFAULT_SO_LINGER;
    private boolean tcpNoDelay = DEFAULT_TCP_NO_DELAY;

    private static void initialize() {
        Socket socket = null;
        socket = new Socket();
        try {
            DEFAULT_REUSE_ADDRESS = socket.getReuseAddress();
            DEFAULT_RECEIVE_BUFFER_SIZE = socket.getReceiveBufferSize();
            DEFAULT_SEND_BUFFER_SIZE = socket.getSendBufferSize();
            DEFAULT_KEEP_ALIVE = socket.getKeepAlive();
            DEFAULT_OOB_INLINE = socket.getOOBInline();
            DEFAULT_SO_LINGER = socket.getSoLinger();
            DEFAULT_TCP_NO_DELAY = socket.getTcpNoDelay();
            try {
                socket.setReceiveBufferSize(DEFAULT_RECEIVE_BUFFER_SIZE);
                SET_RECEIVE_BUFFER_SIZE_AVAILABLE = true;
            }
            catch (SocketException socketException) {
                SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
            }
            try {
                socket.setSendBufferSize(DEFAULT_SEND_BUFFER_SIZE);
                SET_SEND_BUFFER_SIZE_AVAILABLE = true;
            }
            catch (SocketException socketException) {
                SET_SEND_BUFFER_SIZE_AVAILABLE = false;
            }
            try {
                DEFAULT_TRAFFIC_CLASS = socket.getTrafficClass();
                GET_TRAFFIC_CLASS_AVAILABLE = true;
            }
            catch (SocketException socketException) {
                GET_TRAFFIC_CLASS_AVAILABLE = false;
                DEFAULT_TRAFFIC_CLASS = 0;
            }
        }
        catch (SocketException socketException) {
            throw new ExceptionInInitializerError(socketException);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                }
            }
        }
    }

    public static boolean isSetReceiveBufferSizeAvailable() {
        return SET_RECEIVE_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isSetSendBufferSizeAvailable() {
        return SET_SEND_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isGetTrafficClassAvailable() {
        return GET_TRAFFIC_CLASS_AVAILABLE;
    }

    public static boolean isSetTrafficClassAvailable() {
        return SET_TRAFFIC_CLASS_AVAILABLE;
    }

    @Override
    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @Override
    public void setReuseAddress(boolean bl) {
        this.reuseAddress = bl;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setReceiveBufferSize(int n) {
        this.receiveBufferSize = n;
    }

    @Override
    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Override
    public void setSendBufferSize(int n) {
        this.sendBufferSize = n;
    }

    @Override
    public int getTrafficClass() {
        return this.trafficClass;
    }

    @Override
    public void setTrafficClass(int n) {
        this.trafficClass = n;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }

    @Override
    public boolean isOobInline() {
        return this.oobInline;
    }

    @Override
    public void setOobInline(boolean bl) {
        this.oobInline = bl;
    }

    @Override
    public int getSoLinger() {
        return this.soLinger;
    }

    @Override
    public void setSoLinger(int n) {
        this.soLinger = n;
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public void setTcpNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int n) {
        this.readBufferSize = n;
    }

    static {
        SocketSessionConfigImpl.initialize();
    }
}

