/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionRecycler;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.DatagramServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.Queue;

public class DatagramConnectorDelegate
extends BaseIoConnector
implements DatagramService {
    private static volatile int nextId = 0;
    private final IoConnector wrapper;
    private final Executor executor;
    private final int id = nextId++;
    private Selector selector = null;
    private DatagramConnectorConfig defaultConfig = new DatagramConnectorConfig();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final Queue flushingSessions = new Queue();
    private final Queue trafficControllingSessions = new Queue();
    private Worker worker = null;
    private Object lock = new Object();
    private int udpManagedDeliveryDelay = -1;
    private int udpManagedDeliveryCount = -1;

    public DatagramConnectorDelegate(IoConnector ioConnector, Executor executor) {
        this.wrapper = ioConnector;
        this.executor = executor;
    }

    @Override
    public ConnectFuture connect(SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        return this.connect(socketAddress, null, ioHandler, ioServiceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        Object object;
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        if (ioHandler == null) {
            throw new NullPointerException("handler");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + socketAddress.getClass());
        }
        if (socketAddress2 != null && !(socketAddress2 instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + socketAddress2.getClass());
        }
        if (ioServiceConfig == null) {
            ioServiceConfig = this.getDefaultConfig();
        }
        DatagramChannel datagramChannel = null;
        boolean bl = false;
        try {
            datagramChannel = DatagramChannel.open();
            object = ioServiceConfig.getSessionConfig() instanceof DatagramSessionConfig ? (DatagramSessionConfig)ioServiceConfig.getSessionConfig() : (DatagramSessionConfig)this.getDefaultConfig().getSessionConfig();
            datagramChannel.socket().setReuseAddress(object.isReuseAddress());
            datagramChannel.socket().setBroadcast(object.isBroadcast());
            datagramChannel.socket().setReceiveBufferSize(object.getReceiveBufferSize());
            datagramChannel.socket().setSendBufferSize(object.getSendBufferSize());
            if (datagramChannel.socket().getTrafficClass() != object.getTrafficClass()) {
                datagramChannel.socket().setTrafficClass(object.getTrafficClass());
            }
            if (socketAddress2 != null) {
                datagramChannel.socket().bind(socketAddress2);
            }
            datagramChannel.connect(socketAddress);
            datagramChannel.configureBlocking(false);
            bl = true;
        }
        catch (IOException iOException) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture(iOException);
            return connectFuture;
        }
        finally {
            if (!bl && datagramChannel != null) {
                try {
                    datagramChannel.disconnect();
                    datagramChannel.close();
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                }
            }
        }
        object = new RegistrationRequest(datagramChannel, ioHandler, ioServiceConfig);
        Object object2 = this.lock;
        synchronized (object2) {
            try {
                this.startupWorker();
            }
            catch (IOException iOException) {
                try {
                    datagramChannel.disconnect();
                    datagramChannel.close();
                }
                catch (IOException iOException2) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException2);
                }
                return DefaultConnectFuture.newFailedFuture(iOException);
            }
            this.registerQueue.push(object);
            this.selector.wakeup();
        }
        return object;
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(DatagramConnectorConfig datagramConnectorConfig) {
        if (datagramConnectorConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = datagramConnectorConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession(DatagramSessionImpl datagramSessionImpl) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException iOException) {
                return;
            }
            this.cancelQueue.push(datagramSessionImpl);
            this.selector.wakeup();
        }
    }

    @Override
    public void flushSession(DatagramSessionImpl datagramSessionImpl) {
        Selector selector;
        if (this.scheduleFlush(datagramSessionImpl) && (selector = this.selector) != null) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleFlush(DatagramSessionImpl datagramSessionImpl) {
        if (datagramSessionImpl.setScheduledForFlush(true)) {
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                this.flushingSessions.push(datagramSessionImpl);
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateTrafficMask(DatagramSessionImpl datagramSessionImpl) {
        this.scheduleTrafficControl(datagramSessionImpl);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
        selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTrafficControl(DatagramSessionImpl datagramSessionImpl) {
        Queue queue = this.trafficControllingSessions;
        synchronized (queue) {
            this.trafficControllingSessions.push(datagramSessionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateTrafficMask() {
        Object object = this.trafficControllingSessions;
        synchronized (object) {
            if (this.trafficControllingSessions.isEmpty()) {
                return;
            }
        }
        while (true) {
            Queue queue;
            Object object2 = this.trafficControllingSessions;
            synchronized (object2) {
                object = (DatagramSessionImpl)this.trafficControllingSessions.pop();
            }
            if (object == null) break;
            object2 = ((DatagramSessionImpl)object).getSelectionKey();
            if (object2 == null) {
                this.scheduleTrafficControl((DatagramSessionImpl)object);
                break;
            }
            if (!((SelectionKey)object2).isValid()) continue;
            int n = 1;
            Queue queue2 = queue = ((DatagramSessionImpl)object).getWriteRequestQueue();
            synchronized (queue2) {
                if (!queue.isEmpty()) {
                    n |= 4;
                }
            }
            int n2 = ((BaseIoSession)object).getTrafficMask().getInterestOps();
            ((SelectionKey)object2).interestOps(n & n2);
        }
    }

    private void processReadySessions(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = (SelectionKey)iterator.next();
            iterator.remove();
            DatagramSessionImpl datagramSessionImpl = (DatagramSessionImpl)selectionKey.attachment();
            this.getSessionRecycler(datagramSessionImpl).recycle(datagramSessionImpl.getLocalAddress(), datagramSessionImpl.getRemoteAddress());
            if (selectionKey.isReadable() && datagramSessionImpl.getTrafficMask().isReadable()) {
                this.readSession(datagramSessionImpl);
            }
            if (!selectionKey.isWritable() || !datagramSessionImpl.getTrafficMask().isWritable()) continue;
            this.scheduleFlush(datagramSessionImpl);
        }
    }

    private IoSessionRecycler getSessionRecycler(IoSession ioSession) {
        IoServiceConfig ioServiceConfig = ioSession.getServiceConfig();
        IoSessionRecycler ioSessionRecycler = ioServiceConfig instanceof DatagramServiceConfig ? ((DatagramServiceConfig)ioServiceConfig).getSessionRecycler() : this.defaultConfig.getSessionRecycler();
        return ioSessionRecycler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramSessionImpl datagramSessionImpl) {
        DatagramSessionConfig datagramSessionConfig = (DatagramSessionConfig)datagramSessionImpl.getConfig();
        int n = datagramSessionConfig.getReceiveBufferSize();
        if (datagramSessionConfig.getDatagramMaximumPacketSize() > 0) {
            n = datagramSessionConfig.getDatagramMaximumPacketSize();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n, false);
        try {
            int n2 = datagramSessionImpl.getChannel().read(byteBuffer.buf());
            if (n2 > 0) {
                byteBuffer.flip();
                datagramSessionImpl.increaseReadBytes(n2);
                datagramSessionImpl.getFilterChain().fireMessageReceived(datagramSessionImpl, byteBuffer);
            }
        }
        catch (IOException iOException) {
            datagramSessionImpl.getFilterChain().fireExceptionCaught(datagramSessionImpl, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        Object object = this.flushingSessions;
        synchronized (object) {
            if (this.flushingSessions.size() == 0) {
                return;
            }
        }
        while (true) {
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                object = (DatagramSessionImpl)this.flushingSessions.pop();
            }
            if (object == null) break;
            ((BaseIoSession)object).setScheduledForFlush(false);
            queue = ((DatagramSessionImpl)object).getWriteRequestQueue();
            try {
                boolean bl = this.flush((DatagramSessionImpl)object);
                boolean bl2 = false;
                Queue queue2 = queue;
                synchronized (queue2) {
                    bl2 = queue.isEmpty();
                }
                if (!bl || bl2 || ((BaseIoSession)object).isScheduledForFlush()) continue;
                this.scheduleFlush((DatagramSessionImpl)object);
            }
            catch (IOException iOException) {
                ((DatagramSessionImpl)object).getFilterChain().fireExceptionCaught((IoSession)object, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(DatagramSessionImpl datagramSessionImpl) throws IOException {
        Object object;
        SelectionKey selectionKey = datagramSessionImpl.getSelectionKey();
        if (selectionKey == null) {
            this.scheduleFlush(datagramSessionImpl);
            return false;
        }
        if (!selectionKey.isValid()) {
            return false;
        }
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
        DatagramChannel datagramChannel = datagramSessionImpl.getChannel();
        Queue queue = datagramSessionImpl.getWriteRequestQueue();
        if (this.udpManagedDeliveryDelay < 0) {
            this.udpManagedDeliveryDelay = 0;
            this.udpManagedDeliveryCount = 0;
            Integer n = (Integer)datagramSessionImpl.getAttribute("udpManagedDeliveryDelay");
            if (n != null) {
                this.udpManagedDeliveryDelay = n;
                object = (Integer)datagramSessionImpl.getAttribute("udpManagedDeliveryCount");
                if (object != null) {
                    this.udpManagedDeliveryCount = (Integer)object;
                }
            }
        }
        int n = 0;
        int n2 = 0;
        try {
            while (true) {
                Object object2 = queue;
                synchronized (object2) {
                    object = (IoFilter.WriteRequest)queue.first();
                }
                if (object == null) {
                    break;
                }
                object2 = (ByteBuffer)((IoFilter.WriteRequest)object).getMessage();
                if (((ByteBuffer)object2).remaining() == 0) {
                    Queue queue2 = queue;
                    synchronized (queue2) {
                        queue.pop();
                    }
                    ((ByteBuffer)object2).reset();
                    if (!((ByteBuffer)object2).hasRemaining()) {
                        datagramSessionImpl.increaseWrittenWriteRequests();
                    }
                    datagramSessionImpl.getFilterChain().fireMessageSent(datagramSessionImpl, (IoFilter.WriteRequest)object);
                    continue;
                }
                int n3 = datagramChannel.write(((ByteBuffer)object2).buf());
                n2 += n3;
                if (n3 == 0) {
                    selectionKey.interestOps(selectionKey.interestOps() | 4);
                    boolean bl = false;
                    return bl;
                }
                if (n3 > 0) {
                    selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
                    Queue queue3 = queue;
                    synchronized (queue3) {
                        queue.pop();
                    }
                    ((ByteBuffer)object2).reset();
                    if (!((ByteBuffer)object2).hasRemaining()) {
                        datagramSessionImpl.increaseWrittenWriteRequests();
                    }
                    datagramSessionImpl.getFilterChain().fireMessageSent(datagramSessionImpl, (IoFilter.WriteRequest)object);
                }
                if (this.udpManagedDeliveryCount <= 0 || n2 <= 0 || ++n % this.udpManagedDeliveryCount != 0) continue;
                try {
                    Thread.sleep(this.udpManagedDeliveryDelay);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            datagramSessionImpl.increaseWrittenBytes(n2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushNew(DatagramSessionImpl datagramSessionImpl) throws IOException {
        SelectionKey selectionKey = datagramSessionImpl.getSelectionKey();
        if (selectionKey == null) {
            this.scheduleFlush(datagramSessionImpl);
            return false;
        }
        if (!selectionKey.isValid()) {
            return false;
        }
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
        DatagramChannel datagramChannel = datagramSessionImpl.getChannel();
        Queue queue = datagramSessionImpl.getWriteRequestQueue();
        int n = 0;
        int n2 = ((DatagramSessionConfig)datagramSessionImpl.getConfig()).getSendBufferSize() << 1;
        try {
            while (true) {
                IoFilter.WriteRequest writeRequest = null;
                Object object = queue;
                synchronized (object) {
                    writeRequest = (IoFilter.WriteRequest)queue.first();
                }
                if (writeRequest == null) {
                    break;
                }
                object = (ByteBuffer)writeRequest.getMessage();
                if (((ByteBuffer)object).remaining() == 0) {
                    Queue queue2 = queue;
                    synchronized (queue2) {
                        queue.poll();
                    }
                    ((ByteBuffer)object).reset();
                    if (!((ByteBuffer)object).hasRemaining()) {
                        datagramSessionImpl.increaseWrittenMessages();
                    }
                    datagramSessionImpl.getFilterChain().fireMessageSent(datagramSessionImpl, writeRequest);
                    continue;
                }
                int n3 = datagramChannel.write(((ByteBuffer)object).buf());
                if (n3 == 0 || (n += n3) >= n2) {
                    selectionKey.interestOps(selectionKey.interestOps() | 4);
                    boolean bl = false;
                    return bl;
                }
                selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
                Queue queue3 = queue;
                synchronized (queue3) {
                    queue.poll();
                }
                ((ByteBuffer)object).reset();
                if (!((ByteBuffer)object).hasRemaining()) {
                    datagramSessionImpl.increaseWrittenMessages();
                }
                datagramSessionImpl.getFilterChain().fireMessageSent(datagramSessionImpl, writeRequest);
            }
        }
        finally {
            datagramSessionImpl.increaseWrittenBytes(n);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        Object object = this.lock;
        synchronized (object) {
            if (this.registerQueue.isEmpty()) {
                return;
            }
        }
        while (true) {
            Object object2 = this.lock;
            synchronized (object2) {
                object = (RegistrationRequest)this.registerQueue.pop();
            }
            if (object == null) return;
            object2 = new DatagramSessionImpl(this.wrapper, this, ((RegistrationRequest)object).config, ((RegistrationRequest)object).channel, ((RegistrationRequest)object).handler, ((RegistrationRequest)object).channel.socket().getRemoteSocketAddress(), ((RegistrationRequest)object).channel.socket().getLocalSocketAddress());
            boolean bl = false;
            try {
                this.buildFilterChain((RegistrationRequest)object, (IoSession)object2);
                this.getSessionRecycler((IoSession)object2).put((IoSession)object2);
                this.getListeners().fireSessionCreated((IoSession)object2);
                SelectionKey selectionKey = ((RegistrationRequest)object).channel.register(this.selector, 1, object2);
                ((DatagramSessionImpl)object2).setSelectionKey(selectionKey);
                ((DefaultConnectFuture)object).setSession((IoSession)object2);
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                ((DefaultConnectFuture)object).setException(throwable);
                continue;
            }
            finally {
                if (bl) continue;
                try {
                    ((RegistrationRequest)object).channel.disconnect();
                    ((RegistrationRequest)object).channel.close();
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                }
                continue;
            }
            break;
        }
    }

    private void buildFilterChain(RegistrationRequest registrationRequest, IoSession ioSession) throws Exception {
        this.getFilterChainBuilder().buildFilterChain(ioSession.getFilterChain());
        registrationRequest.config.getFilterChainBuilder().buildFilterChain(ioSession.getFilterChain());
        registrationRequest.config.getThreadModel().buildFilterChain(ioSession.getFilterChain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelKeys() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelQueue.isEmpty()) {
                return;
            }
        }
        while (true) {
            Object object2 = this.lock;
            synchronized (object2) {
                object = (DatagramSessionImpl)this.cancelQueue.pop();
            }
            if (object == null) break;
            object2 = ((DatagramSessionImpl)object).getSelectionKey();
            DatagramChannel datagramChannel = (DatagramChannel)((SelectionKey)object2).channel();
            try {
                datagramChannel.disconnect();
                datagramChannel.close();
            }
            catch (IOException iOException) {
                ExceptionMonitor.getInstance().exceptionCaught(iOException);
            }
            this.getListeners().fireSessionDestroyed((IoSession)object);
            ((BaseIoSession)object).getCloseFuture().setClosed();
            ((SelectionKey)object2).cancel();
            this.selector.wakeup();
        }
    }

    private static class RegistrationRequest
    extends DefaultConnectFuture {
        private final DatagramChannel channel;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private RegistrationRequest(DatagramChannel datagramChannel, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
            this.channel = datagramChannel;
            this.handler = ioHandler;
            this.config = ioServiceConfig;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("DatagramConnector-" + DatagramConnectorDelegate.this.id);
            while (true) {
                try {
                    do {
                        int n = DatagramConnectorDelegate.this.selector.select();
                        DatagramConnectorDelegate.this.registerNew();
                        DatagramConnectorDelegate.this.doUpdateTrafficMask();
                        if (n > 0) {
                            DatagramConnectorDelegate.this.processReadySessions(DatagramConnectorDelegate.this.selector.selectedKeys());
                        }
                        DatagramConnectorDelegate.this.flushSessions();
                        DatagramConnectorDelegate.this.cancelKeys();
                    } while (!DatagramConnectorDelegate.this.selector.keys().isEmpty());
                    Object object = DatagramConnectorDelegate.this.lock;
                    synchronized (object) {
                        if (DatagramConnectorDelegate.this.selector.keys().isEmpty() && DatagramConnectorDelegate.this.registerQueue.isEmpty() && DatagramConnectorDelegate.this.cancelQueue.isEmpty()) {
                            DatagramConnectorDelegate.this.worker = null;
                            try {
                                DatagramConnectorDelegate.this.selector.close();
                            }
                            catch (IOException iOException) {
                                ExceptionMonitor.getInstance().exceptionCaught(iOException);
                            }
                            finally {
                                DatagramConnectorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

