/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe.support;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;

public class VmPipeIdleStatusChecker {
    private static final VmPipeIdleStatusChecker INSTANCE = new VmPipeIdleStatusChecker();
    private final Map sessions = new IdentityHashMap();
    private final Worker worker = new Worker();

    public static VmPipeIdleStatusChecker getInstance() {
        return INSTANCE;
    }

    private VmPipeIdleStatusChecker() {
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(VmPipeSessionImpl vmPipeSessionImpl) {
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.put(vmPipeSessionImpl, vmPipeSessionImpl);
        }
    }

    private void notifyIdleSession(VmPipeSessionImpl vmPipeSessionImpl, long l) {
        this.notifyIdleSession0(vmPipeSessionImpl, l, vmPipeSessionImpl.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(vmPipeSessionImpl.getLastIoTime(), vmPipeSessionImpl.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        this.notifyIdleSession0(vmPipeSessionImpl, l, vmPipeSessionImpl.getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(vmPipeSessionImpl.getLastReadTime(), vmPipeSessionImpl.getLastIdleTime(IdleStatus.READER_IDLE)));
        this.notifyIdleSession0(vmPipeSessionImpl, l, vmPipeSessionImpl.getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(vmPipeSessionImpl.getLastWriteTime(), vmPipeSessionImpl.getLastIdleTime(IdleStatus.WRITER_IDLE)));
    }

    private void notifyIdleSession0(VmPipeSessionImpl vmPipeSessionImpl, long l, long l2, IdleStatus idleStatus, long l3) {
        if (l2 > 0L && l3 != 0L && l - l3 >= l2) {
            vmPipeSessionImpl.increaseIdleCount(idleStatus);
            vmPipeSessionImpl.getFilterChain().fireSessionIdle(vmPipeSessionImpl, idleStatus);
        }
    }

    private class Worker
    extends Thread {
        private Worker() {
            super("VmPipeIdleStatusChecker");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l = System.currentTimeMillis();
                Map map = VmPipeIdleStatusChecker.this.sessions;
                synchronized (map) {
                    Iterator iterator = VmPipeIdleStatusChecker.this.sessions.keySet().iterator();
                    while (iterator.hasNext()) {
                        VmPipeSessionImpl vmPipeSessionImpl = (VmPipeSessionImpl)iterator.next();
                        if (!vmPipeSessionImpl.isConnected()) {
                            iterator.remove();
                            continue;
                        }
                        VmPipeIdleStatusChecker.this.notifyIdleSession(vmPipeSessionImpl, l);
                    }
                }
            }
        }
    }
}

