/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.application;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.ZipUtils;
import com.wowza.wms.httpstreamer.model.HTTPStreamerList;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import com.wowza.wms.rest.application.ApplicationsConfig;
import com.wowza.wms.rest.application.drm.DRMConfig;
import com.wowza.wms.rest.application.dvr.DVRConfig;
import com.wowza.wms.rest.application.modules.ModulesConfig;
import com.wowza.wms.rest.application.security.SecurityConfig;
import com.wowza.wms.rest.application.stream.StreamConfig;
import com.wowza.wms.rest.application.transcoder.TranscoderAppConfig;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Application")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}", restVerbs="GET,POST,PUT,DELETE", xmlFilename="Application.xml")
public class ApplicationConfig
extends ApplicationConfigBase {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSXMLVariable(xpath="/Root/Application/Name/text()")
    protected String name;
    @JsonProperty(value="appType")
    @XStreamAlias(value="AppType")
    @WMSXMLVariable(xpath="/Root/Application/AppType/text()")
    protected String appType;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/Application/Description/text()")
    protected String description;
    @JsonProperty(value="applicationTimeout")
    @XStreamAlias(value="ApplicationTimeout")
    @WMSXMLVariable(xpath="/Root/Application/ApplicationTimeout/text()")
    protected int applicationTimeout;
    @JsonProperty(value="pingTimeout")
    @XStreamAlias(value="PingTimeout")
    @WMSXMLVariable(xpath="/Root/Application/PingTimeout/text()")
    protected int pingTimeout;
    @JsonProperty(value="repeaterOriginURL")
    @XStreamAlias(value="RepeaterOriginURL")
    @WMSXMLVariable(xpath="/Root/Application/Repeater/OriginURL/text()")
    protected String repeaterOriginURL;
    @JsonProperty(value="repeaterQueryString")
    @XStreamAlias(value="RepeaterQueryString")
    @WMSXMLVariable(xpath="/Root/Application/Repeater/QueryString/text()")
    protected String repeaterQueryString;
    @JsonProperty(value="clientStreamReadAccess")
    @XStreamAlias(value="ClientStreamReadAccess")
    @WMSXMLVariable(xpath="/Root/Application/Client/Access/StreamReadAccess/text()")
    protected String clientStreamReadAccess;
    @JsonProperty(value="clientStreamWriteAccess")
    @XStreamAlias(value="ClientStreamWriteAccess")
    @WMSXMLVariable(xpath="/Root/Application/Client/Access/StreamWriteAccess/text()")
    protected String clientStreamWriteAccess;
    @JsonProperty(value="httpStreamers")
    @XStreamAlias(value="HTTPStreamers")
    @WMSXMLVariable(xpath="/Root/Application/HTTPStreamers/text()")
    protected List<String> httpStreamers;
    @JsonProperty(value="mediaCacheSourceList")
    @XStreamAlias(value="MediaCacheSourceList")
    @WMSXMLVariable(xpath="/Root/Application/MediaCache/MediaCacheSourceList/text()")
    protected List<String> mediaCacheSourceList;
    @JsonProperty(value="mediaReaderRandomAccessReaderClass")
    @XStreamAlias(value="MediaReaderRandomAccessReaderClass")
    @WMSXMLProperty(root="/Root/Application/MediaReader", name="randomAccessReaderClass", defaultValue="")
    protected String mediaReaderRandomAccessReaderClass;
    @JsonProperty(value="httpOptimizeFileReads")
    @XStreamAlias(value="HTTPOptimizeFileReads")
    @WMSXMLProperty(root="/Root/Application/HTTPStreamer", name="httpOptimizeFileReads", defaultValue="false")
    protected boolean httpOptimizeFileReads;
    @JsonProperty(value="mediaReaderBufferSeekIO")
    @XStreamAlias(value="MediaReaderBufferSeekIO")
    @WMSXMLProperty(root="/Root/Application/MediaReader", name="bufferSeekIO", defaultValue="false")
    protected boolean mediaReaderBufferSeekIO;
    @JsonProperty(value="captionLiveIngestType")
    @XStreamAlias(value="CaptionLiveIngestType")
    @WMSXMLProperty(root="/Root/Application/TimedText", name="captionLiveIngestType", defaultValue="")
    protected String captionLiveIngestType;
    @JsonProperty(value="vodTimedTextProviders")
    @XStreamAlias(value="VODTimedTextProviders")
    @WMSXMLVariable(xpath="/Root/Application/TimedText/VODTimedTextProviders/text()")
    protected List<String> vodTimedTextProviders;
    @XStreamOmitField
    protected List<String> httpStreamersOptions;
    @JsonProperty(value="securityConfig")
    @XStreamAlias(value="SecuirtyConfig")
    protected SecurityConfig securityConfig;
    @JsonProperty(value="streamConfig")
    @XStreamAlias(value="StreamConfig")
    protected StreamConfig streamConfig;
    @JsonProperty(value="dvrConfig")
    @XStreamAlias(value="DVRConfig")
    protected DVRConfig dvrConfig;
    @JsonProperty(value="drmConfig")
    @XStreamAlias(value="DRMConfig")
    protected DRMConfig drmConfig;
    @JsonProperty(value="transcoderConfig")
    @XStreamAlias(value="TranscoderConfig")
    protected TranscoderAppConfig transcoderConfig;
    @JsonProperty(value="modules")
    @XStreamAlias(value="Modules")
    protected ModulesConfig modules;

    public ApplicationConfig() {
    }

    public ApplicationConfig(String string, String string2) {
        super(string, string2);
        this.name = string2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String string) {
        this.appType = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getApplicationTimeout() {
        return this.applicationTimeout;
    }

    public void setApplicationTimeout(int n) {
        this.applicationTimeout = n;
    }

    public int getPingTimeout() {
        return this.pingTimeout;
    }

    public void setPingTimeout(int n) {
        this.pingTimeout = n;
    }

    public StreamConfig getStreamConfig() {
        return this.streamConfig;
    }

    public void setStreamConfig(StreamConfig streamConfig) {
        this.streamConfig = streamConfig;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public DRMConfig getDrmConfig() {
        return this.drmConfig;
    }

    public TranscoderAppConfig getTranscoderConfig() {
        return this.transcoderConfig;
    }

    public void setTranscoderConfig(TranscoderAppConfig transcoderAppConfig) {
        this.transcoderConfig = transcoderAppConfig;
    }

    public void setDrmConfig(DRMConfig dRMConfig) {
        this.drmConfig = dRMConfig;
    }

    public String getRepeaterOriginURL() {
        return this.repeaterOriginURL;
    }

    public void setRepeaterOriginURL(String string) {
        this.repeaterOriginURL = string;
    }

    public String getRepeaterQueryString() {
        return this.repeaterQueryString;
    }

    public void setRepeaterQueryString(String string) {
        this.repeaterQueryString = string;
    }

    public DVRConfig getDvrConfig() {
        return this.dvrConfig;
    }

    public void setDvrConfig(DVRConfig dVRConfig) {
        this.dvrConfig = dVRConfig;
    }

    public List<String> getHttpStreamers() {
        return this.httpStreamers;
    }

    public void setHttpStreamers(List<String> list) {
        this.httpStreamers = list;
    }

    public List<String> getHttpStreamersOptions() {
        return this.httpStreamersOptions;
    }

    public void setHttpStreamersOptions(List<String> list) {
        this.httpStreamersOptions = list;
    }

    public String getClientStreamReadAccess() {
        return this.clientStreamReadAccess;
    }

    public void setClientStreamReadAccess(String string) {
        this.clientStreamReadAccess = string;
    }

    public String getClientStreamWriteAccess() {
        return this.clientStreamWriteAccess;
    }

    public void setClientStreamWriteAccess(String string) {
        this.clientStreamWriteAccess = string;
    }

    public String getMediaReaderRandomAccessReaderClass() {
        return this.mediaReaderRandomAccessReaderClass;
    }

    public List<String> getMediaCacheSourceList() {
        return this.mediaCacheSourceList;
    }

    public void setMediaCacheSourceList(List<String> list) {
        this.mediaCacheSourceList = list;
    }

    public void setMediaReaderRandomAccessReaderClass(String string) {
        this.mediaReaderRandomAccessReaderClass = string;
    }

    public boolean isMediaReaderBufferSeekIO() {
        return this.mediaReaderBufferSeekIO;
    }

    public void setMediaReaderBufferSeekIO(boolean bl) {
        this.mediaReaderBufferSeekIO = bl;
    }

    public boolean isHttpOptimizeFileReads() {
        return this.httpOptimizeFileReads;
    }

    public void setHttpOptimizeFileReads(boolean bl) {
        this.httpOptimizeFileReads = bl;
    }

    public String getCaptionLiveIngestType() {
        return this.captionLiveIngestType;
    }

    public void setCaptionLiveIngestType(String string) {
        this.captionLiveIngestType = string;
    }

    public List<String> getVodTimedTextProviders() {
        return this.vodTimedTextProviders;
    }

    public void setVodTimedTextProviders(List<String> list) {
        this.vodTimedTextProviders = list;
    }

    public ModulesConfig getModules() {
        return this.modules;
    }

    public void setModules(ModulesConfig modulesConfig) {
        this.modules = modulesConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void a() {
        try {
            Class.forName(Utils.lastIndexOf("obc!g~eiu;azk7lssnj1\t\u0017\n,71", 21 - -23));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhost);
            if (iVHost == null) return;
            this.httpStreamersOptions = new ArrayList<String>();
            HTTPStreamerList hTTPStreamerList = iVHost.getHTTPStreamerList();
            Map map = hTTPStreamerList.getHTTPStreamerDefs();
            Iterator iterator = map.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Collections.sort(this.httpStreamersOptions);
                    return;
                }
                String string = (String)iterator.next();
                this.httpStreamersOptions.add(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    @Override
    public boolean loadObject() {
        this.a();
        boolean bl = super.loadObject();
        return bl;
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        ApplicationsConfig.updateAppplicationInfoCache(this.vhost, this.appName, this);
        return super.saveObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WMSResponse saveNewObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Severity.valueOf(47 - 37, "XN_Y.N@X(3Uqr~v~:Zlmrvc`vjkk&' ") + this.name + Utils.lastIndexOf("td\u007f\t/b76$\"\"h:\"$;m# 44|st\u001b9#x8>?539\u007ffhnf*", 90 + 3)));
            wMSResponse.success = true;
            wMSResponse.message = Severity.valueOf(9 * 37, "\f*+55");
            return wMSResponse;
        }
        String string = this.name;
        String string2 = this.getStringVariable(Severity.valueOf(54 + 26, "&9=  "));
        String string3 = this.getFilename();
        string3 = string3.substring(0, string3.lastIndexOf(47));
        File file = new File(string3.replace(Severity.valueOf(879 / 181, "+fiin&"), "/applications/"));
        file.mkdir();
        File file2 = new File(string3);
        file2.mkdir();
        try {
            ApplicationConfig.copyFile(VHostsConfig.getVHostDir(string2) + Severity.valueOf(35 * 3, "f)$\"+a") + this.getXMLFilename(), this.getFilename());
            wMSResponse = this.saveObject();
            if (!wMSResponse.isSuccess()) return wMSResponse;
            IStatsManager iStatsManager = StatsManager.getInstance();
            if (iStatsManager.isEnabled()) {
                iStatsManager.getStatsDatabaseManager().applicationGetDatabase(string2, string);
            }
            wMSResponse.message = Severity.valueOf(958 / 222, "Euvkajk\u007feb`/8") + string + Severity.valueOf(2 + 2, "-%eumh~nh-}zsrw`gsc{t`4");
            ApplicationsConfig.updateAppplicationInfoCache(string2, string, this);
            return wMSResponse;
        }
        catch (ConfigBase.ConfigBaseException configBaseException) {
            wMSResponse.message = configBaseException.getMessage();
            ConfigBase.log.warn((Object)Utils.lastIndexOf("@tug{*hc}wf~v2rdez~{xnrss", 59 * 31), (Throwable)configBaseException);
            return wMSResponse;
        }
        catch (IOException iOException) {
            wMSResponse.message = iOException.getMessage();
            ConfigBase.log.warn((Object)Utils.lastIndexOf("\u0019/,02a!,4</)/i+;<!',1%;<:", 125 + 95), (Throwable)iOException);
            return wMSResponse;
        }
        catch (FileNotFoundException fileNotFoundException) {
            wMSResponse.message = fileNotFoundException.getMessage();
            ConfigBase.log.warn((Object)Severity.valueOf(1140 / 179, "Cuzfx+ob~vy\u007fu3uef{qz{ourp"), (Throwable)fileNotFoundException);
            return wMSResponse;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse;
        block4: {
            String string = this.getStringVariable(Utils.lastIndexOf("k{|Cobu", 44 + 94));
            String string2 = this.getStringVariable(Severity.valueOf(35 * 25, "=$\"=;"));
            wMSResponse = new WMSResponse();
            if (ConfigBase.inTradeShowMode) {
                ConfigBase.log.warn((Object)(Severity.valueOf(59 * 47, "\u0007\u0013\u0004\fy\u001b\u000b\u0015g~\u001b%-'7-+!g\t9:kd") + string + Severity.valueOf(63 * 7, "0 ;Us>k2 &&d6.(?i'$((`op\u001f='t13;=-35;}\u001f/0o")));
                wMSResponse.success = true;
                wMSResponse.message = Severity.valueOf(-5 - -51, "Jj|tfvp");
                return wMSResponse;
            }
            try {
                String string3;
                block6: {
                    String string4;
                    String string5;
                    block7: {
                        block5: {
                            Class.forName(Utils.lastIndexOf(",?<|$;\",6v.7(r+60su,JRMit|", 82 + 29));
                            IVHost iVHost = VHostSingleton.getInstance((String)string2);
                            if (iVHost == null) break block5;
                            iVHost.shutdownApplication(string, true);
                            string3 = this.getFilename();
                            string3 = string3.substring(0, string3.lastIndexOf(47));
                            string5 = string + "_" + DateTime.now().toString(Severity.valueOf(43 + 84, "&yx{NIab*@Agf\u007f~")) + Severity.valueOf(27 * 25, "-~lv");
                            string4 = iVHost.getHomePath() + Severity.valueOf(24 - -58, "}156=\"(v942;");
                            if (ZipUtils.zipDirectory((String)string3, (String)string4, (String)string5)) break block6;
                            break block7;
                        }
                        wMSResponse.message = Severity.valueOf(103 + 63, "Eh}en+bbz/tt~v`p6vhivr\u007f|jv//");
                        break block4;
                    }
                    ConfigBase.log.error((Object)(Utils.lastIndexOf("\u000268879}*0` 0 ,,0\"h(:; $-.$8==t", 49 * 7) + string + Severity.valueOf(21 * 21, "9nt<") + string4 + "/" + string5));
                }
                File file = new File(string3);
                ApplicationConfig.deleteFolder(file);
                File file2 = new File(string3.replace(Severity.valueOf(889 / 231, ",gjha'"), "/applications/"));
                ApplicationConfig.deleteFolder(file2);
                wMSResponse.success = true;
                wMSResponse.message = Utils.lastIndexOf("\u0013#$9?49-342}v", 119 + -5) + string + Severity.valueOf(5 * 5, "0:\u007fyq{kee\"pqfeb{zl~`aw");
                ApplicationsConfig.deleteAppplicationInfoCache(string2, string);
            }
            catch (Exception exception) {
                wMSResponse.success = false;
                wMSResponse.message = exception.getMessage();
            }
        }
        if (wMSResponse.isSuccess()) {
            ConfigBase.log.info((Object)(Utils.lastIndexOf("\u001b\u000f\u0018\u0018m\u000f\u001f\u0019kr\u0017193#=y\u001b+,17<!5+,*\u007ff", 39 * 15) + wMSResponse.message));
            return wMSResponse;
        }
        ConfigBase.log.error((Object)(Severity.valueOf(684 / 152, "V@US(HZB6-Jj|tfv4Tfgtpyzhtqq:!") + wMSResponse.message));
        return wMSResponse;
    }

    public static ApplicationConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.lastIndexOf("':<'!", 11 * 19), string);
        hashMap.put(Utils.lastIndexOf("$67\u0006('.", 3 * 23), string2);
        return (ApplicationConfig)ApplicationConfig.getObjectFromREST(ApplicationConfig.getUrl(hashMap, ApplicationConfig.class), ApplicationConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        if (this.saveFieldList != null && !this.saveFieldList.contains(Utils.lastIndexOf("w{vy", 11 - -46)) || this.name != null) {
            // empty if block
        }
        if (this.saveFieldList != null) {
            if (!this.saveFieldList.contains(Utils.lastIndexOf("vvgvd~hmstr", 2 - -16))) return bl;
        }
        if (this.description == null) return bl;
        if (!this.description.startsWith(Utils.lastIndexOf("h!3,", 51 - -12))) return bl;
        this.addWarningMessage(Severity.valueOf(699 / 211, "gaveuay~bcc"), "Testing, can't start with 'warn'");
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isValid(ConstraintValidatorContext var1_1) {
        block30: {
            block25: {
                block26: {
                    block20: {
                        block24: {
                            block29: {
                                block23: {
                                    block21: {
                                        block22: {
                                            block28: {
                                                block19: {
                                                    block27: {
                                                        var2_2 = super.isValid(var1_1);
                                                        if (this.saveFieldList == null) break block27;
                                                        break block28;
lbl4:
                                                        // 2 sources

                                                        while (true) {
                                                            if (this.name == null) break block19;
                                                            break block20;
                                                            break;
                                                        }
lbl7:
                                                        // 1 sources

                                                        while (this.httpStreamersOptions != null) {
                                                            break block21;
                                                        }
                                                        break block29;
lbl10:
                                                        // 1 sources

                                                        while (true) {
                                                            this.addErrorMessage(var1_1, Severity.valueOf(45 * 39, "3().\f43'\") 44"), Severity.valueOf(763 / 242, "Vjnhh\u007fg*cxy~\\dcwrypd-8") + var5_5);
                                                            var2_2 = false;
                                                            break block22;
                                                            break;
                                                        }
lbl14:
                                                        // 1 sources

                                                        while (true) {
                                                            if (!this.saveFieldList.contains(Utils.lastIndexOf("s\u007fr%", 3 * 63))) break block23;
                                                            ** GOTO lbl4
                                                            break;
                                                        }
lbl17:
                                                        // 1 sources

                                                        while (true) {
                                                            if (this.httpStreamersOptions.contains(var5_5.trim())) break block22;
                                                            ** continue;
                                                            break;
                                                        }
lbl20:
                                                        // 1 sources

                                                        while (true) {
                                                            this.addErrorMessage(var1_1, Severity.valueOf(8 + 111, "3=*9)5-*6oo"), "Testing, can't start with 'error'");
                                                            var2_2 = false;
                                                            break block24;
                                                            break;
                                                        }
                                                    }
lbl25:
                                                    // 2 sources

                                                    while (this.httpStreamers != null) {
                                                        ** GOTO lbl7
                                                    }
                                                    break block29;
                                                }
lbl29:
                                                // 2 sources

                                                while (true) {
                                                    this.addErrorMessage(var1_1, Utils.lastIndexOf("-%(#", 31 * 61), "Name cannot be empty.");
                                                    var2_2 = false;
                                                    break block23;
lbl33:
                                                    // 1 sources

                                                    while (this.saveFieldList.contains(Severity.valueOf(632 / 199, "gaveuay~bcc"))) {
                                                        break block25;
                                                    }
                                                    break block24;
                                                    break;
                                                }
                                            }
                                            if (!this.saveFieldList.contains(Severity.valueOf(1400 / 220, "ns|yY\u007f~hobuca"))) break block29;
                                            ** GOTO lbl25
lbl39:
                                            // 1 sources

                                            while (true) {
                                                var3_3.add(var5_5.trim());
                                                break block26;
                                                break;
                                            }
                                        }
                                        if (!var3_3.contains(var5_5.trim())) {
                                            ** continue;
                                        }
                                        break block26;
                                    }
                                    var3_3 = new ArrayList<String>();
                                    var4_4 = this.httpStreamers.iterator();
                                    break block26;
                                }
lbl52:
                                // 2 sources

                                while (this.saveFieldList != null) {
                                    ** GOTO lbl33
                                }
                                break block25;
lbl55:
                                // 1 sources

                                while (true) {
                                    if (this.description.startsWith(Severity.valueOf(512 / 147, "fvwiu"))) {
                                        ** continue;
                                    }
                                    break block24;
                                    break;
                                }
                            }
lbl60:
                            // 2 sources

                            while (true) {
                                if (this.saveFieldList != null) ** break;
                                ** continue;
                                ** continue;
                                break;
                            }
                        }
lbl65:
                        // 2 sources

                        return var2_2;
lbl67:
                        // 1 sources

                        while (this.httpStreamersOptions != null) {
                            ** continue;
lbl69:
                            // 1 sources

                            ** GOTO lbl17
                        }
                        break block26;
lbl71:
                        // 1 sources

                        while (true) {
                            var5_5 = var4_4.next();
                            if (var5_5.trim().length() <= 0) break block26;
                            ** GOTO lbl67
                            break;
                        }
                    }
                    if (this.name.trim().length() != 0) ** GOTO lbl52
                    ** while (true)
                }
                if (var4_4.hasNext()) {
                    ** continue;
                }
                break block30;
            }
            ** while (this.description == null)
lbl84:
            // 1 sources

            ** while (true)
        }
        this.httpStreamers.clear();
        this.httpStreamers.addAll(var3_3);
        Collections.sort(this.httpStreamers);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void deleteFolder(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    ApplicationConfig.deleteFolder(file2);
                    continue;
                }
                file2.delete();
            }
        }
        file.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse copyAction(String string) {
        WMSResponse wMSResponse;
        block10: {
            File file;
            File file2;
            String string2;
            String string3;
            String string4;
            block9: {
                wMSResponse = new WMSResponse();
                try {
                    string4 = URLDecoder.decode(string, Severity.valueOf(102 + -9, "\b\n\u0019my"));
                    string3 = this.getStringVariable(Utils.lastIndexOf("snh{}", 1226 / 245));
                    String string5 = VHostsConfig.getVHostDir(string3) + Severity.valueOf(28 + 4, "/bmmb*") + this.name;
                    string2 = VHostsConfig.getVHostDir(string3) + Severity.valueOf(-47 - 43, ")dggl$") + string4;
                    file2 = new File(string5);
                    file = new File(string2);
                    if (file.exists()) {
                        wMSResponse.message = Utils.lastIndexOf("[klqw|!5+,*e", 43 - -15) + string4 + Utils.lastIndexOf("<|rm% &:d >.;=9", 61 - 1);
                    }
                    break block9;
                }
                catch (IOException iOException) {
                    wMSResponse.message = iOException.getMessage();
                    ConfigBase.log.warn((Object)Severity.valueOf(42 + 112, "_isol?cnrzmka'iyzgeno{y~|"), (Throwable)iOException);
                }
                catch (SecurityException securityException) {
                    wMSResponse.message = securityException.getMessage();
                    ConfigBase.log.warn((Object)Utils.lastIndexOf("T`|fg6twicrrz>~01.*'$2.''", 37 * 29), (Throwable)securityException);
                }
                break block10;
            }
            if (!file2.exists()) {
                wMSResponse.message = Severity.valueOf(425 / 80, "Dvwd`ijxdaa0") + this.name + Utils.lastIndexOf("1v|qf6ywm:~dtmk3", -66 - 13);
            } else {
                ApplicationConfig.copyDirectory(file2, file);
                File file3 = new File(string2.replace(Utils.lastIndexOf(",gjha'", 132 / 42), "/applications/"));
                file3.mkdir();
                wMSResponse.success = true;
                wMSResponse.message = Severity.valueOf(-6 - -9, "Btujnkh~bcc.'") + string4 + Severity.valueOf(45 + 108, "0:xnx\u007fkee\"pqfeb{zl~`aw");
                ApplicationConfig applicationConfig = new ApplicationConfig(this.vhost, string4);
                try {
                    applicationConfig.loadObject();
                    applicationConfig.saveObject();
                    ApplicationsConfig.updateAppplicationInfoCache(string3, string4, applicationConfig);
                }
                catch (ConfigBase.ConfigBaseException configBaseException) {
                    ConfigBase.log.warn((Object)Utils.lastIndexOf("N~b|}0bse}{q7{vjryy>~01.*'$2.''", 37 * 15), (Throwable)configBaseException);
                }
            }
        }
        if (wMSResponse.isSuccess()) {
            ConfigBase.log.info((Object)(Utils.lastIndexOf("\b\u001e\u000f\t~\u001ePH8#Gjv~(Hz{`dmndx}}.5", 57 - 63) + wMSResponse.message));
            return wMSResponse;
        }
        ConfigBase.log.error((Object)(Utils.lastIndexOf("XN_Y.N@X(3Wzfn8Xjkpt}~4(--~e", -54 - 32) + wMSResponse.message));
        return wMSResponse;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse startAction(String string) {
        WMSResponse wMSResponse;
        block4: {
            block3: {
                wMSResponse = new WMSResponse();
                try {
                    Class.forName(Severity.valueOf(29 + 88, "69:v.5,&<p(mr,uljus&@\\Cc~z"));
                    IVHost iVHost = VHostSingleton.getInstance((String)this.vhost);
                    if (iVHost == null) break block3;
                    iVHost.startApplicationInstance(this.appName);
                    wMSResponse.success = true;
                    wMSResponse.message = Severity.valueOf(15 * 9, "Fxyfbolzf\u007f\u007f2;") + this.appName + Utils.lastIndexOf(",&t|hx\u007fii", 181 / 33);
                }
                catch (Exception exception) {
                    ConfigBase.log.error((Object)Utils.lastIndexOf("\u0001\u0011\u0006\u0002w\u0019\t\u0013a|\u000e*>ru\"Btujnkh~bcc", 19 * 33), (Throwable)exception);
                    wMSResponse.message = exception.getMessage();
                }
            }
            wMSResponse.message = Utils.lastIndexOf("\n+%k9n)9?6s5u!8/#;{/8,)%3l", 39 * 15);
            break block4;
            catch (ClassNotFoundException classNotFoundException) {
                ConfigBase.log.error((Object)Utils.lastIndexOf("\u001b\u000f\u0018\u0018m\u000f\u001f\u0019kr\u0000 4$#x\u0018*+04=>4(--", 47 * 7), (Throwable)classNotFoundException);
                wMSResponse.message = Severity.valueOf(16 + 64, "\u00130<t u0>6=z:|*1(: b0!70\":g");
            }
        }
        if (!wMSResponse.isSuccess()) return wMSResponse;
        ConfigBase.log.info((Object)(Utils.lastIndexOf("\u0014\u0002\u001b\u001dj\n\u001c\u0004to\u0003%3! u\u0017'(538=)70.{b", 52 - -18) + wMSResponse.message));
        return wMSResponse;
    }

    public WMSResponse restartAction(String string) {
        return this.shutdownAction(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse shutdownAction(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        try {
            Class.forName(Utils.lastIndexOf("*%&b:!8*0|$9&x!06)/r\u0014\b\u0017orv", 3 * 35));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhost);
            if (iVHost != null) {
                iVHost.shutdownApplication(this.appName);
                wMSResponse.success = true;
                wMSResponse.message = Utils.lastIndexOf("Euvkajk\u007feb`/8", 789 / 191) + this.appName + Utils.lastIndexOf("`j8$8:+?&<", 23 * 31);
            }
            wMSResponse.message = Severity.valueOf(1057 / 194, "Fgi/}*mecj/q1e|cow7k|hmyo0");
        }
        catch (Exception exception) {
            wMSResponse.message = exception.getMessage();
        }
        catch (ClassNotFoundException classNotFoundException) {
            wMSResponse.message = Utils.lastIndexOf("\n+%k9n)9?6s5u!8/#;{/8,)es,", 10 + 95);
        }
        if (!wMSResponse.isSuccess()) {
            ConfigBase.log.error((Object)(Utils.lastIndexOf("YI^Z/QA[)4Gsdlxho<\\no,(!\"0,))ri", 48 - 5) + wMSResponse.message));
            return wMSResponse;
        }
        ConfigBase.log.info((Object)(Severity.valueOf(6 - 24, "\u001c\n\u0003\u0005r\u0012\u0004\u001clw\n<)/=/*\u007fAqromfgsafd1,") + wMSResponse.message));
        return wMSResponse;
    }
}

