/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.application;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.application.AppShortObject;
import com.wowza.wms.rest.application.ApplicationConfig;
import com.wowza.wms.rest.application.drm.DRMConfig;
import com.wowza.wms.rest.application.dvr.DVRConfig;
import com.wowza.wms.rest.application.modules.ModulesConfig;
import com.wowza.wms.rest.application.stream.StreamConfig;
import com.wowza.wms.rest.application.transcoder.TranscoderAppConfig;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Applications")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications", restVerbs="GET,POST", xmlFilename="")
public class ApplicationsConfig
extends ConfigBase {
    @XStreamOmitField
    protected String vhost;
    @JsonProperty(value="applications")
    @XStreamImplicit(itemFieldName="Application")
    private List<AppShortObject> a = new ArrayList<AppShortObject>();
    @XStreamOmitField
    protected static HashMap<String, HashMap<String, ApplicationConfig>> applicationInfoCache = new HashMap();

    public ApplicationsConfig() {
    }

    public ApplicationsConfig(String string) {
        this.vhost = string;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(55 * 63, "\u007fbd\u007fy"));
        this.vhost = this.getStringVariable(Severity.valueOf(12 - 15, "+60su"));
    }

    public List<AppShortObject> getApplicationsList() {
        return this.a;
    }

    public void setApplicationsList2(List<AppShortObject> list) {
        this.a = list;
    }

    @Override
    public String getFilename() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        boolean bl = false;
        if (this.vhost == null) {
            this.vhost = this.getStringVariable(Utils.lastIndexOf("uljus", 561 / 180));
        }
        ApplicationsConfig.initApplicationInfoCache(this.vhost);
        this.a.clear();
        HashMap<String, ApplicationConfig> hashMap = applicationInfoCache.get(this.vhost);
        if (hashMap == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.a.add(new AppShortObject(string, applicationInfoCache.get(this.vhost).get(string), this.restURI + "/" + string));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        Representation representation2 = applicationConfig.post(representation, this.getRequest());
        this.setStatus(applicationConfig.getStatus());
        if (applicationConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(applicationConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static ApplicationsConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (ApplicationsConfig)ApplicationsConfig.getObjectFromREST(ApplicationsConfig.getUrl(Utils.lastIndexOf("c~xkm", -27 - 48), string, ApplicationsConfig.class), ApplicationsConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initApplicationInfoCache(String string) {
        try {
            if (applicationInfoCache.containsKey(string)) return;
            Class.forName(Severity.valueOf(440 / 137, "`kh(pg~pj\"zc|>gz|ga8^NQuhh"));
            IVHost iVHost = VHostSingleton.getInstance((String)string);
            if (iVHost == null) return;
            applicationInfoCache.put(string, new HashMap());
            List list = iVHost.getApplicationFolderNames();
            Collections.sort(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                ApplicationConfig applicationConfig = new ApplicationConfig(string, string2);
                if (!applicationConfig.loadObject()) continue;
                ApplicationsConfig.updateAppplicationInfoCache(string, string2, applicationConfig);
            }
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateAppplicationInfoCache(String string, String string2, ApplicationConfig applicationConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) {
            return;
        }
        applicationInfoCache.get(string).put(string2, applicationConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, DRMConfig dRMConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setDrmConfig(dRMConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, DVRConfig dVRConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setDvrConfig(dVRConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, TranscoderAppConfig transcoderAppConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setTranscoderConfig(transcoderAppConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, ModulesConfig modulesConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setModules(modulesConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, StreamConfig streamConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setStreamConfig(streamConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteAppplicationInfoCache(String string, String string2) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) {
            return;
        }
        applicationInfoCache.get(string).remove(string2);
    }
}

