/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.application.instance;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.http.streammanager.HTTPStreamManager;
import com.wowza.wms.http.streammanager.NextLoadMessages;
import com.wowza.wms.livestreamrecord.manager.StreamRecorder;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamId;
import com.wowza.wms.mediacaster.MediaCasterStreamManager;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import com.wowza.wms.rest.application.instance.InstanceUtils;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.MediaCasterUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Stream")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/instances/{instance}/streams/{stream}", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class IncomingStreamConfig
extends ApplicationConfigBase
implements Comparable<IncomingStreamConfig> {
    @JsonProperty(value="applicationInstance")
    @XStreamAlias(value="ApplicationInstance")
    protected String instanceName = null;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String streamName = null;
    @JsonProperty(value="sourceIp")
    @XStreamAlias(value="SourceIp")
    protected String sourceIp;
    @JsonProperty(value="isRecordingSet")
    @XStreamAlias(value="IsRecordingSet")
    protected boolean recordingSet;
    @JsonProperty(value="isStreamManagerStream")
    @XStreamAlias(value="IsStreamManagerStream")
    protected boolean managedStream;
    @JsonProperty(value="isPublishedToVOD")
    @XStreamAlias(value="IsPublishedToVOD")
    protected boolean publishedToVOD;
    @JsonProperty(value="isConnected")
    @XStreamAlias(value="IsConnected")
    protected boolean connected;

    public IncomingStreamConfig() {
        this.sourceIp = Utils.lastIndexOf("7-/+)0&", 95 + 3);
        this.recordingSet = false;
        this.managedStream = false;
        this.publishedToVOD = false;
        this.connected = false;
        this.addFieldForKeyMap(Utils.lastIndexOf("?9+-;5?8", 30 + 88), "instanceName");
        this.addFieldForKeyMap(Utils.lastIndexOf("ionx\u007fr", 78 + 108), "streamName");
    }

    public IncomingStreamConfig(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.sourceIp = Utils.lastIndexOf("kqkomtj", -12 - -42);
        this.recordingSet = false;
        this.managedStream = false;
        this.publishedToVOD = false;
        this.connected = false;
        this.instanceName = string3;
        this.streamName = string4;
        this.addFieldForKeyMap(Severity.valueOf(369 / 100, "jjvrffjo"), "instanceName");
        this.addToStringKeyMap(Severity.valueOf(14 - 44, "+-71')+,"), string3);
        this.addFieldForKeyMap(Severity.valueOf(-21 - 60, "|dcwry"), "streamName");
        this.addToStringKeyMap(Severity.valueOf(-20 - -8, "'!$294"), string4);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(960 / 251, "jjvrffjo"));
        this.addToStringKeyMapFromRequest(Utils.lastIndexOf("mkrdcn", -52 - 46));
        this.setPathMap();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String string) {
        this.sourceIp = string;
    }

    public boolean isRecordingSet() {
        return this.recordingSet;
    }

    public boolean isManagedStream() {
        return this.managedStream;
    }

    public boolean isPublishedToVOD() {
        return this.publishedToVOD;
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        boolean bl = false;
        this.vhost = this.getStringVariable(Utils.lastIndexOf("xg\u007fbf", 13 + 1));
        this.appName = this.getStringVariable(Utils.lastIndexOf("+;<\u0003/\"5", -28 - 26));
        this.instanceName = this.getStringVariable(Severity.valueOf(43 - 28, "f~bfrzvs"));
        this.streamName = this.getStringVariable(Severity.valueOf(34 - 37, ".*-e`o"));
        MediaCasterStreamId mediaCasterStreamId = MediaCasterItem.parseIdString((String)this.streamName);
        if (mediaCasterStreamId.getLiveStreamPacketizer() != null) return bl;
        if (mediaCasterStreamId.getLiveStreamRepeater() == null) {
            Client client;
            IMediaStream iMediaStream;
            Map map;
            ArrayList arrayList;
            MediaCasterStreamMap mediaCasterStreamMap;
            MediaCasterStreamManager mediaCasterStreamManager;
            ArrayList arrayList2;
            String string;
            IApplicationInstance iApplicationInstance;
            IVHost iVHost;
            block12: {
                try {
                    Class.forName(Utils.lastIndexOf("bmn*riprh$|a~ yx~ag:\\@_wjn", 126 + -93));
                    iVHost = VHostSingleton.getInstance((String)this.vhost);
                    if (iVHost == null) return bl;
                    IApplication iApplication = iVHost.getApplication(this.appName);
                    if (iApplication == null) return bl;
                    iApplicationInstance = iApplication.getAppInstance(this.instanceName);
                    if (iApplicationInstance == null) return bl;
                    string = iApplicationInstance.getStreamType();
                    if (!StreamRecorder.isLiveRepeaterEdge((String)string, (IApplicationInstance)iApplicationInstance)) break block12;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logException(Severity.valueOf(-57 - 48, "^vzuvusyLtsgbiFiin`m%`bok_sxvwa"), classNotFoundException);
                    return bl;
                }
                this.streamName = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, null, (String)this.streamName);
                this.sourceIp = this.a(MediaCasterUtils.handleStreamAliasFile((IApplicationInstance)iApplicationInstance, (String)this.streamName));
            }
            if ((arrayList2 = (ArrayList)(mediaCasterStreamManager = (mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams()).getStreamManager()).getStreamList()).indexOf(this.streamName) > -1) {
                this.managedStream = true;
                bl = true;
            }
            if ((arrayList = (ArrayList)iApplicationInstance.getPublishStreamNames()).contains(this.streamName)) {
                bl = true;
                this.connected = true;
            }
            if ((map = iVHost.getLiveStreamRecordManager().getRecordersMap(iApplicationInstance)).containsKey(this.streamName)) {
                this.recordingSet = true;
                bl = true;
            }
            if (!bl) return bl;
            StreamItem streamItem = iApplicationInstance.getVHost().getStreamTypes().getStreamDef(string);
            boolean bl2 = false;
            if (streamItem != null && !streamItem.getProperties().getPropertyBoolean(Severity.valueOf(93 + -23, "/4\u0004 <."), false)) {
                this.publishedToVOD = true;
            }
            if (!this.managedStream && !string.contains(Utils.lastIndexOf("svs)ioqm", -30 - -31))) {
                iMediaStream = InstanceUtils.getIncomingStreamByName(iApplicationInstance, this.streamName);
                if (iMediaStream == null) return bl;
                client = (Client)iMediaStream.getClient();
                if (iMediaStream.isTranscodeResult()) {
                    this.sourceIp = Utils.lastIndexOf("b`sp~3<Advvjytxxl6", 24 - 10);
                    return bl;
                }
            } else {
                this.sourceIp = MediaCasterUtils.handleStreamAliasFile((IApplicationInstance)iApplicationInstance, (String)this.streamName);
                return bl;
            }
            if (client != null) {
                String string2 = client.getIoSession().getRemoteAddress().toString();
                String string3 = InstanceUtils.getConnectPrefixFromProtocol(iMediaStream.getClient().getProtocol());
                this.sourceIp = string3 + Utils.lastIndexOf(">*", 945 / 233) + string2;
                return bl;
            }
            RTPStream rTPStream = iMediaStream.getRTPStream();
            RTPSession rTPSession = null;
            if (rTPStream != null) {
                rTPSession = rTPStream.getSession();
            }
            if (rTPSession == null) return bl;
            String string4 = rTPSession.getUri();
            if (string4 == null) return bl;
            int n = string4.indexOf(Severity.valueOf(63 - -1, "on"));
            String string5 = string4.substring(0, n + 2);
            this.sourceIp = string5 + rTPSession.getIp();
            return bl;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse resetStreamAction(String string) {
        WMSResponse wMSResponse;
        block5: {
            NextLoadMessages nextLoadMessages;
            block6: {
                wMSResponse = new WMSResponse();
                wMSResponse.message = Utils.lastIndexOf("_|p8t!djja&f(~e|vl.|ucdvf;", 55 + -27);
                wMSResponse.success = true;
                Class.forName(Utils.lastIndexOf("`kh(pg~pj\"zc|>gz|ga8^NQuhh", 491 / 132));
                IVHost iVHost = VHostSingleton.getInstance((String)this.vhost);
                if (iVHost == null) break block5;
                nextLoadMessages = HTTPStreamManager.resetStream((IVHost)iVHost, (String)this.appName, (String)this.instanceName, (String)this.streamName);
                if (nextLoadMessages.getErrorMsg() == null) break block6;
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                IncomingStreamConfig.logError(Utils.lastIndexOf("\u001b=7:;>6>\t/.8?2Cnlemb(umzo\u007f_y|jq|Sp`|yy\"9", -33 - -19) + nextLoadMessages.getErrorMsg());
                return null;
            }
            try {
                wMSResponse.message = nextLoadMessages.getInfoMsg();
                IncomingStreamConfig.logInfo(Utils.lastIndexOf("Oikfgbbj]{bts~Wzxqq~4iyn{kSupfehGd|`ee6-", 614 / 88) + nextLoadMessages.getInfoMsg());
            }
            catch (Exception exception) {
                wMSResponse.message = exception.getMessage();
                this.logException(Severity.valueOf(-60 - -3, "\u000e&*%&%#)\u001c$#729\u001699>0=u.8-:4\u001261!$+\u0006+=#$\""), exception);
            }
            catch (ClassNotFoundException classNotFoundException) {
                wMSResponse.message = Severity.valueOf(133 / 32, "Gdh |)lbbi.n0f}dnt6d}kl~n3");
                this.logException(Severity.valueOf(-5 - 15, "\u0005#- =8<4\u0007!$294\u001942;78.sgpaqUszlkfMnzf\u007f\u007f"), classNotFoundException);
            }
        }
        if (!wMSResponse.isSuccess()) {
            IncomingStreamConfig.logError(Severity.valueOf(-17 - -51, "KmgjknfnY\u007f~hobS~|u}r8e}j\u007foOilz!,\u0003 0,))ri") + wMSResponse.message);
            return wMSResponse;
        }
        IncomingStreamConfig.logInfo(Utils.lastIndexOf("Oikfgbbj]{bts~Wzxqq~4iyn{kSupfehGd|`ee6-", 341 / 50) + wMSResponse.message);
        return wMSResponse;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse disconnectStreamAction(String var1_1) {
        block6: {
            var2_2 = new WMSResponse();
            var2_2.message = Utils.lastIndexOf("Z~yilc/8", 60 - 51) + this.streamName + Severity.valueOf(61 + -16, "$.kybq|z{stl|~");
            var2_2.success = true;
            try {
                Class.forName(Severity.valueOf(57 * 33, ":56r*1(: l4)6h1 &9?b\u0004\u0018\u0007?\"&"));
                var3_4 = VHostSingleton.getInstance((String)this.vhost);
                if (var3_4 == null) ** GOTO lbl25
                var4_6 = HTTPStreamManager.deleteStream((IVHost)var3_4, (String)this.appName, (String)this.instanceName, (String)this.streamName);
                if (var4_6.getErrorMsg() != null) {
                    this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                    IncomingStreamConfig.logError(Severity.valueOf(540 / 154, "JjfijagmXx\u007fkn}R}}r|q9|pixsspzcuQwv`gjIj~bcc4/") + var4_6.getErrorMsg());
                    return null;
                }
                var2_2.message = var4_6.getInfoMsg();
                IncomingStreamConfig.logInfo(Severity.valueOf(17 + -12, "WCT\\)K[E7.Kybq|z{stl9Ionx\u007fr:!") + var4_6.getInfoMsg());
                ** GOTO lbl27
            }
            catch (ClassNotFoundException var3_3) {
                block5: {
                    var2_2.message = Utils.lastIndexOf("Eff.~+jd`k0p2d{blv8j\u007fijxl1", 1268 / 184);
                    this.logException(Utils.lastIndexOf("Mkehe`dl_y|jq|Q|zs\u007fp6}sh\u007frpqebvPpwcfeHi\u007feb`", 339 / 73), var3_3);
                    break block5;
                    catch (Exception var3_5) {
                        var2_2.message = var3_5.getMessage();
                        this.logException(Utils.lastIndexOf("Mkehe`dl_y|jq|Q|zs\u007fp6}sh\u007frpqebvPpwcfeHi\u007feb`", 74 + -70), var3_5);
                        break block5;
                    }
lbl25:
                    // 1 sources

                    var2_2.message = Utils.lastIndexOf("Khd,x-hf~u2r4by`bx:hyohzr/", -41 - -49);
                    IncomingStreamConfig.logError(Severity.valueOf(-28 - 58, "Ceobcf~vAgfpwz[vt}uz0{)2!,*+#$<\u001a>9),#\u000e3%;<:ov") + var2_2.message);
                }
                if (var2_2.isSuccess()) break block6;
            }
            IncomingStreamConfig.logError(Utils.lastIndexOf("D`l\u007f|{}sFbe}xwXssxvg/fjwfiifli\u007f_y|jq|Sp`|yy\"9", 39 * 43) + var2_2.message);
            return var2_2;
        }
        IncomingStreamConfig.logInfo(Utils.lastIndexOf("JjfijagmXx\u007fkn}R}}r|q9|pixsspz#5\u001176 '*\t*>\"##to", 61 + -26) + var2_2.message);
        return var2_2;
    }

    @Override
    public int compareTo(IncomingStreamConfig incomingStreamConfig) {
        return this.streamName.compareToIgnoreCase(incomingStreamConfig.streamName);
    }

    public static IncomingStreamConfig getObjectFromREST(String string, String string2, String string3, String string4, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.lastIndexOf("?\"$?9", 62 - -43), string);
        hashMap.put(Severity.valueOf(45 + 49, "?/0\u000f#.!"), string2);
        hashMap.put(Severity.valueOf(1276 / 240, "lht|hdhi"), string3);
        hashMap.put(Severity.valueOf(-31 - -59, "oilzal"), string4);
        return (IncomingStreamConfig)IncomingStreamConfig.getObjectFromREST(IncomingStreamConfig.getUrl(hashMap, IncomingStreamConfig.class), IncomingStreamConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String a(String string) {
        String string2 = Severity.valueOf(21 * 37, "|d`bbya");
        int n = string.indexOf(Utils.lastIndexOf("*)", 1113 / 220));
        if (n <= -1) return string2;
        int n2 = string.indexOf(47, n + 2);
        if (n2 <= -1) return string2;
        return string.substring(0, n2);
    }
}

