/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.application.instance;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import com.wowza.wms.rest.application.instance.IncomingStreamConfig;
import com.wowza.wms.rest.application.instance.OutgoingStreamConfig;
import com.wowza.wms.rest.application.instance.StreamGroupConfig;
import com.wowza.wms.rest.application.livestreamrecord.RecorderConfig;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Instance")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/instances/{instance}", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class InstanceConfig
extends ApplicationConfigBase
implements Comparable<InstanceConfig> {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String instanceName = null;
    @JsonProperty(value="incomingStreams")
    @XStreamAlias(value="IncomingStreams")
    protected List<IncomingStreamConfig> incomingStreams = null;
    @JsonProperty(value="outgoingStreams")
    @XStreamAlias(value="OutgoingStreams")
    protected List<OutgoingStreamConfig> outgoingStreams = null;
    @JsonProperty(value="recorders")
    @XStreamAlias(value="Recorders")
    protected List<RecorderConfig> recorders = null;
    @JsonProperty(value="streamGroups")
    @XStreamAlias(value="StreamGroups")
    protected List<StreamGroupConfig> streamGroups = null;

    public InstanceConfig() {
        this.addFieldForKeyMap(Severity.valueOf(-51 - -36, "8<  484="), "instanceName");
    }

    public InstanceConfig(String string, String string2, String string3) {
        super(string, string2);
        this.instanceName = string3;
        this.addFieldForKeyMap(Utils.lastIndexOf("<8$,8489", 60 - -25), "instanceName");
        this.addToStringKeyMap(Severity.valueOf(29 + 72, ",(4<($()"), string3);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.lastIndexOf("lht|hdhi", 552 / 97));
        this.setPathMap();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public List<IncomingStreamConfig> getIncomingStreams() {
        return this.incomingStreams;
    }

    public List<OutgoingStreamConfig> getOutgoingStreams() {
        return this.outgoingStreams;
    }

    public List<RecorderConfig> getRecorders() {
        return this.recorders;
    }

    public List<StreamGroupConfig> getStreamGroups() {
        return this.streamGroups;
    }

    /*
     * Enabled aggressive block sorting
     */
    public IncomingStreamConfig getIncomingStreamByName(String string) {
        IncomingStreamConfig incomingStreamConfig;
        IncomingStreamConfig incomingStreamConfig2 = null;
        Iterator<IncomingStreamConfig> iterator = this.incomingStreams.iterator();
        do {
            if (!iterator.hasNext()) return incomingStreamConfig2;
        } while (!(incomingStreamConfig = iterator.next()).getStreamName().equals(string));
        return incomingStreamConfig;
    }

    /*
     * Enabled aggressive block sorting
     */
    public OutgoingStreamConfig getInstanceByName(String string) {
        OutgoingStreamConfig outgoingStreamConfig;
        OutgoingStreamConfig outgoingStreamConfig2 = null;
        Iterator<OutgoingStreamConfig> iterator = this.outgoingStreams.iterator();
        do {
            if (!iterator.hasNext()) return outgoingStreamConfig2;
        } while (!(outgoingStreamConfig = iterator.next()).getStreamName().equals(string));
        return outgoingStreamConfig;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StreamGroupConfig getStreamGroupByName(String string) {
        StreamGroupConfig streamGroupConfig;
        StreamGroupConfig streamGroupConfig2 = null;
        Iterator<StreamGroupConfig> iterator = this.streamGroups.iterator();
        do {
            if (!iterator.hasNext()) return streamGroupConfig2;
            streamGroupConfig = iterator.next();
        } while (!streamGroupConfig.groupName.equals(string));
        return streamGroupConfig;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        block8: {
            block9: {
                var1_1 = false;
                this.vhost = this.getStringVariable(Utils.lastIndexOf("uljus", 561 / 171));
                this.appName = this.getStringVariable(Utils.lastIndexOf(",>?\u001e0?6", 59 * 23));
                this.instanceName = this.getStringVariable(Utils.lastIndexOf("oi{}keoh", 1485 / 231));
                this.incomingStreams = new ArrayList<IncomingStreamConfig>();
                this.outgoingStreams = new ArrayList<OutgoingStreamConfig>();
                this.streamGroups = new ArrayList<StreamGroupConfig>();
                this.recorders = new ArrayList<RecorderConfig>();
                try {
                    Class.forName(Utils.lastIndexOf("twt4lsjd~.vop*snh{}$BZEa|d", -64 - 41));
                    var2_3 = VHostSingleton.getInstance((String)this.vhost);
                    if (var2_3 == null) return var1_1;
                    var3_4 = var2_3.getApplication(this.appName);
                    if (var3_4 == null) return var1_1;
                    var4_5 = var3_4.getAppInstance(this.instanceName);
                    if (var4_5 == null) return var1_1;
                    var5_6 = var4_5.getMediaCasterStreams();
                    var6_7 = var5_6.getStreamManager();
                    var7_8 = new TreeSet<E>(var6_7.getStreamList());
                    var8_9 = var7_8.iterator();
                }
                catch (ClassNotFoundException var2_2) {
                    this.logException(Severity.valueOf(51 * 15, "\u00140,t`l`aFiin`m%`bok_sxvwa"), var2_2);
                    return var1_1;
                }
                while (var8_9.hasNext()) {
                    var9_10 = (String)var8_9.next();
                    var10_11 = new IncomingStreamConfig(this.vhost, this.appName, this.instanceName, (String)var9_10);
                    if (!var10_11.loadObject()) continue;
                    this.incomingStreams.add((IncomingStreamConfig)var10_11);
                }
                var8_9 = var4_5.getStreams();
                if (var8_9 == null) break block8;
                var9_10 = var8_9.getStreams().iterator();
                break block9;
lbl37:
                // 2 sources

                while (var12_13.hasNext()) {
                    var13_14 = var12_13.next();
                    var14_15 = (String)var13_14.getKey();
                    var15_16 = new RecorderConfig(this.vhost, this.appName, this.instanceName, var14_15);
                    var15_16.loadObject(var13_14.getValue());
                    this.recorders.add(var15_16);
                }
                break block8;
            }
            while (var9_10.hasNext()) {
                var10_11 = (IMediaStream)var9_10.next();
                if (var10_11.isPlay()) {
                    var11_12 = new OutgoingStreamConfig(this.vhost, this.appName, this.instanceName, var10_11.getName());
                    var11_12.loadObject();
                    this.outgoingStreams.add((OutgoingStreamConfig)var11_12);
                    continue;
                }
                if (var7_8.contains(var10_11.getName()) || !(var11_12 = new IncomingStreamConfig(this.vhost, this.appName, this.instanceName, var10_11.getName())).loadObject()) continue;
                this.incomingStreams.add((IncomingStreamConfig)var11_12);
            }
            var9_10 = var8_9.getNameGroups();
            if (var9_10 != null) {
                var10_11 = var9_10.iterator();
                while (var10_11.hasNext()) {
                    var11_12 = (MediaStreamMapGroup)var10_11.next();
                    var12_13 = new StreamGroupConfig(this.vhost, this.appName, this.instanceName, var11_12.getName());
                    var12_13.loadObject(var11_12);
                    this.streamGroups.add((StreamGroupConfig)var12_13);
                }
            }
            var10_11 = var2_3.getLiveStreamRecordManager().getRecordersMap(var4_5);
            var11_12 = var8_9.getPublishStreamNames();
            if (var10_11 == null) break block8;
            var12_13 = var10_11.entrySet().iterator();
            ** GOTO lbl37
        }
        Collections.sort(this.incomingStreams);
        Collections.sort(this.outgoingStreams);
        Collections.sort(this.streamGroups);
        Collections.sort(this.recorders);
        return true;
    }

    @Override
    public int compareTo(InstanceConfig instanceConfig) {
        if (!this.instanceName.equals(Severity.valueOf(-23 - 46, "Dxxxv.26\u001c"))) {
            return this.instanceName.compareToIgnoreCase(instanceConfig.instanceName);
        }
        return -1;
    }

    public static InstanceConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.lastIndexOf("!06)/", 7 * 17), string);
        hashMap.put(Utils.lastIndexOf("~01\f\") ", 55 * 57), string2);
        return (InstanceConfig)InstanceConfig.getObjectFromREST(InstanceConfig.getUrl(hashMap, InstanceConfig.class), InstanceConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse startAction(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        try {
            Class.forName(Utils.lastIndexOf("941s)0w{c-shu)~aexx#GYX~ag", 45 - 51));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhost);
            if (iVHost != null) {
                iVHost.startApplicationInstance(this.appName, this.instanceName);
                wMSResponse.success = true;
                wMSResponse.message = Utils.lastIndexOf("Dvwd`ijxdaa0X|``txt}1", 63 * 27) + this.appName + "/" + this.instanceName + Severity.valueOf(25 * 29, "|v$,8(/99");
            }
            wMSResponse.message = Utils.lastIndexOf("@ek!s(oceh-o/g~eiu5erjo\u007fi2", 320 / 105);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ConfigBase.log.error((Object)Severity.valueOf(41 * 39, "M\u0005\u0012\u0016c\u0005\u0015\u000f}h\u001a>*>9n\u000e !>:74\">77z\u00122.*>.\"'"), (Throwable)classNotFoundException);
            wMSResponse.message = Severity.valueOf(57 + 106, "@ek!s(oceh-o/g~eiu5erjo\u007fi2");
        }
        catch (Exception exception) {
            ConfigBase.log.error((Object)Severity.valueOf(-8 - 1, "\u0005\u001d\n\u000e{\u001d\r\u0017e Rvbvq&Fxyfbolzf\u007f\u007f2Zzfbvvz\u007f"), (Throwable)exception);
            wMSResponse.message = exception.getMessage();
        }
        if (!wMSResponse.isSuccess()) return wMSResponse;
        ConfigBase.log.info((Object)(Severity.valueOf(29 * 17, "\u001f\u000b\u001c\u0004q\u0013\u0003\u001dov\u0004,8(/|\u001c./lhabplii(@dxxl`lu+2") + wMSResponse.message));
        return wMSResponse;
    }
}

