/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.application.instance;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.Iterator;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Stream")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/instances/{instance}/streams/{stream}", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class OutgoingStreamConfig
extends ApplicationConfigBase
implements Comparable<OutgoingStreamConfig> {
    @XStreamOmitField
    protected String instanceName;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String streamName;
    @JsonProperty(value="someProp")
    @XStreamAlias(value="SomeProp")
    protected String someProp;
    @JsonProperty(value="someProp2")
    @XStreamAlias(value="SomeProp2")
    protected String someProp2;

    public OutgoingStreamConfig() {
        this.addFieldForKeyMap(Severity.valueOf(29 * 7, "\"\">:.>27"), "instanceName");
        this.addFieldForKeyMap(Severity.valueOf(29 * 49, "~z}up\u007f"), "streamName");
    }

    public OutgoingStreamConfig(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.instanceName = string3;
        this.streamName = string4;
        this.addFieldForKeyMap(Severity.valueOf(47 * 57, ">6*.:2>;"), "instanceName");
        this.addToStringKeyMap(Severity.valueOf(3 * 13, "nfz~jbnk"), string3);
        this.addFieldForKeyMap(Utils.lastIndexOf("*.)9<3", 126 + 91), "streamName");
        this.addToStringKeyMap(Utils.lastIndexOf("vrumhg", 516 / 99), string4);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(21 * 43, "nfz~jbnk"));
        this.setPathMap();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        Iterator iterator;
        this.vhost = this.getStringVariable(Utils.lastIndexOf("q`fy\u007f", 3 * 45));
        this.appName = this.getStringVariable(Severity.valueOf(184 / 58, "btuHfel"));
        this.instanceName = this.getStringVariable(Severity.valueOf(737 / 204, "jjvrffjo"));
        this.streamName = this.getStringVariable(Severity.valueOf(59 + 113, "\u007fy|jq|"));
        ConfigBase.log.info((Object)(Utils.lastIndexOf("Uszlkf,D`i\u007f1t|f5@\u007fwjn!", 487 / 72) + this.vhost + Utils.lastIndexOf("3Uef{qz{ourp%", -10 - -29) + this.appName + Severity.valueOf(-31 - -58, ";Usmkaoaf>") + this.instanceName + Utils.lastIndexOf("$Vrumhg1", 136 / 32) + this.streamName));
        this.someProp = Utils.lastIndexOf("&9:=y,:0(;", 35 * 39);
        this.someProp2 = Utils.lastIndexOf("hsp{?6 .6!w", 57 * 19);
        try {
            Class.forName(Utils.lastIndexOf("`kh(pg~pj\"zc|>gz|ga8^NQuhh", 360 / 115));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhost);
            if (iVHost == null) return true;
            IApplication iApplication = iVHost.getApplication(this.appName);
            if (iApplication == null) return true;
            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(this.instanceName);
            if (iApplicationInstance == null) return true;
            MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
            if (mediaStreamMap == null) return true;
            iterator = mediaStreamMap.getStreams().iterator();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        while (iterator.hasNext()) {
            IMediaStream iMediaStream = (IMediaStream)iterator.next();
            if (!iMediaStream.getName().equals(this.streamName) || iMediaStream.getHTTPStreamerSession() == null) continue;
            if (iMediaStream.getClient() != null) {
                this.someProp = iMediaStream.getClient().getIp();
            }
            this.someProp2 = iMediaStream.getUniqueStreamIdStr();
        }
        return true;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public int compareTo(OutgoingStreamConfig outgoingStreamConfig) {
        return this.streamName.compareToIgnoreCase(outgoingStreamConfig.streamName);
    }
}

