/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.application.modules;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import com.wowza.wms.rest.application.ApplicationsConfig;
import com.wowza.wms.rest.application.modules.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Modules")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/modules", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class ModulesConfig
extends ApplicationConfigBase {
    @JsonProperty(value="moduleList")
    @XStreamImplicit(itemFieldName="Module")
    @WMSXMLList(xpath="/Root/Application/Modules", keyxpath="/Module/Name", keyName="modulename")
    protected List<Module> modulesList = new ArrayList<Module>();

    public ModulesConfig() {
    }

    public ModulesConfig(String string, String string2) {
        super(string, string2);
    }

    public List<Module> getModulesList() {
        return this.modulesList;
    }

    public void setModulesList(List<Module> list) {
        this.modulesList = list;
    }

    public boolean contains(Module module) {
        return this.modulesList.contains(module);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean contains(String string) {
        boolean bl = false;
        if (this.modulesList != null) {
            for (Module module : this.modulesList) {
                if (module.className == null) continue;
                bl |= module.className.equalsIgnoreCase(string);
            }
        }
        return bl;
    }

    public boolean remove(Module module) {
        return this.modulesList.remove(module);
    }

    public boolean add(Module module) {
        if (!this.modulesList.contains(module)) {
            return this.modulesList.add(module);
        }
        return true;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        boolean bl = super.loadXMLNode(node, string);
        if (!bl) return bl;
        int n = 0;
        Iterator<Module> iterator = this.modulesList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                Collections.sort(this.modulesList);
                return bl;
            }
            Module module = iterator.next();
            module.setOrder(n++);
        }
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        Collections.sort(this.modulesList);
        this.vhost = this.getStringVariable(Severity.valueOf(711 / 131, "snh{}"));
        this.appName = this.getStringVariable(Severity.valueOf(31 * 13, "rdeXvu|"));
        ApplicationsConfig.updateAppplicationInfoCache(this.vhost, this.appName, this);
        return super.saveObject();
    }

    public static ModulesConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.lastIndexOf("5,*53", 51 * 49), string);
        hashMap.put(Utils.lastIndexOf("j|}@n}t", 38 - -5), string2);
        return (ModulesConfig)ModulesConfig.getObjectFromREST(ModulesConfig.getUrl(hashMap, ModulesConfig.class), ModulesConfig.class, wMSClientSecurity);
    }
}

