/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.application.security;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import java.util.HashMap;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Security")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/security", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class SecurityConfig
extends ApplicationConfigBase {
    @JsonProperty(value="clientStreamWriteAccess")
    @XStreamAlias(value="ClientStreamWriteAccess")
    @WMSXMLVariable(xpath="/Root/Application/Client/Access/StreamWriteAccess/text()")
    protected String clientStreamWriteAccess;
    @JsonProperty(value="publishRequirePassword")
    @XStreamAlias(value="PublishRequirePassword")
    @WMSXMLProperty(root="/Root/Application", name="securityPublishRequirePassword", defaultValue="false")
    protected boolean publishRequirePassword;
    @JsonProperty(value="publishPasswordFile")
    @XStreamAlias(value="PublishPasswordFile")
    @WMSXMLProperty(root="/Root/Application", name="securityPublishPasswordFile", defaultValue="")
    protected String publishPasswordFile;
    @JsonProperty(value="publishRTMPSecureURL")
    @XStreamAlias(value="PublishRTMPSecureURL")
    @WMSXMLProperty(root="/Root/Application", name="securityPublishRTMPSecureURL", defaultValue="")
    protected String publishRTMPSecureURL;
    @JsonProperty(value="publishIPBlackList")
    @XStreamAlias(value="PublishIPBlackList")
    @WMSXMLProperty(root="/Root/Application", name="securityPublishIPBlackList", defaultValue="")
    protected String publishIPBlackList;
    @JsonProperty(value="publishIPWhiteList")
    @XStreamAlias(value="PublishIPWhiteList")
    @WMSXMLProperty(root="/Root/Application", name="securityPublishIPWhiteList", defaultValue="")
    protected String publishIPWhiteList;
    @JsonProperty(value="publishBlockDuplicateStreamNames")
    @XStreamAlias(value="PublishBlockDuplicateStreamNames")
    @WMSXMLProperty(root="/Root/Application", name="securityPublishBlockDuplicateStreamNames", defaultValue="false")
    protected boolean publishBlockDuplicateStreamNames;
    @JsonProperty(value="publishValidEncoders")
    @XStreamAlias(value="PublishValidEncoders")
    @WMSXMLProperty(root="/Root/Application", name="securityPublishValidEncoders", defaultValue="")
    protected String publishValidEncoders;
    @JsonProperty(value="publishAuthenticationMethod")
    @XStreamAlias(value="PublishAuthenticationMethod")
    @WMSXMLVariable(xpath="/Root/Application/RTP/Authentication/PublishMethod/text()")
    protected String publishAuthenticationMethod;
    @JsonProperty(value="playMaximumConnections")
    @XStreamAlias(value="PlayMaximumConnections")
    @WMSXMLProperty(root="/Root/Application", name="securityPlayMaximumConnections", defaultValue="0")
    protected int playMaximumConnections;
    @JsonProperty(value="playRequireSecureConnection")
    @XStreamAlias(value="PlayRequireSecureConnection")
    @WMSXMLProperty(root="/Root/Application", name="securityPlayRequireSecureConnection", defaultValue="false")
    protected boolean playRequireSecureConnection;
    @JsonProperty(value="secureTokenSharedSecret")
    @XStreamAlias(value="SecureTokenSharedSecret")
    @WMSXMLProperty(root="/Root/Application", name="securitySecureTokenSharedSecret", defaultValue="")
    protected String secureTokenSharedSecret;
    @JsonProperty(value="secureTokenOriginSharedSecret")
    @XStreamAlias(value="SecureTokenOriginSharedSecret")
    @WMSXMLProperty(root="/Root/Application", name="secureTokenOriginSharedSecret", defaultValue="")
    protected String secureTokenOriginSharedSecret;
    @JsonProperty(value="playIPBlackList")
    @XStreamAlias(value="PlayIPBlackList")
    @WMSXMLProperty(root="/Root/Application", name="securityPlayIPBlackList", defaultValue="")
    protected String playIPBlackList;
    @JsonProperty(value="playIPWhiteList")
    @XStreamAlias(value="PlayIPWhiteList")
    @WMSXMLProperty(root="/Root/Application", name="securityPlayIPWhiteList", defaultValue="")
    protected String playIPWhiteList;
    @JsonProperty(value="playAuthenticationMethod")
    @XStreamAlias(value="PlayAuthenticationMethod")
    @WMSXMLVariable(xpath="/Root/Application/RTP/Authentication/PlayMethod/text()")
    protected String playAuthenticationMethod;

    public SecurityConfig() {
    }

    public SecurityConfig(String string, String string2) {
        super(string, string2);
    }

    public boolean isPublishRequirePassword() {
        return this.publishRequirePassword;
    }

    public void setPublishRequirePassword(boolean bl) {
        this.publishRequirePassword = bl;
    }

    public String getPublishPasswordFile() {
        return this.publishPasswordFile;
    }

    public void setPublishPasswordFile(String string) {
        this.publishPasswordFile = string;
    }

    public String getPublishRTMPSecureURL() {
        return this.publishRTMPSecureURL;
    }

    public void setPublishRTMPSecureURL(String string) {
        this.publishRTMPSecureURL = string;
    }

    public String getPublishIPWhiteList() {
        return this.publishIPWhiteList;
    }

    public void setPublishIPWhiteList(String string) {
        this.publishIPWhiteList = string;
    }

    public String getPublishIPBlackList() {
        return this.publishIPBlackList;
    }

    public void setPublishIPBlackList(String string) {
        this.publishIPBlackList = string;
    }

    public boolean isPublishBlockDuplicateStreamNames() {
        return this.publishBlockDuplicateStreamNames;
    }

    public void setPublishBlockDuplicateStreamNames(boolean bl) {
        this.publishBlockDuplicateStreamNames = bl;
    }

    public String getPublishValidEncoders() {
        return this.publishValidEncoders;
    }

    public void setPublishValidEncoders(String string) {
        this.publishValidEncoders = string;
    }

    public String getPublishAuthenticationMethod() {
        return this.publishAuthenticationMethod;
    }

    public void setPublishAuthenticationMethod(String string) {
        this.publishAuthenticationMethod = string;
    }

    public String getClientStreamWriteAccess() {
        return this.clientStreamWriteAccess;
    }

    public void setClientStreamWriteAccess(String string) {
        this.clientStreamWriteAccess = string;
    }

    public int getPlayMaximumConnections() {
        return this.playMaximumConnections;
    }

    public void setPlayMaximumConnections(int n) {
        this.playMaximumConnections = n;
    }

    public boolean isPlayRequireSecureConnection() {
        return this.playRequireSecureConnection;
    }

    public void setPlayRequireSecureConnection(boolean bl) {
        this.playRequireSecureConnection = bl;
    }

    public String getSecureTokenSharedSecret() {
        return this.secureTokenSharedSecret;
    }

    public void setSecureTokenSharedSecret(String string) {
        this.secureTokenSharedSecret = string;
    }

    public String getSecureTokenOriginSharedSecret() {
        return this.secureTokenOriginSharedSecret;
    }

    public void setSecureTokenOriginSharedSecret(String string) {
        this.secureTokenOriginSharedSecret = string;
    }

    public String getPlayIPBlackList() {
        return this.playIPBlackList;
    }

    public void setPlayIPBlackList(String string) {
        this.playIPBlackList = string;
    }

    public String getPlayIPWhiteList() {
        return this.playIPWhiteList;
    }

    public void setPlayIPWhiteList(String string) {
        this.playIPWhiteList = string;
    }

    public String getPlayAuthenticationMethod() {
        return this.playAuthenticationMethod;
    }

    public void setPlayAuthenticationMethod(String string) {
        this.playAuthenticationMethod = string;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    public static SecurityConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(117 + -90, "mtrmk"), string);
        hashMap.put(Severity.valueOf(3 * 19, "xjkR|sz"), string2);
        return (SecurityConfig)SecurityConfig.getObjectFromREST(SecurityConfig.getUrl(hashMap, SecurityConfig.class), SecurityConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean useCoreSecurityModule() {
        boolean bl = false;
        if (this.publishRequirePassword) {
            bl = true;
        }
        if (this.publishIPWhiteList != null && this.publishIPWhiteList.length() > 0) {
            bl = true;
        }
        if (this.publishIPBlackList != null && this.publishIPBlackList.length() > 0) {
            bl = true;
        }
        if (this.publishBlockDuplicateStreamNames) {
            bl = true;
        }
        if (this.publishValidEncoders != null && this.publishValidEncoders.length() > 0) {
            bl = true;
        }
        if (this.playRequireSecureConnection) {
            bl = true;
        }
        if (this.secureTokenSharedSecret != null && this.secureTokenSharedSecret.length() > 1) {
            bl = true;
        }
        if (this.playIPWhiteList != null && this.playIPWhiteList.length() > 1) {
            bl = true;
        }
        if (this.playIPBlackList != null && this.playIPBlackList.length() > 1) {
            bl = true;
        }
        if (this.playMaximumConnections <= 0) return bl;
        return true;
    }
}

