/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.application.stream;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.SystemUtils;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import com.wowza.wms.rest.application.ApplicationsConfig;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerList;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamList;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Streams")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/streams", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class StreamConfig
extends ApplicationConfigBase {
    @JsonProperty(value="streamType")
    @XStreamAlias(value="StreamType")
    @WMSXMLVariable(xpath="/Root/Application/Streams/StreamType/text()")
    protected String streamType;
    @JsonProperty(value="storageDir")
    @XStreamAlias(value="StorageDir")
    @WMSXMLVariable(xpath="/Root/Application/Streams/StorageDir/text()")
    protected String storageDir;
    @JsonProperty(value="storageDirExists")
    @XStreamAlias(value="StorageDirExists")
    protected boolean storageDirExists;
    @JsonProperty(value="keyDir")
    @XStreamAlias(value="KeyDir")
    @WMSXMLVariable(xpath="/Root/Application/Streams/KeyDir/text()")
    protected String keyDir;
    @JsonProperty(value="liveStreamPacketizer")
    @XStreamAlias(value="LiveStreamPacketizers")
    @WMSXMLVariable(xpath="/Root/Application/Streams/LiveStreamPacketizers/text()")
    protected List<String> liveStreamPacketizer;
    @JsonProperty(value="httpRandomizeMediaName")
    @XStreamAlias(value="HTTPRandomizeMediaName")
    @WMSXMLProperty(root="/Root/Application/LiveStreamPacketizer", name="httpRandomizeMediaName", defaultValue="false")
    boolean a;
    @XStreamOmitField
    protected List<String> streamTypeOptions;
    @XStreamOmitField
    protected List<String> liveStreamPacketizerOptions;

    public StreamConfig() {
    }

    public StreamConfig(String string, String string2) {
        super(string, string2);
    }

    public String getStreamType() {
        return this.streamType;
    }

    public void setStreamType(String string) {
        this.streamType = string;
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public void setStorageDir(String string) {
        this.storageDir = string;
    }

    public boolean isStorageDirExists() {
        return this.storageDirExists;
    }

    public void setStorageDirExists(boolean bl) {
        this.storageDirExists = bl;
    }

    public String getKeyDir() {
        return this.keyDir;
    }

    public void setKeyDir(String string) {
        this.keyDir = string;
    }

    public List<String> getLiveStreamPacketizer() {
        return this.liveStreamPacketizer;
    }

    public void setLiveStreamPacketizer(List<String> list) {
        this.liveStreamPacketizer = list;
    }

    public List<String> getLiveStreamPacketizerOptions() {
        return this.liveStreamPacketizerOptions;
    }

    public void setLiveStreamPacketizerOptions(List<String> list) {
        this.liveStreamPacketizerOptions = list;
    }

    public List<String> getStreamTypeOptions() {
        return this.streamTypeOptions;
    }

    public void setStreamTypeOptions(List<String> list) {
        this.streamTypeOptions = list;
    }

    public boolean isHttpRandomizeMediaName() {
        return this.a;
    }

    public void setHttpRandomizeMediaName(boolean bl) {
        this.a = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void a() {
        try {
            Object object2;
            Class.forName(Utils.lastIndexOf("`kh(pg~pj\"zc|>gz|ga8^NQuhh", 497 / 155));
            IVHost iVHost = VHostSingleton.getInstance((String)Severity.valueOf(-7 - -52, "Rjjvpg\u007f`C^xkmE"));
            if (iVHost == null) return;
            this.streamTypeOptions = new ArrayList<String>();
            this.liveStreamPacketizerOptions = new ArrayList<String>();
            LiveStreamPacketizerList liveStreamPacketizerList = iVHost.getLiveStreamPacketizerList();
            Map map = liveStreamPacketizerList.getLiveStreamPacketizerDefs();
            for (Object object2 : map.keySet()) {
                this.liveStreamPacketizerOptions.add((String)object2);
            }
            Collections.sort(this.liveStreamPacketizerOptions);
            StreamList streamList = iVHost.getStreamTypes();
            object2 = streamList.getStreamDefs();
            Iterator iterator = object2.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Collections.sort(this.streamTypeOptions);
                    return;
                }
                String string = (String)iterator.next();
                this.streamTypeOptions.add(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        this.vhost = this.getStringVariable(Severity.valueOf(16 - -23, "q`fy\u007f"));
        this.appName = this.getStringVariable(Utils.lastIndexOf("m}~Aq|w", 77 + -33));
        ApplicationsConfig.updateAppplicationInfoCache(this.vhost, this.appName, this);
        return super.saveObject();
    }

    @Override
    public boolean loadObject() {
        this.a();
        boolean bl = super.loadObject();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        boolean bl = super.loadXMLNode(node, string);
        this.storageDirExists = false;
        if (!bl) return bl;
        if (this.storageDir == null) return bl;
        this.setPathMap();
        String string2 = SystemUtils.expandEnvironmentVariables((String)this.storageDir, (Map)this.pathMap);
        File file = new File(string2);
        this.storageDirExists = file.exists();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        this.a();
        if ((this.saveFieldList == null || this.saveFieldList.contains(Severity.valueOf(1026 / 180, "vrumhg_u}k"))) && this.streamType != null) {
            this.streamType = this.streamType.trim();
            if (this.streamTypeOptions != null && !this.streamTypeOptions.contains(this.streamType)) {
                this.addErrorMessage(constraintValidatorContext, Severity.valueOf(111 + 9, "+-(>=0\n&pd"), Utils.lastIndexOf("Qkmig~d+_y|jq|Fjdp,7", -54 - 38) + this.streamType);
                bl = false;
            }
        }
        if (this.saveFieldList != null) {
            if (!this.saveFieldList.contains(Utils.lastIndexOf("omscT|{oja]ol{tfznpd", 358 / 119))) return bl;
        }
        if (this.liveStreamPacketizer == null) return bl;
        if (this.liveStreamPacketizerOptions == null) return bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.liveStreamPacketizer.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.liveStreamPacketizer.clear();
                this.liveStreamPacketizer.addAll(arrayList);
                Collections.sort(this.liveStreamPacketizer);
                return bl;
            }
            String string = iterator.next();
            if (string.trim().length() <= 0 || this.liveStreamPacketizerOptions == null) continue;
            if (!this.liveStreamPacketizerOptions.contains(string.trim())) {
                this.addErrorMessage(constraintValidatorContext, Utils.lastIndexOf("ioqmZ~yilc_qryv`|lrj", 497 / 94), Utils.lastIndexOf("\u00039375,2}\u000e>cjgwm\u007fcu2)", -24 - -14) + string);
                bl = false;
            }
            if (arrayList.contains(string.trim())) continue;
            arrayList.add(string.trim());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        if (this.saveFieldList != null) {
            if (!this.saveFieldList.contains(Severity.valueOf(41 * 31, "$,+?:1\t'/e"))) return bl;
        }
        if (!this.streamType.startsWith(Severity.valueOf(496 / 112, "JjrUmjeficjjt"))) return bl;
        this.addWarningMessage(Utils.lastIndexOf("rvqadkSqyo", 63 * 31), "We dont recomened this stream type.");
        return true;
    }

    public static StreamConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(55 + 120, "yx~ag"), string);
        hashMap.put(Utils.lastIndexOf("dvwFhgn", 1006 / 190), string2);
        return (StreamConfig)StreamConfig.getObjectFromREST(StreamConfig.getUrl(hashMap, StreamConfig.class), StreamConfig.class, wMSClientSecurity);
    }
}

