/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.application.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.SystemUtils;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.application.transcoder.TranscoderAppConfig;
import com.wowza.wms.rest.application.transcoder.TranscoderEncodeAppConfig;
import com.wowza.wms.rest.application.transcoder.TranscoderOverlayDecodeAppConfig;
import com.wowza.wms.rest.application.transcoder.TranscoderStreamNameGroupAppConfig;
import com.wowza.wms.rest.vhost.transcoder.TranscoderEncodeConfig;
import com.wowza.wms.rest.vhost.transcoder.TranscoderOverlayDecodeConfig;
import com.wowza.wms.rest.vhost.transcoder.TranscoderStreamNameGroupConfig;
import com.wowza.wms.rest.vhost.transcoder.TranscoderTemplateConfig;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Template")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/transcoder/templates/{templateName}", restVerbs="GET,PUT,POST,DELETE", xmlFilename="{templateName}.xml")
public class TranscoderTemplateAppConfig
extends TranscoderTemplateConfig {
    @XStreamOmitField
    protected String appName;
    @WMSXMLList(xpath="/Root/Transcode/Encodes", keyxpath="/Encode/Name", keyName="encodeName")
    protected List<TranscoderEncodeAppConfig> encodesApp;
    @WMSXMLList(xpath="/Root/Transcode/StreamNameGroups", keyxpath="/StreamNameGroup/Name", keyName="groupName")
    protected List<TranscoderStreamNameGroupAppConfig> streamNameGroupsApp;
    @WMSXMLList(xpath="/Root/Transcode/Decode/Video/Overlays", keyxpath="/Overlay/Name", keyName="overlayName")
    protected List<TranscoderOverlayDecodeAppConfig> decodeOverlaysApp;

    public TranscoderTemplateAppConfig() {
    }

    public TranscoderTemplateAppConfig(String string, String string2, String string3) {
        super(string, string3);
        this.appName = string2;
        this.addToStringKeyMap(Severity.valueOf(22 + 18, "iyzEm`k"), string2);
        this.initUrl();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public List<TranscoderEncodeAppConfig> getEncodesApp() {
        return this.encodesApp;
    }

    public void setEncodesApp(List<TranscoderEncodeAppConfig> list) {
        this.encodesApp = list;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(59 * 51, " 23\n$+\""));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Field[] getDeclaredFields() {
        Field[] fieldArray = null;
        try {
            ArrayList<Field> arrayList = new ArrayList<Field>(Arrays.asList(this.getClass().getSuperclass().getDeclaredFields()));
            arrayList.add(this.getClass().getDeclaredField(Utils.lastIndexOf("vzvys}j[kl", 47 * 61)));
            arrayList.add(this.getClass().getDeclaredField(Severity.valueOf(30 - 46, "#% 658\u001865<\u001d)3(.,Aqr")));
            arrayList.add(this.getClass().getDeclaredField(Utils.lastIndexOf("1347=?\u0014*8,3!81\u000245", 47 * 59)));
            ArrayList<Field> arrayList2 = arrayList;
            return arrayList2.toArray(new Field[arrayList2.size()]);
        }
        catch (Exception exception) {
            ConfigBase.logWarn(Utils.lastIndexOf("Twiedlg+khz{y\u007fu3ppu{yk\u007f\u007f<{wzleq9$", 559 / 124) + this.getQuery(), exception);
            return fieldArray;
        }
    }

    @Override
    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Utils.lastIndexOf(")(.17", 96 + -1));
        this.appName = this.getStringVariable(Utils.lastIndexOf("\"45\b&%,", 20 - 49));
        String string = TranscoderAppConfig.getTemplateDir(this.vhostName, this.appName);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(26 - 41, "2=>z\"9 \"8t,1.p<oovf|q(Q@fy\u007f"), this.vhostName);
        hashMap.put(Utils.lastIndexOf("zuv2jqh: l4)6h$''>.49`\u0019\u0018>!'\u0017:811>\u0012418", -59 - 12), VHostsConfig.getVHostDir(this.vhostName));
        hashMap.put(Utils.lastIndexOf("l\u007f|<d{blv6nwh2~qqtdzw*Dvwd`ijxdaa", 3 * 5), this.appName);
        return SystemUtils.expandEnvironmentVariables((String)string, hashMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        boolean bl = super.loadXMLNode(node, string);
        if (!bl) {
            return bl;
        }
        this.encodes = new ArrayList<TranscoderEncodeConfig>();
        this.encodes.addAll(this.encodesApp);
        this.encodesApp.clear();
        this.encodesApp = null;
        this.streamNameGroups = new ArrayList<TranscoderStreamNameGroupConfig>();
        this.streamNameGroups.addAll(this.streamNameGroupsApp);
        this.streamNameGroupsApp.clear();
        this.streamNameGroupsApp = null;
        this.decodeOverlays = new ArrayList<TranscoderOverlayDecodeConfig>();
        this.decodeOverlays.addAll(this.decodeOverlaysApp);
        this.decodeOverlaysApp.clear();
        this.decodeOverlaysApp = null;
        return bl;
    }

    @Override
    protected TranscoderTemplateConfig getNewTemplate(String string) {
        return new TranscoderTemplateAppConfig(this.vhostName, this.appName, string);
    }

    public static TranscoderTemplateAppConfig getObjectFromREST(String string, String string2, String string3, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.lastIndexOf("kvpsu", 35 * 63), string);
        hashMap.put(Severity.valueOf(59 - -5, "!12\r%(#"), string2);
        hashMap.put(Utils.lastIndexOf("/90.3!5'\r%(#", 7 - 44), string3);
        return (TranscoderTemplateAppConfig)TranscoderTemplateAppConfig.getObjectFromREST(TranscoderTemplateAppConfig.getUrl(hashMap, TranscoderTemplateAppConfig.class), TranscoderTemplateAppConfig.class, wMSClientSecurity);
    }
}

