/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.mediacache;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.mediacache.MediaCacheConfig;
import com.wowza.wms.server.Server;
import java.io.File;
import java.util.Iterator;
import javax.validation.ConstraintValidatorContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCacheSource")
@WMSConfig(restLocation="/v1/{server}/mediacache/sources/{name}", restVerbs="GET,POST,PUT,DELETE", xmlFilename="MediaCache.xml")
public class MediaCacheSourceConfig
extends ConfigBase
implements Comparable<MediaCacheSourceConfig> {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/Name/text()")
    public String name;
    @JsonProperty(value="type")
    @XStreamAlias(value="Type")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/Type/text()")
    public String type;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/Description/text()")
    public String description;
    @JsonProperty(value="basePath")
    @XStreamAlias(value="BasePath")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/BasePath/text()")
    public String basePath;
    @JsonProperty(value="prefix")
    @XStreamAlias(value="Prefix")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/Prefix/text()")
    public String prefix;
    @JsonProperty(value="minTimeToLive")
    @XStreamAlias(value="MinTimeToLive")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/MinTimeToLive/text()")
    public long minTimeToLive;
    @JsonProperty(value="maxTimeToLive")
    @XStreamAlias(value="MaxTimeToLive")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/MaxTimeToLive/text()")
    public long maxTimeToLive;
    @JsonProperty(value="isAmazonS3")
    @XStreamAlias(value="IsAmazonS3")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']", name="isAmazonS3", defaultValue="false")
    public boolean isAmazonS3;
    @JsonProperty(value="s3BucketNameInDomain")
    @XStreamAlias(value="S3BucketNameInDomain")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']", name="s3BucketNameInDomain", defaultValue="false")
    public boolean s3BucketNameInDomain;
    @JsonProperty(value="awsAccessKeyId")
    @XStreamAlias(value="AWSAccessKeyId")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']", name="awsAccessKeyId", defaultValue="")
    public String awsAccessKeyId;
    @JsonProperty(value="awsSecretAccessKey")
    @XStreamAlias(value="AWSSecretAccessKey")
    @WMSXMLProperty(root="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']", name="awsSecretAccessKey", defaultValue="")
    public String awsSecretAccessKey;
    @JsonProperty(value="isPassThru")
    @XStreamAlias(value="IsPassThru")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/IsPassThru/text()")
    public boolean isPassThru;
    @JsonProperty(value="baseClass")
    @XStreamAlias(value="BaseClass")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/BaseClass/text()")
    public String baseClass;
    @JsonProperty(value="readerClass")
    @XStreamAlias(value="ReaderClass")
    @WMSXMLVariable(xpath="/Root/MediaCacheSources/MediaCacheSource[Name='{name}']/ReaderClass/text()")
    public String readerClass;

    public MediaCacheSourceConfig() {
        String string = Severity.valueOf(87 + -56, "qalg");
        this.addFieldForKeyMap(string, string);
    }

    public MediaCacheSourceConfig(String string) {
        this.name = string;
        this.addToStringKeyMap(Utils.lastIndexOf("%- +", 111 + -36), string);
        this.initUrl();
        String string2 = Severity.valueOf(51 * 17, "-%(#");
        this.addFieldForKeyMap(string2, string2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(String string) {
        this.baseClass = string;
    }

    public String getReaderClass() {
        return this.readerClass;
    }

    public void setReaderClass(String string) {
        this.readerClass = string;
    }

    public long getMaxTimeToLive() {
        return this.maxTimeToLive;
    }

    public void setMaxTimeToLive(long l) {
        this.maxTimeToLive = l;
    }

    public long getMinTimeToLive() {
        return this.minTimeToLive;
    }

    public void setMinTimeToLive(long l) {
        this.minTimeToLive = l;
    }

    public boolean isPassThru() {
        return this.isPassThru;
    }

    public void setPassThru(boolean bl) {
        this.isPassThru = bl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isAmazonS3() {
        return this.isAmazonS3;
    }

    public void setAmazonS3(boolean bl) {
        this.isAmazonS3 = bl;
    }

    public boolean isS3BucketNameInDomain() {
        return this.s3BucketNameInDomain;
    }

    public void setS3BucketNameInDomain(boolean bl) {
        this.s3BucketNameInDomain = bl;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String string) {
        this.awsAccessKeyId = string;
    }

    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    public void setAwsSecretAccessKey(String string) {
        this.awsSecretAccessKey = string;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(53 * 17, "kgjm"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        Iterator<MediaCacheSourceConfig> iterator;
        boolean bl = super.isValid(constraintValidatorContext);
        try {
            Class.forName(Utils.lastIndexOf("1<9{!8/#;u+0-q3$05!7h\u0014-;<.>", 101 + -19));
            Server server = Server.getInstance();
            MediaCacheConfig mediaCacheConfig = new MediaCacheConfig();
            if (!mediaCacheConfig.loadObject()) return bl;
            if (mediaCacheConfig.getMediaCacheSources() == null) return bl;
            iterator = mediaCacheConfig.getMediaCacheSources().iterator();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return bl;
        }
        while (iterator.hasNext()) {
            MediaCacheSourceConfig mediaCacheSourceConfig = iterator.next();
            if (mediaCacheSourceConfig.name.equals(this.name) || !mediaCacheSourceConfig.prefix.equals(this.prefix)) continue;
            this.addErrorMessage(constraintValidatorContext, Utils.lastIndexOf("dgsqqa", 79 + 101), "{mediacache.source.prefix.unique}");
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean exists() {
        Object object;
        boolean bl = false;
        try {
            object = this.getFilename();
            File file = new File((String)object);
            bl = file.exists();
        }
        catch (Exception exception) {}
        if (bl) {
            bl = false;
            object = new MediaCacheConfig();
            if (((MediaCacheConfig)((Object)object)).loadObject()) {
                for (MediaCacheSourceConfig mediaCacheSourceConfig : ((MediaCacheConfig)((Object)object)).getMediaCacheSources()) {
                    if (!mediaCacheSourceConfig.name.equals(this.name)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static MediaCacheSourceConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (MediaCacheSourceConfig)MediaCacheSourceConfig.getObjectFromREST(MediaCacheSourceConfig.getUrl(Utils.lastIndexOf("3?2%", -13 - 22), string, MediaCacheSourceConfig.class), MediaCacheSourceConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(MediaCacheSourceConfig mediaCacheSourceConfig) {
        return this.name.compareTo(mediaCacheSourceConfig.name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean updateXML(Document document) {
        boolean bl = super.updateXML(document);
        if (!bl) return bl;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        Element element = document.getDocumentElement();
        try {
            XPathExpression xPathExpression = xPath.compile(this.resolveVariables(Severity.valueOf(389 / 127, ",Vjis'DooelMnsyw@{`dt}j5Vyyw~C`akaVirzjoPBlcj-6") + this.name + Utils.lastIndexOf("i\u0012\u007f\u00133 1\u0016:6+*", 117 + 121)));
            Node node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
            if (node != null) return bl;
            MediaCacheSourceConfig mediaCacheSourceConfig = this;
            Node node2 = mediaCacheSourceConfig.a(mediaCacheSourceConfig.type);
            if (node2 != null) {
                xPathExpression = xPath.compile(this.resolveVariables(Severity.valueOf(4 + 2, ")Ugf~$AhjfqRsp|pExmky~o2Szdhc@efnb[f\u007fyohUAq|w.3") + this.name + Utils.lastIndexOf("{\u0000", -40 - -4)));
                Node node3 = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
                if (node3 == null) return bl;
                Node node4 = node3.getParentNode();
                node4.removeChild(node3);
                node2 = document.adoptNode(node2.cloneNode(true));
                Element element2 = document.createElement(Utils.lastIndexOf("Mehc", 863 / 246));
                element2.appendChild(document.createTextNode(this.name));
                node2.insertBefore(element2, node2.getFirstChild());
                node4.appendChild(node2);
                this.updateXML(document);
                return bl;
            }
            ConfigBase.log.warn((Object)(Utils.lastIndexOf("QAVR'IYC1,@kkypQrw}sDwlhxyI{rpmcwa+~jd3*Hcxbk0\u007f}g4s\u007fy|9{;hxso, 6&d#)5h=3;)w", 346 / 90) + this.type));
            return bl;
        }
        catch (XPathExpressionException xPathExpressionException) {
            ConfigBase.log.warn((Object)(Severity.valueOf(45 * 9, "Edxzu\u007fv<hn{aukmc%Kbl`kHmnfj0r}}r|q-8") + this.getQuery()), (Throwable)xPathExpressionException);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Node a(String string) {
        Node node = null;
        String string2 = ConfigBase.wowzaBasePath + Severity.valueOf(89 + -83, "ehfo%") + Utils.lastIndexOf("FiignSpq{qFybjz\u007fOypnsaugp*}kk", 63 * 53);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            File file = new File(string2);
            boolean bl = false;
            if (!bl && file.exists()) {
                try {
                    document = documentBuilder.parse(string2);
                    bl = true;
                }
                catch (Exception exception) {}
                if (bl) {
                    ConfigBase.log.info((Object)Utils.lastIndexOf("CW@@5WGQ#:Ws~\u007fs`\u0019\u000f\u000fd*0\":;#/)wn\u000255;2\u001745?=\n5..>;\u000b%,2/%1#4f1''", 22 + 27));
                }
            }
            if (!bl) {
                try {
                    document = MediaCacheSourceConfig.getDocumentFromResouce(Severity.valueOf(76 + -62, "CjtxsPuv~rKvoi\u007fxJzmqnbp`u)pdf"));
                    bl = true;
                }
                catch (Exception exception) {}
            }
            if (bl) {
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                Element element = document.getDocumentElement();
                XPathExpression xPathExpression = xPath.compile(this.resolveVariables(Utils.lastIndexOf("+Wih|&GnhdoLqrzvGzce{|i4QxzvaBc`l`Uh}{inWYw\u007fu,5", 167 / 34) + string + Severity.valueOf(35 - -27, "9B")));
                node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
                XPathExpression xPathExpression2 = xPath.compile(this.resolveVariables(Utils.lastIndexOf("*Thg}%FiignSpq{qFybjz\u007fh3P{{i`AbgmcTg|xhiVZv`t/4", 1206 / 207) + string + Severity.valueOf(51 - -9, ";@1Q!,'")));
                Node node2 = (Node)xPathExpression2.evaluate(element, XPathConstants.NODE);
                if (node2 == null) return node;
                node2.getParentNode().removeChild(node2);
                return node;
            }
            ConfigBase.log.warn((Object)Severity.valueOf(-15 - 7, "\u0018\u000e\u001f\u0019n\u000e\u0000\u0018hs\u001902>9\u001a;848\r0usafP`kwdh~n\u007f#vb|1v|qf6ywm:~dtmk.!\"Mar&Ogz~{c\u007fz/}pk3zzb7~ltxhtqq`10,4 4+1g"));
            return node;
        }
        catch (XPathExpressionException xPathExpressionException) {
            ConfigBase.log.warn((Object)(Severity.valueOf(39 + 25, "\u00103-!( +g/,>?%#)o\u001d46:5\u0016740<z?9;?*,5xc") + this.getQuery()), (Throwable)xPathExpressionException);
            return node;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ConfigBase.log.warn((Object)(Utils.lastIndexOf("Cugerj9ytr{wx53#7-*(g8;%) (#up", 104 + -53) + this.getQuery()), (Throwable)parserConfigurationException);
            return node;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Severity.valueOf(15 - 52, "\t\u0019\u000e\n\u007f\u0001\u0011\u000byd\u0001#+-=#%+m\u0003*483s\u001745?=y\t4)/=: )") + this.getStringVariable(Severity.valueOf(53 * 35, "q!,'")) + Utils.lastIndexOf("-?&Nf)~ymik/cy}d4xys}7:;Rrj?$$.&0,( h\u001a%>>.+a", 41 - 5)));
            wMSResponse.success = true;
            wMSResponse.message = Utils.lastIndexOf("Bbdl~nh", 322 / 53);
            return wMSResponse;
        }
        if (!this.removeNode(Utils.lastIndexOf("h\u001a&%?c\u0000++90\u001127=3\u00047,(89.q\u0012eekbGdeomZe~~nkT^p\u007fv)2myyt\u007ff;@", 60 - -43))) {
            wMSResponse.message = Utils.lastIndexOf("\b#8\"+p?='t13;=-?{3?4:cu", -40 - -19);
            return wMSResponse;
        }
        wMSResponse.success = true;
        return wMSResponse;
    }
}

