/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.mediacache;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.mediacache.MediaCacheConfig;
import com.wowza.wms.server.Server;
import java.io.File;
import java.util.Iterator;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCacheStore")
@WMSConfig(restLocation="/v1/{server}/mediacache/stores/{name}", restVerbs="GET,POST,PUT,DELETE", xmlFilename="MediaCache.xml")
public class MediaCacheStoreConfig
extends ConfigBase
implements Comparable<MediaCacheStoreConfig> {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{name}']/Name/text()")
    public String name;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{name}']/Description/text()")
    public String description;
    @JsonProperty(value="path")
    @XStreamAlias(value="Path")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{name}']/Path/text()")
    public String path;
    @JsonProperty(value="maxSize")
    @XStreamAlias(value="MaxSize")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{name}']/MaxSize/text()")
    public String maxSize;
    @JsonProperty(value="writeRate")
    @XStreamAlias(value="WriteRate")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{name}']/WriteRate/text()")
    public String writeRate;
    @JsonProperty(value="writeRateMaxBucketSize")
    @XStreamAlias(value="WriteRateMaxBucketSize")
    @WMSXMLVariable(xpath="/Root/MediaCacheStores/MediaCacheStore[Name='{name}']/WriteRateMaxBucketSize/text()")
    public String writeRateMaxBucketSize;

    public MediaCacheStoreConfig() {
        String string = Utils.lastIndexOf(";7:=", 11 * 31);
        this.addFieldForKeyMap(string, string);
    }

    public MediaCacheStoreConfig(String string) {
        this.name = string;
        this.addToStringKeyMap(Utils.lastIndexOf("em`k", 21 * 31), string);
        this.initUrl();
        String string2 = Severity.valueOf(15 * 11, "kgjm");
        this.addFieldForKeyMap(string2, string2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getWriteRate() {
        return this.writeRate;
    }

    public void setWriteRate(String string) {
        this.writeRate = string;
    }

    public String getWriteRateMaxBucketSize() {
        return this.writeRateMaxBucketSize;
    }

    public void setWriteRateMaxBucketSize(String string) {
        this.writeRateMaxBucketSize = string;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(String string) {
        this.maxSize = string;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(1289 / 185, "hfel"));
        String string = Severity.valueOf(-47 - 31, "|ryp");
        this.addFieldForKeyMap(string, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        Iterator<MediaCacheStoreConfig> iterator;
        boolean bl = super.isValid(constraintValidatorContext);
        try {
            Class.forName(Utils.lastIndexOf("`kh(pg~pj\"zc|>bwabpd9K|hmyo", 612 / 194));
            Server server = Server.getInstance();
            MediaCacheConfig mediaCacheConfig = new MediaCacheConfig();
            if (!mediaCacheConfig.loadObject()) return bl;
            if (mediaCacheConfig.getMediaCacheStores() == null) return bl;
            iterator = mediaCacheConfig.getMediaCacheStores().iterator();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return bl;
        }
        while (iterator.hasNext()) {
            MediaCacheStoreConfig mediaCacheStoreConfig = iterator.next();
            if (mediaCacheStoreConfig.name.equals(this.name) || !mediaCacheStoreConfig.path.equals(this.path)) continue;
            this.addErrorMessage(constraintValidatorContext, Severity.valueOf(45 * 25, "5'3 "), "{mediacache.store.path.unique}");
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean exists() {
        Object object;
        boolean bl = false;
        try {
            object = this.getFilename();
            File file = new File((String)object);
            bl = file.exists();
        }
        catch (Exception exception) {}
        if (bl) {
            bl = false;
            object = new MediaCacheConfig();
            if (((MediaCacheConfig)((Object)object)).loadObject()) {
                for (MediaCacheStoreConfig mediaCacheStoreConfig : ((MediaCacheConfig)((Object)object)).getMediaCacheStores()) {
                    if (!mediaCacheStoreConfig.name.equals(this.name)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static MediaCacheStoreConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (MediaCacheStoreConfig)MediaCacheStoreConfig.getObjectFromREST(MediaCacheStoreConfig.getUrl(Utils.lastIndexOf("kgjm", 6 - -31), string, MediaCacheStoreConfig.class), MediaCacheStoreConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(MediaCacheStoreConfig mediaCacheStoreConfig) {
        return this.name.compareTo(mediaCacheStoreConfig.name);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Severity.valueOf(836 / 213, "QAVR'IYC1,Ikcue{}s5[r|p{;_|}we!Qwkwc' ") + this.getStringVariable(Severity.valueOf(1165 / 168, "hfel")) + Utils.lastIndexOf("*>%Oi(}xjhh.|x~e3yzrr69:Usi>{emgwmka'[}eyi#", 44 + -41)));
            wMSResponse.success = true;
            wMSResponse.message = Utils.lastIndexOf("Gaicsmm", 752 / 234);
            return wMSResponse;
        }
        if (this.removeNode(Utils.lastIndexOf("#_a`d>_vp|wTyzr~Oiqm%2m\u000e!!/&\u000b()#)\u001e: \"4\t\u001d583j\u007f\"4:18#x\u001d", 91 + 81))) {
            wMSResponse.success = true;
            return wMSResponse;
        }
        wMSResponse.message = Severity.valueOf(101 + 36, "Je~`i.a\u007fe2wqysc}9uyvx}k");
        return wMSResponse;
    }
}

