/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.publisher;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.publisher.PublishersConfig;
import com.wowza.wms.rest.user.UsersConfig;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Publisher")
@WMSConfig(restLocation="/v1/{server}/publishers/{publisher}", restVerbs="GET,PUT,POST,DELETE", xmlFilename="")
public class PublisherConfig
extends ConfigBase
implements Comparable<PublisherConfig> {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String name;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    protected String description;
    @JsonProperty(value="password")
    @XStreamAlias(value="Password")
    protected String password;
    @XStreamOmitField
    protected String privatePassword;

    public PublisherConfig() {
        this.addFieldForKeyMap(Severity.valueOf(935 / 217, "tpdkazbn~"), "name");
    }

    public PublisherConfig(String string) {
        this.addFieldForKeyMap(Utils.lastIndexOf("40$+!:\".>", 46 + 22), "name");
        this.name = string;
        this.addToStringKeyMap(Utils.lastIndexOf("vrjecxdh|", 1503 / 229), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.lastIndexOf("/ucnjwmcu", -66 - 63));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPrivatePassword() {
        return this.privatePassword;
    }

    public void setPrivatePassword(String string) {
        this.privatePassword = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        boolean bl = super.loadObject();
        if (!bl) return bl;
        this.fillStringKeyMap();
        this.name = this.getStringVariable(Utils.lastIndexOf("vrjecxdh|", 611 / 93));
        PublisherConfig publisherConfig = PublishersConfig.getPublisher(this.name);
        if (publisherConfig == null) return bl;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean exists() {
        PublisherConfig publisherConfig = PublishersConfig.getPublisher(this.name);
        if (publisherConfig == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WMSResponse saveObject() {
        WMSResponse wMSResponse;
        block2: {
            block1: {
                wMSResponse = new WMSResponse();
                if (ConfigBase.inTradeShowMode) break block1;
                break block2;
            }
            ConfigBase.log.warn((Object)Utils.lastIndexOf("\u0012\u0004\u0011\u0017d\u0004\u0016\u000eri\u0019*:$ (p\u0001'18<%?=+)a|\u00140\u007f43#'!e5/'>j&#)+apq\u001c< u58543/(408 bjbjbct&", 55 + 9));
            wMSResponse.success = true;
            wMSResponse.message = Utils.lastIndexOf("Uf~ln", 1067 / 174);
            return wMSResponse;
        }
        if (UsersConfig.isMemberOf(this.user.getName(), Severity.valueOf(61 - -29, ";?140"))) return PublishersConfig.updatePublisher(this);
        wMSResponse.message = Utils.lastIndexOf("\u00197-z:))60rhxf`", 60 + 59);
        return wMSResponse;
    }

    @Override
    public WMSResponse saveNewObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (!ConfigBase.inTradeShowMode) {
            this.privatePassword = this.password;
            return PublishersConfig.addPublisher(this);
        }
        ConfigBase.log.warn((Object)(Severity.valueOf(7 * 3, "GSDL9[KU'>^dekmc%Vrjecxdh|/09") + this.name + Utils.lastIndexOf("\u007fmx\u00104{(/?;%a1++2f*'-/elm\u0000 $q370<80x?379s", -5 + 91)));
        wMSResponse.success = true;
        wMSResponse.message = Severity.valueOf(37 * 11, "V|}\u007f\u007f");
        return wMSResponse;
    }

    @Override
    public WMSResponse deleteObject() {
        return PublishersConfig.removePublisher(this.name);
    }

    public static PublisherConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (PublisherConfig)PublisherConfig.getObjectFromREST(PublisherConfig.getUrl(Utils.lastIndexOf("vrjecxdh|", 213 / 34), string, PublisherConfig.class), PublisherConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(PublisherConfig publisherConfig) {
        return this.name.compareTo(publisherConfig.getName());
    }
}

