/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.server.MediaCasterConfig;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MediaCasters")
@WMSConfig(restLocation="/v1/{server}/server/mediacasters", restVerbs="GET", xmlFilename="MediaCasters.xml")
public class MediaCastersConfig
extends ConfigBase {
    @JsonProperty(value="mediaCasters")
    @XStreamImplicit(itemFieldName="MediaCaster")
    @WMSXMLList(xpath="/Root/MediaCasters", keyxpath="/MediaCaster/Name", keyName="mediacastername")
    protected List<MediaCasterConfig> mediaCastersList;

    public MediaCastersConfig() {
        this.useLocalResourceIfAvailable = true;
    }

    public List<MediaCasterConfig> getMediaCastersList() {
        return this.mediaCastersList;
    }

    @Override
    protected boolean exists() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        boolean bl = super.loadObject();
        if (this.mediaCastersList == null) {
            return bl;
        }
        Collections.sort(this.mediaCastersList);
        return bl;
    }

    public static MediaCastersConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (MediaCastersConfig)MediaCastersConfig.getObjectFromREST(MediaCastersConfig.getUrl(MediaCastersConfig.class), MediaCastersConfig.class, wMSClientSecurity);
    }
}

