/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.server.ServerListenersConfig;
import com.wowza.wms.server.Server;
import com.wowza.wms.server.ServerTuningHandler;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="ServerConfig")
@WMSConfig(restLocation="/v1/{server}/server", restVerbs="GET,PUT", xmlFilename="Server.xml")
public class ServerConfig
extends ConfigBase {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSXMLVariable(xpath="/Root/Server/Name/text()")
    protected String name;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/Server/Description/text()")
    protected String description;
    @JsonProperty(value="defaultStreamPrefix")
    @XStreamAlias(value="DefaultStreamPrefix")
    @WMSXMLVariable(xpath="/Root/Server/Streams/DefaultStreamPrefix/text()")
    protected String defaultStreamPrefix;
    @NotNull
    @JsonProperty(value="ipAddress")
    @XStreamAlias(value="IPAddress")
    @WMSXMLVariable(xpath="/Root/Server/CommandInterface/HostPort/IpAddress/text()")
    protected String ipAddress;
    @JsonProperty(value="port")
    @XStreamAlias(value="Port")
    @WMSXMLVariable(xpath="/Root/Server/CommandInterface/HostPort/Port/text()")
    protected int port;
    @JsonProperty(value="handlerThreadPool")
    @XStreamAlias(value="HandlerThreadPool")
    @WMSXMLVariable(xpath="/Root/Server/HandlerThreadPool/PoolSize/text()")
    protected String handlerThreadPool;
    @JsonProperty(value="handlerThreadPoolAutoValue")
    @XStreamAlias(value="HandlerThreadPoolAutoValue")
    protected String handlerThreadPoolAutoValue;
    @JsonProperty(value="transportThreadPool")
    @XStreamAlias(value="TransportThreadPool")
    @WMSXMLVariable(xpath="/Root/Server/TransportThreadPool/PoolSize/text()")
    protected String transportThreadPool;
    @JsonProperty(value="transportThreadPoolAutoValue")
    @XStreamAlias(value="HandlerThreadPoolAutoValue")
    protected String transportThreadPoolAutoValue;
    @JsonProperty(value="rtpDataPortSharing")
    @XStreamAlias(value="RTPDataPortSharing")
    @WMSXMLVariable(xpath="/Root/Server/RTP/DatagramPortSharing/text()")
    protected boolean rtpDataPortSharing;
    @JsonProperty(value="rtpDataPortSharingPort")
    @XStreamAlias(value="RTPDataPortSharingPort")
    @WMSXMLVariable(xpath="/Root/Server/RTP/DatagramStartingPort/text()")
    protected int rtpDataPortSharingPort;
    @JsonProperty(value="serverListeners")
    @XStreamAlias(value="ServerListeners")
    protected ServerListenersConfig serverListeners = new ServerListenersConfig();

    public ServerConfig() {
        this.initUrl();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDefaultStreamPrefix() {
        return this.defaultStreamPrefix;
    }

    public void setDefaultStreamPrefix(String string) {
        this.defaultStreamPrefix = string;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    public String getHandlerThreadPool() {
        return this.handlerThreadPool;
    }

    public void setHandlerThreadPool(String string) {
        this.handlerThreadPool = string;
    }

    public String getHandlerThreadPoolAutoValue() {
        return this.handlerThreadPoolAutoValue;
    }

    public void setHandlerThreadPoolAutoValue(String string) {
        this.handlerThreadPoolAutoValue = string;
    }

    public String getTransportThreadPool() {
        return this.transportThreadPool;
    }

    public void setTransportThreadPool(String string) {
        this.transportThreadPool = string;
    }

    public String getTransportThreadPoolAutoValue() {
        return this.transportThreadPoolAutoValue;
    }

    public void setTransportThreadPoolAutoValue(String string) {
        this.transportThreadPoolAutoValue = string;
    }

    public boolean isRtpDataPortSharing() {
        return this.rtpDataPortSharing;
    }

    public void setRtpDataPortSharing(boolean bl) {
        this.rtpDataPortSharing = bl;
    }

    public int getRtpDataPortSharingPort() {
        return this.rtpDataPortSharingPort;
    }

    public void setRtpDataPortSharingPort(int n) {
        this.rtpDataPortSharingPort = n;
    }

    public ServerListenersConfig getServerListeners() {
        return this.serverListeners;
    }

    public void setServerListeners(ServerListenersConfig serverListenersConfig) {
        this.serverListeners = serverListenersConfig;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        try {
            Class.forName(Utils.lastIndexOf("uxu7mtkg\u007f1wlq-w`tqm{$Xi\u007fxjbEg}}{q_yw~wyo", 60 + 90));
            ServerTuningHandler serverTuningHandler = Server.getInstance().getTuningHandler();
            this.handlerThreadPoolAutoValue = serverTuningHandler.getSuggestedServerHandlerThreadCount() + "";
            this.transportThreadPoolAutoValue = serverTuningHandler.getSuggestedServerTransportThreadCount() + "";
            return super.loadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.loadObject();
        }
    }

    public static ServerConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (ServerConfig)ServerConfig.getObjectFromREST(ServerConfig.getUrl(ServerConfig.class), ServerConfig.class, wMSClientSecurity);
    }
}

