/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.bootstrap.BootstrapSystemTuningInfo;
import com.wowza.wms.bootstrap.BootstrapTuningConfig;
import com.wowza.wms.bootstrap.BootstrapTuningResult;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSXMLVariable;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="ServerConfig")
@WMSConfig(restLocation="/v1/{server}/server/tune", restVerbs="GET,PUT", xmlFilename="Tune.xml")
public class ServerTuneConfig
extends ConfigBase {
    @JsonProperty(value="heapSize")
    @XStreamAlias(value="HeapSize")
    @WMSXMLVariable(xpath="/Root/Tune/HeapSize/text()")
    protected String heapSize;
    @JsonProperty(value="heapSizeCurrent")
    @XStreamAlias(value="HeapSizeCurrent")
    protected long heapSizeCurrent;
    @JsonProperty(value="garbageCollector")
    @XStreamAlias(value="GarbageCollector")
    @WMSXMLVariable(xpath="/Root/Tune/GarbageCollector/text()")
    protected String garbageCollector;
    @JsonProperty(value="garbageCollectorCurrent")
    @XStreamAlias(value="GarbageCollectorCurrent")
    protected String garbageCollectorCurrent;

    public String getHeapSize() {
        return this.heapSize;
    }

    public void setHeapSize(String string) {
        this.heapSize = string;
    }

    public long getHeapSizeCurrent() {
        return this.heapSizeCurrent;
    }

    public String getGarbageCollector() {
        return this.garbageCollector;
    }

    public void setGarbageCollector(String string) {
        this.garbageCollector = string;
    }

    public String getGarbageCollectorCurrent() {
        return this.garbageCollectorCurrent;
    }

    public ServerTuneConfig() {
        this.initUrl();
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        try {
            Class.forName(Severity.valueOf(501 / 146, "`kh(pg~pj\"zc|>s}|`fbeyi4YsrjltscsPphnfnIdbkgh"));
            BootstrapTuningConfig bootstrapTuningConfig = Bootstrap.getTuningConfig();
            if (bootstrapTuningConfig == null) return super.loadObject();
            BootstrapSystemTuningInfo bootstrapSystemTuningInfo = BootstrapSystemTuningInfo.getSystemTuningInfo();
            if (bootstrapSystemTuningInfo == null) return super.loadObject();
            BootstrapTuningResult bootstrapTuningResult = BootstrapTuningResult.calculateTuning((BootstrapSystemTuningInfo)bootstrapSystemTuningInfo, (BootstrapTuningConfig)bootstrapTuningConfig);
            if (bootstrapTuningResult == null) return super.loadObject();
            this.heapSizeCurrent = bootstrapTuningResult.getHeapSize();
            this.garbageCollectorCurrent = bootstrapTuningResult.getGCStr();
            return super.loadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ConfigBase.log.warn((Object)(Utils.lastIndexOf("V@US(HZB6-B`qu{}s5Rvlx:}so>0sdpuaw)s}go1,Naz|u2}{a6qqw~;\u007fq\u007fl3{", 779 / 188) + classNotFoundException.getMessage()));
            return super.loadObject();
        }
    }

    public static ServerTuneConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (ServerTuneConfig)ServerTuneConfig.getObjectFromREST(ServerTuneConfig.getUrl(ServerTuneConfig.class), ServerTuneConfig.class, wMSClientSecurity);
    }
}

