/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Stream")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/monitoring/current", restVerbs="GET", xmlFilename="Application.xml")
public class CurrentApplicationStatistics
extends ApplicationConfigBase {
    @JsonIgnore
    private String a;
    @JsonProperty(value="uptime")
    @XStreamAlias(value="Uptime")
    protected Long uptime;
    @JsonProperty(value="bytesIn")
    @XStreamAlias(value="BytesIn")
    protected Long bytesIn;
    @JsonProperty(value="bytesOut")
    @XStreamAlias(value="BytesOut")
    protected Long bytesOut;
    @JsonProperty(value="bytesInRate")
    @XStreamAlias(value="BytesInRate")
    protected long bytesInRate;
    @JsonProperty(value="bytesOutRate")
    @XStreamAlias(value="BytesOutRate")
    protected long bytesOutRate;
    @JsonProperty(value="totalConnections")
    @XStreamAlias(value="TotalConnections")
    protected Long totalConnections;
    @JsonProperty(value="connectionCount")
    @XStreamAlias(value="ConnectionCount")
    protected Map<String, Long> connectionCount = new HashMap<String, Long>();
    private static final WMSLogger b = WMSLoggerFactory.getLogger(CurrentApplicationStatistics.class);

    public CurrentApplicationStatistics() {
        String string = Severity.valueOf(24 - -23, "yx~ag");
        this.addFieldForKeyMap(string, string, true);
        String string2 = Utils.lastIndexOf("btuHfel", 464 / 132);
        this.addFieldForKeyMap(string2, string2, true);
    }

    public CurrentApplicationStatistics(String string, String string2) {
        super(string, string2);
        this.vhost = string;
        this.a = string2;
        String string3 = Severity.valueOf(11 * 3, "wjlwq");
        this.addFieldForKeyMap(string3, string3, true);
        this.addToStringKeyMap(Severity.valueOf(1070 / 161, "pogz~"), string);
        String string4 = Utils.lastIndexOf("l~\u007f^p\u007fv", 39 * 11);
        this.addFieldForKeyMap(string4, string4, true);
        this.addToStringKeyMap(Utils.lastIndexOf("iyzEm`k", 74 + -66), string2);
        this.initUrl();
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Severity.valueOf(59 * 31, "Fgiff~+\u007flxj0p|3uef{qz{ourp?35#7-62.+"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        IVHost iVHost;
        this.vhost = this.getStringVariable(Utils.lastIndexOf("e|zec", 39 * 21));
        this.a = this.getStringVariable(Severity.valueOf(45 + 72, "4&'\u001687>"));
        if (RestProperties.getBoolean(Severity.valueOf(120 + 72, "2$17\u00171'3!:>\"/>\n*2$5\u0016:44;=="))) {
            b.info(Severity.valueOf(55 * 17, "Um}\u007fybd`h0rgafpxc8t\u007font}l`'-1d") + this.vhost + Severity.valueOf(94 + -56, "&*(") + this.a);
        }
        if ((iVHost = VHostSingleton.getInstance((String)this.vhost)) == null) {
            return false;
        }
        IApplication iApplication = null;
        if (iVHost.isApplicationLoaded(this.a)) {
            iApplication = iVHost.getApplication(this.a);
        }
        if (iApplication == null) {
            this.connectionCount.put(Severity.valueOf(49 * 17, "\u0002\u0017\u0013\u0001\u0017\u0012\u000e\u0006\u0006"), 0L);
            this.connectionCount.put(Severity.valueOf(41 * 57, "ETQGMSICZ"), 0L);
            this.connectionCount.put(Utils.lastIndexOf("HVBOMKXD", 876 / 165), 0L);
            this.connectionCount.put(Severity.valueOf(349 / 86, "WDHMGZO"), 0L);
            this.connectionCount.put(Severity.valueOf(76 + 97, "^C@_EZ"), 0L);
            this.connectionCount.put(Utils.lastIndexOf("\u0011\u0002\n\u0004", -61 - -35), 0L);
            this.connectionCount.put(Severity.valueOf(59 + -23, "VQKW"), 0L);
            this.connectionCount.put(Severity.valueOf(58 + 81, "YX]"), 0L);
            this.totalConnections = 0L;
            this.uptime = 0L;
            this.bytesIn = 0L;
            this.bytesOut = 0L;
            this.bytesInRate = 0L;
            this.bytesOutRate = 0L;
        } else {
            this.connectionCount.put(Severity.valueOf(23 + 8, "\\UQGQPLHH"), iApplication.getConnectionCounter(2).getCurrent());
            this.connectionCount.put(Severity.valueOf(-46 - -56, "N]^NFZ^ZA"), iApplication.getConnectionCounter(7).getCurrent());
            this.connectionCount.put(Utils.lastIndexOf("NT@ACIZB", 109 + 54), iApplication.getConnectionCounter(6).getCurrent());
            this.connectionCount.put(Utils.lastIndexOf("WDHMGZO", 1067 / 215), iApplication.getConnectionCounter(4).getCurrent());
            this.connectionCount.put(Utils.lastIndexOf("\u0016\u000b\b\u0007\u001d\u0002", 37 * 33), iApplication.getConnectionCounter(3).getCurrent());
            this.connectionCount.put(Utils.lastIndexOf("EVVX", 78 + 68), iApplication.getConnectionCounter(5).getCurrent());
            this.connectionCount.put(Severity.valueOf(23 * 61, "\t\b\u0010\u000e"), iApplication.getConnectionCounter(0).getCurrent());
            this.connectionCount.put(Severity.valueOf(-35 - -44, "[^["), iApplication.getConnectionCounter(1).getCurrent());
            this.totalConnections = 0L;
            for (int i = 0; i < 8; ++i) {
                CurrentApplicationStatistics currentApplicationStatistics = this;
                Long.valueOf(currentApplicationStatistics.totalConnections + iApplication.getConnectionCounter(i).getCurrent());
                currentApplicationStatistics.totalConnections = currentApplicationStatistics.totalConnections;
            }
            this.uptime = (long)iApplication.getTimeRunningSeconds();
            this.bytesIn = iApplication.getIoPerformanceCounter().getMessagesInBytes();
            this.bytesOut = iApplication.getIoPerformanceCounter().getMessagesOutBytes();
            this.bytesInRate = (long)iApplication.getIoPerformanceCounter().getMessagesInBytesRate();
            this.bytesOutRate = (long)iApplication.getIoPerformanceCounter().getMessagesOutBytesRate();
        }
        if (!RestProperties.getBoolean(Utils.lastIndexOf("sgppVrf|`y\u007fen}KusgtQ{wut|~", 49 - 48))) return true;
        b.info(Severity.valueOf(118 + -56, "]j23'-0e'78i'.8?',#q4<&u") + this.vhost + Severity.valueOf(150 / 34, "$(&") + this.a + Severity.valueOf(23 * 9, "up") + this.toString());
        return true;
    }

    public static CurrentApplicationStatistics getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(67 + 75, "xg\u007fbf"), string);
        hashMap.put(Utils.lastIndexOf("\"45\b&%,", 45 + 54), string2);
        return (CurrentApplicationStatistics)CurrentApplicationStatistics.getObjectFromREST(CurrentApplicationStatistics.getUrl(hashMap, CurrentApplicationStatistics.class), CurrentApplicationStatistics.class, wMSClientSecurity);
    }

    public Long getUptime() {
        return this.uptime;
    }

    public Long getBytesIn() {
        return this.bytesIn;
    }

    public Long getBytesOut() {
        return this.bytesOut;
    }

    public Long getTotalConnections() {
        return this.totalConnections;
    }

    public Map<String, Long> getConnectionCount() {
        return this.connectionCount;
    }

    public void setUptime(Long l) {
        this.uptime = l;
    }

    public void setBytesIn(Long l) {
        this.bytesIn = l;
    }

    public void setBytesOut(Long l) {
        this.bytesOut = l;
    }

    public void setTotalConnections(Long l) {
        this.totalConnections = l;
    }

    public void setConnectionCount(Map<String, Long> map) {
        this.connectionCount = map;
    }

    public long getBytesInRate() {
        return this.bytesInRate;
    }

    public long getBytesOutRate() {
        return this.bytesOutRate;
    }

    public void setBytesInRate(long l) {
        this.bytesInRate = l;
    }

    public void setBytesOutRate(long l) {
        this.bytesOutRate = l;
    }

    public String toString() {
        return Utils.lastIndexOf("\u0011&&'39,\u0018*+04=>4(--\u00171'3!:>\"/>n\u0014%!&:90k", 121 + -39) + this.uptime + Severity.valueOf(784 / 157, "(%d~|lyBb0") + this.bytesIn + Utils.lastIndexOf("(%d~|lyDyy3", 806 / 168) + this.bytesOut + Severity.valueOf(1198 / 254, "(%d~|lyBb_o{u,") + this.bytesInRate + Severity.valueOf(21 * 49, ")&eq}oxCxz]qew.") + this.bytesOutRate + Severity.valueOf(30 - 8, ":7lvnzp^qqndawmjht5") + this.totalConnections + Utils.lastIndexOf("/$fiifli\u007feb`L\u007fd|g)", 571 / 153) + this.connectionCount + "]";
    }
}

