/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.util.ElapsedTimer;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="IncomingStreamMonitoringConfig")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/instances/{instance}/streams/{stream}/monitoring/current", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class CurrentIncomingStreamStatistics
extends ApplicationConfigBase {
    @JsonProperty(value="applicationInstance")
    @XStreamAlias(value="ApplicationInstance")
    protected String instanceName = null;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String streamName = null;
    @JsonProperty(value="uptime")
    @XStreamAlias(value="Uptime")
    protected long uptime = 0L;
    @JsonProperty(value="bytesIn")
    @XStreamAlias(value="BytesIn")
    protected long bytesIn = 0L;
    @JsonProperty(value="bytesOut")
    @XStreamAlias(value="BytesOut")
    protected long bytesOut = 0L;
    @JsonProperty(value="bytesInRate")
    @XStreamAlias(value="BytesInRate")
    protected long bytesInRate = 0L;
    @JsonProperty(value="bytesOutRate")
    @XStreamAlias(value="BytesOutRate")
    protected long bytesOutRate = 0L;
    @JsonProperty(value="totalConnections")
    @XStreamAlias(value="TotalConnections")
    protected long totalConnections = 0L;
    @JsonProperty(value="connectionCount")
    @XStreamAlias(value="ConnectionCount")
    protected Map<String, Integer> connectionCount = new HashMap<String, Integer>();

    public CurrentIncomingStreamStatistics() {
        this.addFieldForKeyMap(Utils.lastIndexOf("`dxxl`lu", 53 * 5), "instanceName");
        this.addFieldForKeyMap(Utils.lastIndexOf("{}xnm`", 69 + -61), "streamName");
    }

    public CurrentIncomingStreamStatistics(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.instanceName = string3;
        this.streamName = string4;
        this.addFieldForKeyMap(Severity.valueOf(523 / 129, "mkusigin"), "instanceName");
        this.addToStringKeyMap(Utils.lastIndexOf(".&:>*\".+", 13 - 38), string3);
        this.addFieldForKeyMap(Utils.lastIndexOf("4<;/*!", -36 - 21), "streamName");
        this.addToStringKeyMap(Utils.lastIndexOf("y\u007f~hob", 76 + -34), string4);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(1305 / 215, "oi{}keoh"));
        this.addToStringKeyMapFromRequest(Utils.lastIndexOf("rvqadk", 85 + 44));
        this.setPathMap();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public long getUptime() {
        return this.uptime;
    }

    public long getBytesIn() {
        return this.bytesIn;
    }

    public long getBytesOut() {
        return this.bytesOut;
    }

    public long getBytesInRate() {
        return this.bytesInRate;
    }

    public long getBytesOutRate() {
        return this.bytesOutRate;
    }

    public long getTotalConnections() {
        return this.totalConnections;
    }

    public Map<String, Integer> getConnectionCount() {
        return this.connectionCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        boolean bl = false;
        this.vhost = this.getStringVariable(Utils.lastIndexOf("d{{fb", 82 + -64));
        this.appName = this.getStringVariable(Severity.valueOf(58 + 35, "<./\u000e /&"));
        this.instanceName = this.getStringVariable(Utils.lastIndexOf("\"\">:.>27", -59 - -6));
        this.streamName = this.getStringVariable(Utils.lastIndexOf("vrumhg", 71 + 62));
        try {
            Class.forName(Severity.valueOf(71 + -6, "\"-.j2)02(d<!>`98>!'z\u001c\u0000\u001f7*."));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhost);
            if (iVHost == null) return bl;
            IApplication iApplication = iVHost.getApplication(this.appName);
            if (iApplication == null) return bl;
            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(this.instanceName);
            if (iApplicationInstance == null) return bl;
            int n = 0;
            this.totalConnections = 0L;
            n = iApplicationInstance.getHTTPStreamerSessionCount(1, this.streamName);
            this.connectionCount.put(Utils.lastIndexOf("\u0014\r\t\u001f\t\b\u0014\u0010\u0010", 29 * 35), n);
            this.totalConnections += (long)n;
            n = iApplicationInstance.getHTTPStreamerSessionCount(4, this.streamName);
            this.connectionCount.put(Utils.lastIndexOf("\u001c\u0002\u0016\u0013\u0011\u0017\u0004\u0010", 52 - -29), n);
            this.totalConnections += (long)n;
            n = iApplicationInstance.getHTTPStreamerSessionCount(2, this.streamName);
            this.connectionCount.put(Severity.valueOf(60 + 124, "KXTQSN["), n);
            this.totalConnections += (long)n;
            n = iApplicationInstance.getHTTPStreamerSessionCount(0, this.streamName);
            this.connectionCount.put(Severity.valueOf(-28 - -53, "JWTSIV"), n);
            this.totalConnections += (long)n;
            n = iApplicationInstance.getPlayStreamCount(this.streamName);
            this.connectionCount.put(Severity.valueOf(45 - 43, "PWIU"), n);
            this.totalConnections += (long)n;
            n = iApplicationInstance.getRTPSessionCount(this.streamName);
            this.connectionCount.put(Utils.lastIndexOf("_Z_", 49 * 61), n);
            this.totalConnections += (long)n;
            MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
            if (mediaStreamMap == null) return true;
            IMediaStream iMediaStream = mediaStreamMap.getStream(this.streamName);
            if (iMediaStream == null) return true;
            this.bytesIn = iMediaStream.getMediaIOPerformance().getMessagesInBytes();
            this.bytesInRate = (long)iMediaStream.getMediaIOPerformance().getMessagesInBytesRate();
            ElapsedTimer elapsedTimer = iMediaStream.getElapsedTime();
            if (elapsedTimer != null) {
                this.uptime = (long)elapsedTimer.getTimeSeconds();
            }
            Iterator iterator = mediaStreamMap.getStreams().iterator();
            while (true) {
                IMediaStream iMediaStream2;
                if (iterator.hasNext()) {
                    iMediaStream2 = (IMediaStream)iterator.next();
                    if (!iMediaStream2.getName().equals(this.streamName) || !iMediaStream2.isPlay()) continue;
                } else {
                    ConfigBase.log.debug((Object)(Utils.lastIndexOf("\u001c530&*1\u000f)+&'\"\"*\u001d;\"43>\u0007!7#1*.2?.d3o`fLfocd|!#", 49 * 15) + this.streamName + Severity.valueOf(924 / 133, "*'ag0") + this.bytesIn + "/" + this.bytesInRate + Severity.valueOf(795 / 245, "/$jss2") + this.bytesOut + "/" + this.bytesOutRate));
                    return true;
                }
                this.bytesOut += iMediaStream2.getMediaIOPerformance().getMessagesOutBytes();
                this.bytesOutRate += (long)iMediaStream2.getMediaIOPerformance().getMessagesOutBytesRate();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ConfigBase.log.error((Object)(Severity.valueOf(161 / 40, "Gptumg~Bbnaby\u007fu@`gsvuJnzhtmkibq9$iiflFhainz'9+2") + classNotFoundException));
            return bl;
        }
    }

    public static CurrentIncomingStreamStatistics getObjectFromREST(String string, String string2, String string3, String string4, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(54 - 59, "-42-+"), string);
        hashMap.put(Utils.lastIndexOf("6()\u0014:18", 92 + 27), string2);
        hashMap.put(Severity.valueOf(31 * 33, "6nrvbjfc"), string3);
        hashMap.put(Utils.lastIndexOf("wqtbid", 86 + 46), string4);
        return (CurrentIncomingStreamStatistics)CurrentIncomingStreamStatistics.getObjectFromREST(CurrentIncomingStreamStatistics.getUrl(hashMap, CurrentIncomingStreamStatistics.class), CurrentIncomingStreamStatistics.class, wMSClientSecurity);
    }
}

