/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.sun.management.OperatingSystemMXBean;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.server.Server;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="CurrentMachineStatistics")
@WMSConfig(restLocation="/v1/{server}/monitoring", restVerbs="GET", xmlFilename="")
public class CurrentMachineStatistics
extends ConfigBase {
    private static final Pattern a = Pattern.compile(Severity.valueOf(84 + 43, "w[1/:Y./[{\"gbb"));
    private static final Pattern b = Pattern.compile(Utils.lastIndexOf("-]7%0W %7&T <+N?<", 49 + 84));
    private static final Pattern c = Pattern.compile(Severity.valueOf(1047 / 186, "-]7%0W %Q}$tpk"));
    @JsonProperty(value="serverUptime")
    @XStreamAlias(value="ServerUptime")
    private long d;
    @JsonProperty(value="cpuIdle")
    @XStreamAlias(value="CpuIdle")
    protected Integer cpuIdle;
    @JsonProperty(value="cpuUser")
    @XStreamAlias(value="CpuUser")
    protected Integer cpuUser;
    @JsonProperty(value="cpuSystem")
    @XStreamAlias(value="CpuSystem")
    protected Integer cpuSystem;
    @JsonProperty(value="memoryFree")
    @XStreamAlias(value="MemoryFree")
    protected Long memoryFree;
    @JsonProperty(value="memoryUsed")
    @XStreamAlias(value="MemoryUsed")
    protected Long memoryUsed;
    @JsonProperty(value="heapFree")
    @XStreamAlias(value="HeapFree")
    protected Long heapFree;
    @JsonProperty(value="heapUsed")
    @XStreamAlias(value="HeapUsed")
    protected Long heapUsed;
    @JsonProperty(value="diskFree")
    @XStreamAlias(value="DiskFree")
    protected Long diskFree;
    @JsonProperty(value="diskUsed")
    @XStreamAlias(value="DiskUsed")
    protected Long diskUsed;
    @JsonProperty(value="connectionCount")
    @XStreamAlias(value="ConnectionCount")
    protected Long connectionCount;
    private static final Pattern e = Pattern.compile(Severity.valueOf(48 - 34, "{\u007fLb9;:?)>4Ei04F.29\\)*$pubzz5'P~%c\u007fpv3ucsey~\u007fh#'>7\u001bqoz\u0019n\u001ai\u0013ygr\u0011\u0016~bi\f{\u007fk\t%|p\u0002jve\u0000u\u0003n\u001arn}\u0018\u001dwep\u0017b`r\u0012<{y\tcyl\u000b|\u0004w\u0001kqd\u0003\u00040,;^-"));
    private static final WMSLogger f = WMSLoggerFactory.getLogger(CurrentMachineStatistics.class);
    private static int g = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    private static long h = 0L;
    private static long i = 0L;

    public CurrentMachineStatistics() {
        this.initUrl();
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Severity.valueOf(94 + 51, "Rs}zzb7kxl~<|p?aqromfgsafd+\u007fyo{ybfzw"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        if (RestProperties.getBoolean(Severity.valueOf(1183 / 246, "v`us[}k\u007fe~zfsbVvv`qRvxxwyy"))) {
            f.info(Utils.lastIndexOf("V`rrzgcek-mzbcw}`5{v{qsuy=mkaukpplet", 523 / 111));
        }
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.cpuSystem = 0;
        this.cpuUser = (int)(this.getCpuUsage() * 100.0 / (double)operatingSystemMXBean.getAvailableProcessors());
        this.cpuIdle = 100 - this.cpuSystem - this.cpuUser;
        this.memoryFree = ((OperatingSystemMXBean)operatingSystemMXBean).getFreePhysicalMemorySize();
        this.memoryUsed = ((OperatingSystemMXBean)operatingSystemMXBean).getTotalPhysicalMemorySize() - this.memoryFree;
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.heapUsed = memoryMXBean.getHeapMemoryUsage().getUsed();
        this.heapFree = memoryMXBean.getHeapMemoryUsage().getMax() - this.heapUsed;
        long l = 0L;
        long l2 = 0L;
        Server server = File.listRoots();
        int n = ((File[])server).length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.diskFree = l2;
                this.diskUsed = l - l2;
                server = Server.getInstance();
                this.connectionCount = server.getConnectionCounter().getCurrent();
                this.d = (long)server.getTimeRunningSeconds();
                if (!RestProperties.getBoolean(Utils.lastIndexOf("xn\u007fy]{qe{``|ud\\|xn{Xp~\"-''", 96 + -54))) return true;
                f.info(Utils.lastIndexOf("\n?9>( ;p<30<<82x*.:(4-+ibq9$", 49 * 57) + this.toString());
                return true;
            }
            File file = server[n2];
            l += file.getTotalSpace();
            l2 += file.getFreeSpace();
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getSystemUptime() throws Exception {
        Matcher matcher;
        Process process;
        BufferedReader bufferedReader;
        String string;
        long l;
        block9: {
            String string2;
            block10: {
                String string3;
                BufferedReader bufferedReader2;
                block8: {
                    block7: {
                        l = 0L;
                        try {
                            string2 = System.getProperty(Severity.valueOf(99 + 19, "9$v7;69")).toLowerCase();
                            if (!string2.contains(Severity.valueOf(846 / 245, "tmk"))) break block7;
                            Process process2 = Runtime.getRuntime().exec(Severity.valueOf(224 / 40, "kcs(z~jx~.|bg"));
                            bufferedReader2 = new BufferedReader(new InputStreamReader(process2.getInputStream()));
                            break block8;
                        }
                        catch (Exception exception) {
                            return l;
                        }
                    }
                    if (string2.contains(Severity.valueOf(25 - -8, "lc`")) || string2.contains(Utils.lastIndexOf("?;+", 45 - 60))) break block9;
                    break block10;
                }
                do {
                    if ((string3 = bufferedReader2.readLine()) == null) return l;
                } while (!string3.startsWith(Severity.valueOf(787 / 140, "Vrf|`y\u007fen}/cx|pq5")));
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
                Date date = dateFormat.parse(string3.substring(Utils.lastIndexOf("L4 6*71/$;i9\"\".+", 29 * 11).length()));
                return System.currentTimeMillis() - date.getTime();
            }
            if (!string2.contains(Utils.lastIndexOf("hrp", 706 / 106))) {
                if (!string2.contains(Severity.valueOf(51 * 9, "*%5"))) return l;
            }
        }
        if ((string = (bufferedReader = new BufferedReader(new InputStreamReader((process = Runtime.getRuntime().exec(Severity.valueOf(13 * 61, "ljoup{"))).getInputStream()))).readLine()) == null) return l;
        Matcher matcher2 = e.matcher(string);
        if (!matcher2.find()) return l;
        String string4 = matcher2.group(1);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (string4.contains(Severity.valueOf(21 * 11, "#)0")) && (matcher = c.matcher(string4)).find()) {
            string5 = matcher.group(1);
        }
        if (string4.contains(":") && (matcher = b.matcher(string4)).find()) {
            string6 = matcher.group(1);
            string7 = matcher.group(2);
        }
        if (string4.contains(Severity.valueOf(86 + 67, "tsu")) && (matcher = a.matcher(string4)).find()) {
            string7 = matcher.group(1);
        }
        int n = string5 != null ? Integer.parseInt(string5) : 0;
        int n2 = string6 != null ? Integer.parseInt(string6) : 0;
        int n3 = string7 != null ? Integer.parseInt(string7) : 0;
        return n3 * 60000 + n2 * 60000 * 60 + n * 60000 * 60 * 24;
    }

    public static CurrentMachineStatistics getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        HashMap hashMap = new HashMap();
        return (CurrentMachineStatistics)CurrentMachineStatistics.getObjectFromREST(CurrentMachineStatistics.getUrl(CurrentMachineStatistics.class), CurrentMachineStatistics.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized double getCpuUsage() {
        if (h == 0L) {
            this.a();
            return 0.0;
        }
        long l = System.nanoTime();
        long l2 = 0L;
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
            l2 = ((OperatingSystemMXBean)operatingSystemMXBean).getProcessCpuTime();
        }
        double d = (double)(l2 - i) / (double)(l - h);
        h = l;
        i = l2;
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void a() {
        h = System.nanoTime();
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (!(operatingSystemMXBean instanceof OperatingSystemMXBean)) {
            return;
        }
        i = ((OperatingSystemMXBean)operatingSystemMXBean).getProcessCpuTime();
    }

    public Integer getCpuIdle() {
        return this.cpuIdle;
    }

    public Integer getCpuUser() {
        return this.cpuUser;
    }

    public Integer getCpuSystem() {
        return this.cpuSystem;
    }

    public Long getMemoryFree() {
        return this.memoryFree;
    }

    public Long getMemoryUsed() {
        return this.memoryUsed;
    }

    public Long getDiskFree() {
        return this.diskFree;
    }

    public Long getDiskUsed() {
        return this.diskUsed;
    }

    public void setCpuIdle(Integer n) {
        this.cpuIdle = n;
    }

    public void setCpuUser(Integer n) {
        this.cpuUser = n;
    }

    public void setCpuSystem(Integer n) {
        this.cpuSystem = n;
    }

    public void setMemoryFree(Long l) {
        this.memoryFree = l;
    }

    public void setMemoryUsed(Long l) {
        this.memoryUsed = l;
    }

    public void setDiskFree(Long l) {
        this.diskFree = l;
    }

    public void setDiskUsed(Long l) {
        this.diskUsed = l;
    }

    public Long getConnectionCount() {
        return this.connectionCount;
    }

    public void setConnectionCount(Long l) {
        this.connectionCount = l;
    }

    public Long getHeapFree() {
        return this.heapFree;
    }

    public Long getHeapUsed() {
        return this.heapUsed;
    }

    public void setHeapFree(Long l) {
        this.heapFree = l;
    }

    public void setHeapUsed(Long l) {
        this.heapUsed = l;
    }

    public long getServerUptime() {
        return this.d;
    }

    public void setServerUptime(long l) {
        this.d = l;
    }

    public String toString() {
        return Utils.lastIndexOf("^km2$,7\t$%/!'/\u00188,:&#%;0'u\r$=+,>.\b.+),'~", 3 * 63) + this.d + Severity.valueOf(384 / 63, "*'ky\u007fBhak2") + this.cpuIdle + Utils.lastIndexOf("*'ky\u007f^\u007fh|2", 598 / 96) + this.cpuUser + Utils.lastIndexOf(")&jmdeyuK|ju,", 1038 / 179) + this.memoryFree + Severity.valueOf(789 / 248, "/$hcjg{s^\u007fhj2") + this.memoryUsed + Utils.lastIndexOf("(%nbiyLyih3", 517 / 120) + this.heapFree + Utils.lastIndexOf("+(aoj|X}jt,", 21 + 114) + this.heapUsed + Utils.lastIndexOf(")&cazaM~hk2", 890 / 164) + this.diskFree + Severity.valueOf(1388 / 209, "*'l`y`Y~kk-") + this.diskUsed + Severity.valueOf(33 * 5, ")&dggdnoyg`~R}fza+") + this.connectionCount + "]";
    }
}

