/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="CurrentVHostStatistics")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/monitoring", restVerbs="GET", xmlFilename="")
public class CurrentVHostStatistics
extends ConfigBase {
    @JsonIgnore
    protected String vhost;
    @JsonProperty(value="uptime")
    @XStreamAlias(value="Uptime")
    protected Long uptime;
    @JsonProperty(value="bytesIn")
    @XStreamAlias(value="BytesIn")
    protected Long bytesIn;
    @JsonProperty(value="bytesOut")
    @XStreamAlias(value="BytesOut")
    protected Long bytesOut;
    @JsonProperty(value="totalConnections")
    @XStreamAlias(value="TotalConnections")
    protected Long totalConnections;
    @JsonProperty(value="connectionCount")
    @XStreamAlias(value="ConnectionCount")
    protected Map<String, Long> connectionCount = new HashMap<String, Long>();
    private static final WMSLogger a = WMSLoggerFactory.getLogger(CurrentVHostStatistics.class);

    public CurrentVHostStatistics() {
        String string = Utils.lastIndexOf("apvio", 37 * 43);
        this.addFieldForKeyMap(string, string);
    }

    public CurrentVHostStatistics(String string) {
        this.vhost = string;
        String string2 = Severity.valueOf(11 - -51, "hw/26");
        this.addFieldForKeyMap(string2, string2, true);
        this.addToStringKeyMap(Utils.lastIndexOf("\u007fbd\u007fy", -6 - -15), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(23 * 47, "ortoi"));
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Severity.valueOf(23 * 39, "Bcmjjr'{h|n,l`/qab\u007f}vwcqvt;oi\u007fkirvjg"));
    }

    @Override
    protected boolean exists() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        IVHost iVHost;
        this.vhost = this.getStringVariable(Utils.lastIndexOf("tkkvr", -9 - -43));
        if (RestProperties.getBoolean(Utils.lastIndexOf("7#4<\u001a>*8$=;92!\u001717#0\u001d7;908:", 25 * 45))) {
            a.info(Utils.lastIndexOf("Qaqsuf`dl,n{}bt|g4xscjpyh<{qm ", 354 / 94) + this.vhost);
        }
        if ((iVHost = VHostSingleton.getInstance((String)this.vhost)) == null) {
            return false;
        }
        this.connectionCount.put(Utils.lastIndexOf("GPVBZ]CEC", 1168 / 244), iVHost.getConnectionCounter(2).getCurrent());
        this.connectionCount.put(Severity.valueOf(42 + 58, "\u0000\u0013\u0014\u0004\u0000\u001c\u0004\u0000\u001f"), iVHost.getConnectionCounter(7).getCurrent());
        this.connectionCount.put(Utils.lastIndexOf("\u001a\b\u001c\u001d\u001f\u001d\u000e\u0016", 19 + 68), iVHost.getConnectionCounter(6).getCurrent());
        this.connectionCount.put(Severity.valueOf(24 + 1, "J[UVRMZ"), iVHost.getConnectionCounter(4).getCurrent());
        this.connectionCount.put(Severity.valueOf(750 / 164, "WHIH\\A"), iVHost.getConnectionCounter(3).getCurrent());
        this.connectionCount.put(Severity.valueOf(25 + 34, "LY_S"), iVHost.getConnectionCounter(5).getCurrent());
        this.connectionCount.put(Utils.lastIndexOf("QPHV", 410 / 112), iVHost.getConnectionCounter(0).getCurrent());
        this.connectionCount.put(Utils.lastIndexOf("BEB", 49 - 33), iVHost.getConnectionCounter(1).getCurrent());
        this.totalConnections = 0L;
        int n = 0;
        while (true) {
            if (n >= 8) {
                this.uptime = (long)iVHost.getTimeRunningSeconds();
                this.bytesIn = iVHost.getIoPerformanceCounter().getMessagesInBytes();
                this.bytesOut = iVHost.getIoPerformanceCounter().getMessagesOutBytes();
                if (!RestProperties.getBoolean(Severity.valueOf(41 * 31, "%=*.\b(<*6suk`wAce}nOemobjt"))) return true;
                a.info(Utils.lastIndexOf("Erz{oex-xg\u007fbf3ypbeqzi!<", 1217 / 185) + this.toString());
                return true;
            }
            CurrentVHostStatistics currentVHostStatistics = this;
            Long.valueOf(currentVHostStatistics.totalConnections + iVHost.getConnectionCounter(n).getCurrent());
            currentVHostStatistics.totalConnections = currentVHostStatistics.totalConnections;
            ++n;
        }
    }

    public static CurrentVHostStatistics getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (CurrentVHostStatistics)CurrentVHostStatistics.getObjectFromREST(CurrentVHostStatistics.getUrl(Severity.valueOf(23 * 33, "!06)/"), string, CurrentVHostStatistics.class), CurrentVHostStatistics.class, wMSClientSecurity);
    }

    public void setUptime(Long l) {
        this.uptime = l;
    }

    public Long getUptime() {
        return this.uptime;
    }

    public Long getBytesIn() {
        return this.bytesIn;
    }

    public Long getBytesOut() {
        return this.bytesOut;
    }

    public Map<String, Long> getConnectionCount() {
        return this.connectionCount;
    }

    public Long getTotalConnections() {
        return this.totalConnections;
    }

    public void setTotalConnections(Long l) {
        this.totalConnections = l;
    }

    public void setBytesIn(Long l) {
        this.bytesIn = l;
    }

    public void setBytesOut(Long l) {
        this.bytesOut = l;
    }

    public void setConnectionCount(Map<String, Long> map) {
        this.connectionCount = map;
    }

    public String toString() {
        return Utils.lastIndexOf("Vcej|toJUql4\u00126\"0,53!*9k\u0017;& #%o", 59 + 122) + this.vhost + Severity.valueOf(37 + 118, "7<hnkilg>") + this.uptime + Utils.lastIndexOf("85tnl|iRr ", 24 + 28) + this.bytesIn + Severity.valueOf(19 * 39, "if%1=/8\u00038:r") + this.bytesOut + Utils.lastIndexOf("3 umweiEhfgohxdaac,", 47 * 17) + this.totalConnections + Utils.lastIndexOf("yv4774>?)70.\u0002-6*1{", -47 - -4) + this.connectionCount + "]";
    }
}

