/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.stats.HistoricServerStatistics;
import com.wowza.wms.rest.stats.HistoricalStatistics;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.entry.StatsEntryApplication;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Stream")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/applications/{appName}/monitoring/historic", restVerbs="GET", xmlFilename="Application.xml")
public class HistoricApplicationStatistics
extends HistoricalStatistics<StatsEntryApplication> {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricApplicationStatistics.class);

    public HistoricApplicationStatistics() {
        String string = Utils.lastIndexOf("snh{}", 1320 / 240);
        this.addFieldForKeyMap(string, string, true);
        String string2 = Severity.valueOf(5 * 7, "btuHfel");
        this.addFieldForKeyMap(string2, string2, true);
    }

    public HistoricApplicationStatistics(String string, String string2) {
        super(string, string2);
        this.vhost = string;
        this.appName = string2;
        String string3 = Utils.lastIndexOf("/24/)", 41 * 49);
        this.addFieldForKeyMap(string3, string3, true);
        this.addToStringKeyMap(Severity.valueOf(119 + -74, "{f`ce"), string);
        String string4 = Severity.valueOf(31 + -8, "vhiTzqx");
        this.addFieldForKeyMap(string4, string4, true);
        this.addToStringKeyMap(Severity.valueOf(530 / 90, "dvwFhgn"), string2);
        this.initUrl();
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Severity.valueOf(45 * 29, "Z{urrj?s`tf$dh'iyzgeno{y~|3gawcqjnr\u007f"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoricApplicationStatistics getObjectFromREST(String string, String string2, DateTime dateTime, DateTime dateTime2, WMSClientSecurity wMSClientSecurity) {
        if (RestProperties.getBoolean(Severity.valueOf(88 + 6, ",:35\u00117%1/4< )8\b(,:7\u0014<26933"))) {
            a.info(String.format(Utils.lastIndexOf("\u00024&!=0 >6>z-42-+ $q#euvkajk\u007feb`/5b2``tbd8\u007fhtq=;l um#!v", 62 - -50), string, string2, dateTime, dateTime2));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.lastIndexOf("nquhh", 44 - -12), string);
        hashMap.put(Utils.lastIndexOf("iyzEm`k", 58 - 18), string2);
        String string3 = HistoricApplicationStatistics.getUrl(hashMap, HistoricApplicationStatistics.class);
        try {
            String string4 = URLEncoder.encode(dateTime.toString(HistoricalStatistics.DATE_FORMATTER), Severity.valueOf(18 + 13, "JTG/;"));
            String string5 = URLEncoder.encode(dateTime2.toString(HistoricalStatistics.DATE_FORMATTER), Utils.lastIndexOf("\b\n\u0019-9", 14 + 111));
            string3 = string3 + String.format(Severity.valueOf(-30 - -11, "rk<mt!uq&kr+"), Utils.lastIndexOf("$,8(/", -53 - -12), string4, Utils.lastIndexOf("39<", 53 + 33), string5);
            return (HistoricApplicationStatistics)HistoricApplicationStatistics.getObjectFromREST(string3, HistoricApplicationStatistics.class, wMSClientSecurity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WMSLogger.getLogger(HistoricServerStatistics.class).warn((Object)Utils.lastIndexOf("\u001a>00?1u\"8x<4839;\u007f4.b\u0016\u0010\u0003k\u007f", 29 + 50), (Throwable)unsupportedEncodingException);
            return new HistoricApplicationStatistics();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IStatsDatabase<StatsEntryApplication> getDatabase() {
        ArrayList arrayList = new ArrayList();
        IStatsManager iStatsManager = StatsManager.getInstance();
        if (iStatsManager == null) {
            a.warn(Utils.lastIndexOf("Lt`vpIdhfolx+ec}{q\u007fqv4{yc8xlzuq\u007f},$", 33 * 63));
            return null;
        }
        IStatsDatabaseManager iStatsDatabaseManager = iStatsManager.getStatsDatabaseManager();
        if (iStatsDatabaseManager == null) {
            a.warn(Utils.lastIndexOf("RvbpvKffhmn~-jndpprgp6~vjnzr~{?nnv#esgndhhgi", 29 * 53));
            return null;
        }
        IStatsDatabase iStatsDatabase = iStatsDatabaseManager.applicationGetDatabase(this.vhost, this.appName);
        if (iStatsDatabase == null) {
            a.warn(Severity.valueOf(2 - 53, "\u001e:.$\"\u001f2:412*y;+,17<!5+,*e\"&<(')->+o9?!'5;52x75/|<(>imcah`"));
            return null;
        }
        iStatsDatabase.open();
        return iStatsDatabase;
    }
}

