/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.stats.HistoricServerStatistics;
import com.wowza.wms.rest.stats.HistoricalStatistics;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.entry.StatsEntryMachine;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="HistoricMachineStatistics")
@WMSConfig(restLocation="/v1/machine/monitoring/historic", restVerbs="GET", xmlFilename="Application.xml")
public class HistoricMachineStatistics
extends HistoricalStatistics<StatsEntryMachine> {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricMachineStatistics.class);

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Utils.lastIndexOf("Effge\u007f,~oyu1s}4tfgtpyzhtqq rvbplusaj", 7 - 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoricMachineStatistics getObjectFromREST(DateTime dateTime, DateTime dateTime2, WMSClientSecurity wMSClientSecurity) {
        if (RestProperties.getBoolean(Utils.lastIndexOf("1!62\u0014<(>\"?9',#\u001571!2\u001399;6>8", 59 * 25))) {
            a.info(String.format(Utils.lastIndexOf("Tb|{cnzd`h0|sp||xr8jnzhn>yrno#!v&sg)/x", 585 / 87), dateTime, dateTime2));
        }
        String string = HistoricMachineStatistics.getUrl(HistoricMachineStatistics.class);
        try {
            String string2 = URLEncoder.encode(dateTime.toString(HistoricalStatistics.DATE_FORMATTER), Severity.valueOf(55 * 39, "\u0014\u0016\u0005i}"));
            String string3 = URLEncoder.encode(dateTime2.toString(HistoricalStatistics.DATE_FORMATTER), Utils.lastIndexOf("\u0003\u0003\u001etb", -8 - 34));
            string = string + String.format(Utils.lastIndexOf("; u:-z,.\u007f0+|", 49 + -45), Utils.lastIndexOf("\u007fyo}d", 102 + -58), string2, Utils.lastIndexOf("<4?", 39 - 46), string3);
            return (HistoricMachineStatistics)HistoricMachineStatistics.getObjectFromREST(string, HistoricMachineStatistics.class, wMSClientSecurity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WMSLogger.getLogger(HistoricServerStatistics.class).warn((Object)Severity.valueOf(47 + -24, "Bvxxwy=jp dl`kac'|f*^XK#7"), (Throwable)unsupportedEncodingException);
            return new HistoricMachineStatistics();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IStatsDatabase<StatsEntryMachine> getDatabase() {
        IStatsManager iStatsManager = StatsManager.getInstance();
        if (iStatsManager == null) {
            a.warn(Utils.lastIndexOf("Vrf|zGjblijb1{}gawy{|:usi>~v`koegjb", 99 + 34));
            return null;
        }
        IStatsDatabaseManager iStatsDatabaseManager = iStatsManager.getStatsDatabaseManager();
        if (iStatsDatabaseManager == null) {
            a.warn(Severity.valueOf(-34 - 14, "\u0003%3''\u0011\"6:8)>\u0011<0>'$0c-+53)').l#!;p0$2=9754<"));
            return null;
        }
        IStatsDatabase iStatsDatabase = iStatsDatabaseManager.machineGetDatabase();
        if (iStatsDatabase == null) {
            a.warn(Severity.valueOf(-11 - 46, "\u0014-;<.>m*.$002'0v97-z:*<73!#.&"));
            return null;
        }
        iStatsDatabase.open();
        return iStatsDatabase;
    }
}

