/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.stats.HistoricalStatistics;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.entry.StatsEntryServer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="HistoricServerStatistics")
@WMSConfig(restLocation="/v1/{server}/monitoring/historic", restVerbs="GET", xmlFilename="Application.xml")
public class HistoricServerStatistics
extends HistoricalStatistics<StatsEntryServer> {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricServerStatistics.class);

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Utils.lastIndexOf("\u0018=300t!qbr`&ff)k{|aglqe{|z5ecymshht}", 37 * 31));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoricServerStatistics getObjectFromREST(DateTime dateTime, DateTime dateTime2, WMSClientSecurity wMSClientSecurity) {
        if (RestProperties.getBoolean(Severity.valueOf(77 + -23, "drkmIo}iwl4(!0\u0000 $2/\f$*.!++"))) {
            a.info(String.format(Severity.valueOf(34 - -24, "H~howz6(,$d6#5>,8k?9/;#q4!;8vr+y.4|x-"), dateTime, dateTime2));
        }
        String string = HistoricServerStatistics.getUrl(HistoricServerStatistics.class);
        try {
            String string2 = URLEncoder.encode(dateTime.toString(HistoricalStatistics.DATE_FORMATTER), Severity.valueOf(91 + 18, "\u0018\u001a\t}i"));
            String string3 = URLEncoder.encode(dateTime2.toString(HistoricalStatistics.DATE_FORMATTER), Utils.lastIndexOf("\u0000\u0002\u0011ua", -34 - -23));
            string = string + String.format(Utils.lastIndexOf(":#t5,y-)~3*c", 1402 / 251), Severity.valueOf(278 / 66, "wqgu|"), string2, Severity.valueOf(281 / 47, "`hc"), string3);
            return (HistoricServerStatistics)HistoricServerStatistics.getObjectFromREST(string, HistoricServerStatistics.class, wMSClientSecurity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WMSLogger.getLogger(HistoricServerStatistics.class).warn((Object)Utils.lastIndexOf("\u0015/#!( f3'i/%/\"**p%=s\u0001\u0001\u0010z`", -16 - 48), (Throwable)unsupportedEncodingException);
            return new HistoricServerStatistics();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IStatsDatabase<StatsEntryServer> getDatabase() {
        IStatsManager iStatsManager = StatsManager.getInstance();
        if (iStatsManager == null) {
            a.warn(Utils.lastIndexOf("GawckT{u}z{m hlppdhdm)ddx-oyqx~rvys", -15 + 35));
            return null;
        }
        IStatsDatabaseManager iStatsDatabaseManager = iStatsManager.getStatsDatabaseManager();
        if (iStatsDatabaseManager == null) {
            a.warn(Severity.valueOf(27 + 125, "Km{ooYj~b`qfIdhfolx+ec}{q\u007fqv4{yc8xlzuq\u007f},$"));
            return null;
        }
        IStatsDatabase iStatsDatabase = iStatsDatabaseManager.serverGetDatabase();
        if (iStatsDatabase == null) {
            a.warn(Utils.lastIndexOf("\u0016#5>,8k(,:.20!6t;9#x8,:51?=,$", 63 - -6));
            return null;
        }
        iStatsDatabase.open();
        return iStatsDatabase;
    }
}

