/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.stats.HistoricServerStatistics;
import com.wowza.wms.rest.stats.HistoricalStatistics;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.entry.StatsEntryVHost;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="HistoricVHostStatistics")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/monitoring/historic", restVerbs="GET", xmlFilename="Application.xml")
public class HistoricVHostStatistics
extends HistoricalStatistics<StatsEntryVHost> {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricVHostStatistics.class);

    public HistoricVHostStatistics() {
        String string = Utils.lastIndexOf("d{{fb", 46 + 100);
        this.addFieldForKeyMap(string, string, true);
    }

    public HistoricVHostStatistics(String string) {
        super(string);
        this.vhost = string;
        String string2 = Severity.valueOf(33 * 25, "ortoi");
        this.addFieldForKeyMap(string2, string2, true);
        this.addToStringKeyMap(Utils.lastIndexOf("uljus", 276 / 84), string);
        this.initUrl();
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Severity.valueOf(115 + 91, "\r.>?='t&7!=y;5|<./,(!\"0,))h:>*8$=;92"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoricVHostStatistics getObjectFromREST(String string, DateTime dateTime, DateTime dateTime2, WMSClientSecurity wMSClientSecurity) {
        if (RestProperties.getBoolean(Utils.lastIndexOf("wct|Z~jxd}{yraWqwcp]w{ypxz", 1380 / 239))) {
            a.info(String.format(Utils.lastIndexOf("@v`g\u007frnpt|<kvpsu\"&w%usi}y+j\u007fab04a3`z62k", -53 - 57), string, dateTime, dateTime2));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.lastIndexOf("kvpsu", -49 - 50), string);
        String string2 = HistoricVHostStatistics.getUrl(hashMap, HistoricVHostStatistics.class);
        try {
            String string3 = URLEncoder.encode(dateTime.toString(HistoricalStatistics.DATE_FORMATTER), Utils.lastIndexOf("\u0006\u0000\u0013{o", 36 - -47));
            String string4 = URLEncoder.encode(dateTime2.toString(HistoricalStatistics.DATE_FORMATTER), Utils.lastIndexOf("DFU9-", 21 * 45));
            string2 = string2 + String.format(Severity.valueOf(196 / 57, "<!v;\"{//x1(}"), Utils.lastIndexOf("vrfz}", 53 * 17), string3, Severity.valueOf(35 * 15, "h`k"), string4);
            return (HistoricVHostStatistics)HistoricVHostStatistics.getObjectFromREST(string2, HistoricVHostStatistics.class, wMSClientSecurity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WMSLogger.getLogger(HistoricServerStatistics.class).warn((Object)Utils.lastIndexOf("\u001e\",,#5q&<t0847=?{(2~\n\u0014\u0007o{", 27 - -48), (Throwable)unsupportedEncodingException);
            return new HistoricVHostStatistics();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IStatsDatabase<StatsEntryVHost> getDatabase() {
        IStatsManager iStatsManager = StatsManager.getInstance();
        if (iStatsManager == null) {
            a.warn(Severity.valueOf(57 * 19, "Hh|jl\r ,\"# 4g!'9?-#-*p?='t4 615;908"));
            return null;
        }
        IStatsDatabaseManager iStatsDatabaseManager = iStatsManager.getStatsDatabaseManager();
        if (iStatsDatabaseManager == null) {
            a.warn(Severity.valueOf(5 + 38, "Xxlz|TesqufsZyw{|yo>v.26\"*&#g&&>k-;/&<00?1"));
            return null;
        }
        IStatsDatabase iStatsDatabase = iStatsDatabaseManager.vhostGetDatabase(this.vhost);
        if (iStatsDatabase == null) {
            a.warn(Severity.valueOf(32 + 98, "Qfvscu(mk\u007fmoo|u1||`5waypvz~q{"));
            return null;
        }
        iStatsDatabase.open();
        return iStatsDatabase;
    }
}

