/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.application.ApplicationConfigBase;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.entry.StatsEntry;
import com.wowza.wms.stats.utils.StatsUtilsDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class HistoricalStatistics<T extends StatsEntry>
extends ApplicationConfigBase {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricalStatistics.class);
    public static final String DATE_RANGE_START_PARAM = "start";
    public static final String DATE_RANGE_END_PARAM = "end";
    public static DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)Utils.lastIndexOf("ihkj9X[:|}=O;UV%-,\u0018", -7 - -55));
    public static final Duration ONE_HOUR = new Duration(3600000L);
    public static final Duration FOUR_HOURS = new Duration(14400000L);
    public static final Duration ONE_WEEK = new Duration(604800000L);
    public static final String REST_LOG_STATS_ENABLED = "restStatisticsDebugEnabled";
    @JsonIgnore
    private DateTime b = new DateTime();
    @JsonIgnore
    private DateTime c = this.b.minusDays(1);
    @JsonProperty(value="entries")
    @XStreamAlias(value="Entries")
    private Map<String, List<T>> d = new HashMap<String, List<T>>();

    public HistoricalStatistics() {
        super("", "");
    }

    public HistoricalStatistics(String string) {
        super(string, "");
    }

    public HistoricalStatistics(String string, String string2) {
        super(string, string2);
    }

    public abstract IStatsDatabase<T> getDatabase();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        try {
            Map<String, List<T>> map;
            this.vhost = this.getStringVariable(Severity.valueOf(765 / 119, "pogz~"));
            this.appName = this.getStringVariable(Severity.valueOf(11 - 33, "+;<\u0003/\"5"));
            IStatsDatabase<T> iStatsDatabase = this.getDatabase();
            this.a();
            if (RestProperties.getBoolean(Severity.valueOf(24 - -57, "#7  \u0006\"6,0)/5>-\u001b%#7$\u0001+'%$,."))) {
                a.info(String.format(Utils.lastIndexOf("Jhimcek-}{qea3rgyz8<i;hr>:s!dlv%pogz~+)~.n`a26g", 1217 / 187), this.getStartTime(), this.getEndTime(), this.vhost, this.appName));
            }
            this.d.put(Severity.valueOf(9 * 61, "des}hf"), new ArrayList());
            this.d.put(Utils.lastIndexOf("knf", 967 / 148), new ArrayList());
            this.d.put(Utils.lastIndexOf("`ow", 61 * 17), new ArrayList());
            this.d.put(Utils.lastIndexOf(")?/9-*+", -3 - 21), new ArrayList());
            DateTime dateTime = StatsUtilsDateTime.getNow();
            HistoricalStatistics historicalStatistics = this;
            if (historicalStatistics.rangeContainsSecondsData(historicalStatistics.getStartTime(), this.getEndTime())) {
                if (RestProperties.getBoolean(Utils.lastIndexOf("v`us[}k\u007fe~zfsbVvv`qRvxxwyy", 909 / 224))) {
                    a.info(Severity.valueOf(57 * 59, "Qekab(jeexlgac1`vuy6cqt\u007f;x|j~"));
                }
                HistoricalStatistics historicalStatistics2 = this;
                map = historicalStatistics2.getEntriesForLevel(historicalStatistics2.getStartTime().toDateTime(DateTimeZone.UTC), this.getEndTime().toDateTime(DateTimeZone.UTC), iStatsDatabase, 0);
                this.d.get(Severity.valueOf(777 / 119, "gd||kg")).addAll((Collection)map.get(Severity.valueOf(19 * 47, "<=+u`n")));
                if (RestProperties.getBoolean(Severity.valueOf(37 * 29, "cw``Fbvlpiou~m[%#7$\u0001+'%$,."))) {
                    a.info(String.format(Severity.valueOf(53 * 43, "\u0006,-//lh*o5?&!=0%w9-z)9<2\u007fthof$icqme"), map.get(Severity.valueOf(13 * 33, "lm{ep~")).size()));
                }
            }
            HistoricalStatistics historicalStatistics3 = this;
            if (historicalStatistics3.rangeContainsMinutesData(historicalStatistics3.getStartTime(), this.getEndTime())) {
                HistoricalStatistics historicalStatistics4 = this;
                map = historicalStatistics4.getEntriesForLevel(historicalStatistics4.getStartTime().toDateTime(DateTimeZone.UTC), this.getEndTime().toDateTime(DateTimeZone.UTC), iStatsDatabase, 1);
                this.d.get(Severity.valueOf(5 + 104, " '!")).addAll((Collection)map.get(Utils.lastIndexOf("upt", 42 + 110)));
                this.d.get(Severity.valueOf(-60 - -2, "+&0")).addAll((Collection)map.get(Severity.valueOf(7 * 23, "lc{")));
                this.d.get(Utils.lastIndexOf("$0\":(-.", 111 + 118)).addAll((Collection)map.get(Utils.lastIndexOf("yo\u007fi}z{", 44 + 108)));
                if (RestProperties.getBoolean(Severity.valueOf(5 - 42, ")9.*\f4 6*71/$;\r/)9*\u000b!13>60"))) {
                    a.info(String.format(Severity.valueOf(379 / 91, "Eabbl)/o,h`{bxw`4tb7uptnhx>sewgo"), map.get(Utils.lastIndexOf("+=)?/(5", 32 + 74)).size()));
                }
            } else {
                HistoricalStatistics historicalStatistics5 = this;
                if (historicalStatistics5.rangeContainsHoursData(historicalStatistics5.getStartTime(), this.getEndTime())) {
                    HistoricalStatistics historicalStatistics6 = this;
                    map = historicalStatistics6.getEntriesForLevel(historicalStatistics6.getStartTime().toDateTime(DateTimeZone.UTC), this.getEndTime().toDateTime(DateTimeZone.UTC), iStatsDatabase, 2);
                    this.d.get(Utils.lastIndexOf("`ga", 35 + 106)).addAll((Collection)map.get(Utils.lastIndexOf("fec", 51 * 41)));
                    this.d.get(Severity.valueOf(319 / 59, "hg\u007f")).addAll((Collection)map.get(Utils.lastIndexOf("hg\u007f", 301 / 54)));
                    this.d.get(Utils.lastIndexOf(" 4&6$!\"", 37 * 13)).addAll((Collection)map.get(Utils.lastIndexOf("7!=+;<9", 12 - 22)));
                    if (RestProperties.getBoolean(Utils.lastIndexOf("tb{}Y\u007fmyg|dxq`Pptb\u007f\\tz~q{{", 1291 / 202))) {
                        a.info(String.format(Severity.valueOf(1258 / 196, "Gclln+)i.j~e`zqf6vl9rtio>sewgo"), map.get(Utils.lastIndexOf("}k{m!&'", 120 + 68)).size()));
                    }
                } else {
                    HistoricalStatistics historicalStatistics7 = this;
                    if (historicalStatistics7.rangeContainsDaysData(historicalStatistics7.getStartTime(), this.getEndTime())) {
                        HistoricalStatistics historicalStatistics8 = this;
                        map = historicalStatistics8.getEntriesForLevel(historicalStatistics8.getStartTime().toDateTime(DateTimeZone.UTC), this.getEndTime().toDateTime(DateTimeZone.UTC), iStatsDatabase, 3);
                        this.d.get(Severity.valueOf(15 * 25, ":17")).addAll((Collection)map.get(Severity.valueOf(91 + -50, "dce")));
                        this.d.get(Severity.valueOf(-22 - 50, "uxb")).addAll((Collection)map.get(Utils.lastIndexOf("'*4", 31 - -43)));
                        this.d.get(Utils.lastIndexOf("br`tfol", 672 / 213)).addAll((Collection)map.get(Severity.valueOf(88 + -5, "2\"0$6?<")));
                        if (RestProperties.getBoolean(Severity.valueOf(-54 - -27, "7#4<\u001a>*8$=;92!\u001717#0\u001d7;908:"))) {
                            a.info(String.format(Utils.lastIndexOf("\u00120133x|>{93*-)$1c%1f#)0j');+#", 29 * 47), map.get(Utils.lastIndexOf("dpbzhmn", 945 / 176)).size()));
                        }
                    }
                }
            }
            map = new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    if (t != null) {
                        if (t2 != null) {
                            return t.getDateTime().compareTo((ReadableInstant)t2.getDateTime());
                        }
                    } else {
                        return 1;
                    }
                    return -1;
                }
            };
            Collections.sort(this.d.get(Severity.valueOf(744 / 220, "nmk")), map);
            Collections.sort(this.d.get(Utils.lastIndexOf("ne}", 342 / 105)), map);
            Collections.sort(this.d.get(Severity.valueOf(163 / 54, "br`tfol")), map);
            return true;
        }
        catch (Exception exception) {
            a.error(Severity.valueOf(1375 / 246, "@tug{*lick}qe{}s5ecymshht}l"), (Throwable)exception);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void a() {
        Map<String, String> map = this.getQueryParamMap();
        if (RestProperties.getBoolean(Severity.valueOf(-29 - -61, "rdqwWqgsaz~bo~JjrduVztt{}}"))) {
            a.info(String.format(Utils.lastIndexOf("Drsmdz\u007feci/d~2cuger8}{oyn>:s!cm`%#t", 996 / 172), map.get(Utils.lastIndexOf("ppdts", 665 / 178)), map.get(Severity.valueOf(1372 / 224, "cil"))));
        }
        if (map.containsKey(Severity.valueOf(20 + 106, "-+asv"))) {
            this.c = StatsUtilsDateTime.getNormalizedToSeconds((DateTime)DATE_FORMATTER.parseDateTime(map.get(Utils.lastIndexOf("xxl|{", 23 * 45))));
        }
        if (map.containsKey(Utils.lastIndexOf("rv}", -64 - 41))) {
            this.b = StatsUtilsDateTime.getNormalizedToSeconds((DateTime)DATE_FORMATTER.parseDateTime(map.get(Severity.valueOf(-66 - 1, "xp{"))));
        }
        if (!this.c.isAfter((ReadableInstant)this.b)) return;
        this.b = this.c.plusDays(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean rangeContainsSecondsData(DateTime dateTime, DateTime dateTime2) {
        if (dateTime == null) return false;
        if (dateTime2 == null) return false;
        if (!dateTime.isAfter((ReadableInstant)dateTime2)) {
            DateTime dateTime3;
            DateTime dateTime4 = dateTime3 = new DateTime(DateTimeZone.UTC);
            DateTime dateTime5 = dateTime4.minusSeconds(dateTime4.getSecondOfMinute() % 5).minusHours(12);
            Duration duration = new Duration((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
            if (!dateTime.isAfter((ReadableInstant)dateTime5)) return false;
            if (duration.isShorterThan((ReadableDuration)ONE_HOUR)) return true;
            if (!duration.equals((Object)ONE_HOUR)) return false;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean rangeContainsMinutesData(DateTime dateTime, DateTime dateTime2) {
        if (dateTime == null) return false;
        if (dateTime2 == null) return false;
        if (!dateTime.isAfter((ReadableInstant)dateTime2)) {
            DateTime dateTime3;
            DateTime dateTime4 = dateTime3 = new DateTime(DateTimeZone.UTC);
            DateTime dateTime5 = dateTime4.minusSeconds(dateTime4.getSecondOfMinute() % 5).minusDays(3);
            Duration duration = new Duration((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
            if (!dateTime.isAfter((ReadableInstant)dateTime5)) return false;
            if (duration.isShorterThan((ReadableDuration)FOUR_HOURS)) return true;
            if (!duration.equals((Object)FOUR_HOURS)) return false;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean rangeContainsHoursData(DateTime dateTime, DateTime dateTime2) {
        DateTime dateTime3;
        if (dateTime == null) return false;
        if (dateTime2 == null) return false;
        if (dateTime.isAfter((ReadableInstant)dateTime2)) {
            return false;
        }
        DateTime dateTime4 = dateTime3 = new DateTime(DateTimeZone.UTC);
        DateTime dateTime5 = dateTime4.minusSeconds(dateTime4.getSecondOfMinute() % 5).minusDays(30);
        Duration duration = new Duration((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
        if (!dateTime.isAfter((ReadableInstant)dateTime5)) return false;
        if (duration.isShorterThan((ReadableDuration)ONE_WEEK)) return true;
        if (!duration.equals((Object)ONE_WEEK)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean rangeContainsDaysData(DateTime dateTime, DateTime dateTime2) {
        DateTime dateTime3;
        if (dateTime == null) return false;
        if (dateTime2 == null) return false;
        if (dateTime.isAfter((ReadableInstant)dateTime2)) {
            return false;
        }
        DateTime dateTime4 = dateTime3 = new DateTime(DateTimeZone.UTC);
        DateTime dateTime5 = dateTime4.minusSeconds(dateTime4.getSecondOfMinute() % 5).minusDays(365);
        if (dateTime.isAfter((ReadableInstant)dateTime5)) return true;
        if (!dateTime2.isAfter((ReadableInstant)dateTime5)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map<String, List<T>> getEntriesForLevel(DateTime dateTime, DateTime dateTime2, IStatsDatabase<T> iStatsDatabase, int n) {
        HashMap<String, List<T>> hashMap = new HashMap<String, List<T>>();
        if (iStatsDatabase == null) return hashMap;
        if (dateTime2 == null) return hashMap;
        if (dateTime2.isBefore((ReadableInstant)dateTime)) {
            return hashMap;
        }
        if (n == 0) {
            hashMap.put(Utils.lastIndexOf(")*>>-!", 29 + 43), iStatsDatabase.read(n, 0, dateTime, dateTime2));
            return hashMap;
        }
        hashMap.put(Severity.valueOf(5 - 4, "lkm"), iStatsDatabase.read(n, 0, dateTime, dateTime2));
        hashMap.put(Utils.lastIndexOf("94.", 93 + 119), iStatsDatabase.read(n, 1, dateTime, dateTime2));
        hashMap.put(Severity.valueOf(50 + 13, "~6$0\"# "), iStatsDatabase.read(n, 2, dateTime, dateTime2));
        return hashMap;
    }

    public Map<String, List<T>> getEntries() {
        return this.d;
    }

    public void setEntries(Map<String, List<T>> map) {
        this.d = map;
    }

    public DateTime getEndTime() {
        return this.b;
    }

    public DateTime getStartTime() {
        return this.c;
    }

    public void setEndTime(DateTime dateTime) {
        this.b = dateTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.c = dateTime;
    }
}

