/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.stats;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.database.StatsDatabaseManager;
import java.lang.reflect.Method;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="MonitoringConfig")
@WMSConfig(restLocation="/v1/{server}/monitoringConfig", restVerbs="GET,PUT", xmlFilename="Server.xml")
public class MonitoringConfig
extends ConfigBase {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(MonitoringConfig.class);
    @JsonProperty(value="enable")
    @XStreamAlias(value="Enable")
    @WMSXMLVariable(xpath="/Root/Server/Stats/Enable/text()")
    protected boolean enable = true;
    @JsonProperty(value="debugEnable")
    @XStreamAlias(value="DebugEnable")
    @WMSXMLProperty(root="/Root/Server/Stats", name="statsManagerDebugEnable")
    protected boolean statsManagerDebugEnable = false;
    @JsonProperty(value="databaseDebugEnable")
    @XStreamAlias(value="DatabaseDebugEnable")
    @WMSXMLProperty(root="/Root/Server/Stats", name="statsDatabaseManagerDebugEnable")
    protected boolean statsDatabaseManagerDebugEnable = false;

    public MonitoringConfig() {
        this.initUrl();
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnabled(boolean bl) {
        this.enable = bl;
    }

    public boolean isStatsManagerDebugEnabled() {
        return this.statsManagerDebugEnable;
    }

    public void setStatsManagerDebugEnabled(boolean bl) {
        this.statsManagerDebugEnable = bl;
    }

    public boolean isStatsDatabaseManagerDebugEnabled() {
        return this.statsDatabaseManagerDebugEnable;
    }

    public void setStatsDatabaseManagerDebugEnabled(boolean bl) {
        this.statsDatabaseManagerDebugEnable = bl;
    }

    public static MonitoringConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (MonitoringConfig)MonitoringConfig.getObjectFromREST(MonitoringConfig.getUrl(MonitoringConfig.class), MonitoringConfig.class, wMSClientSecurity);
    }

    @Override
    public boolean exists() {
        boolean bl = super.exists();
        if (!MonitoringConfig.usesCentralConfig()) {
            return bl;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean loadObjectFromFile(String string) {
        boolean bl = false;
        Document document = null;
        if (!MonitoringConfig.usesCentralConfig()) {
            return super.loadObjectFromFile(string);
        }
        try {
            document = MonitoringConfig.getDocumentFromCentralConfig(this.getXMLFilename());
        }
        catch (Exception exception) {
            this.logException(Severity.valueOf(33 * 29, "qq~$\u000e )!&2\u0001:&'\r%!+"), exception);
        }
        catch (SAXParseException sAXParseException) {
            MonitoringConfig.logError(Severity.valueOf(6 + 73, "\u001f1#!::2v\u000f\u0015\u0015z=51;w") + string + Severity.valueOf(39 * 43, "$.") + sAXParseException);
        }
        if (document == null) return bl;
        return this.loadXMLDocument(document, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        WMSResponse wMSResponse = super.saveObject();
        try {
            IStatsDatabaseManager iStatsDatabaseManager;
            Class.forName(Utils.lastIndexOf("\u007frs17.59%k1*;g9?-9=a\u0003%3''\u0018799>?)", 31 - -29));
            IStatsManager iStatsManager = StatsManager.getInstance();
            iStatsManager.setDebugLogging(this.statsManagerDebugEnable);
            if (this.enable) {
                iStatsDatabaseManager = Class.forName(Severity.valueOf(29 - 36, ":56r*1(z`,tiv(tm{|n~#]jbgwa"));
                try {
                    Method method = iStatsDatabaseManager.getMethod(Severity.valueOf(102 + 100, "-.8\u0004 <$0<01"), null);
                    Object object = method.invoke(null, (Object[])null);
                    Method method2 = object.getClass().getMethod(Utils.lastIndexOf("4<(8?\u001f9/;#", -51 - -26), null);
                    method2.invoke(object, (Object[])null);
                }
                catch (Exception exception) {
                    a.warn(Severity.valueOf(4 + 52, "Hkuypxs?35#10,( h:>*8$=;92!s\"<7w\n\u001c\t\u000f|<.6"), (Throwable)exception);
                }
            } else {
                iStatsManager.stopManager();
            }
            Class.forName(Severity.valueOf(528 / 164, "`kh(pg~pj\"zc|>bfr`f8DlxnhX_S~n`efv"));
            iStatsDatabaseManager = StatsDatabaseManager.getInstance();
            iStatsDatabaseManager.setDebugLogging(this.statsDatabaseManagerDebugEnable);
            return wMSResponse;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return wMSResponse;
        }
    }
}

