/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.user;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.group.GroupsConfig;
import com.wowza.wms.rest.user.UsersConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="UserConfig")
@WMSConfig(restLocation="/v1/{server}/users/{user}", restVerbs="GET,PUT,POST,DELETE", xmlFilename="")
public class UserConfig
extends ConfigBase
implements Comparable<UserConfig> {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String name;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    protected String description;
    @JsonProperty(value="groups")
    @XStreamAlias(value="Groups")
    protected List<String> groups = new ArrayList<String>();
    @JsonProperty(value="password")
    @XStreamAlias(value="Password")
    protected String password;
    @XStreamOmitField
    protected String privatePassword;

    public UserConfig() {
        this.addFieldForKeyMap(Severity.valueOf(31 - 50, "8=*\""), "name");
    }

    public UserConfig(String string) {
        this.addFieldForKeyMap(Utils.lastIndexOf("pubz", 496 / 96), "name");
        this.name = string;
        this.addToStringKeyMap(Severity.valueOf(83 + 2, " %2*"), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(61 * 53, "tqfv"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPrivatePassword() {
        return this.privatePassword;
    }

    public void setPrivatePassword(String string) {
        this.privatePassword = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> list) {
        this.groups = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean exists() {
        boolean bl = true;
        if (this.user == null) return bl;
        UserConfig userConfig = UsersConfig.getUser(this.user.getName());
        if (userConfig == null) return bl;
        UserConfig userConfig2 = UsersConfig.getUser(this.getName());
        bl = userConfig2 != null;
        if (userConfig.isMemberOf(Utils.lastIndexOf("ljby\u007f", 61 * 17))) return bl;
        if (userConfig.getName().equals(this.name)) return bl;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        boolean bl = super.loadObject();
        if (!bl) return bl;
        UserConfig userConfig = UsersConfig.getUser(this.name);
        if (userConfig == null) return bl;
        this.groups.addAll(userConfig.getGroups());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public WMSResponse saveObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)Severity.valueOf(1163 / 168, "TB[]*J\\D4/Cpdzzr6Bk|hh&=Wq upb``&t`f}+abjj>12]{a6twtwrhiwq'a!+%+!\";g"));
            wMSResponse.success = true;
            wMSResponse.message = Utils.lastIndexOf("Pescc", 971 / 249);
            return wMSResponse;
        }
        if (!this.exists()) {
            wMSResponse.message = Severity.valueOf(15 * 57, "\u0002+<({82;,`/-7d >.;=");
            return wMSResponse;
        }
        if (this.saveFieldList.contains(Severity.valueOf(680 / 110, "vf{z}d~i"))) return UsersConfig.updateUser(this);
        UserConfig userConfig = UsersConfig.getUser(this.name);
        this.password = userConfig.privatePassword;
        return UsersConfig.updateUser(this);
    }

    @Override
    public WMSResponse saveNewObject() {
        this.privatePassword = this.password;
        return UsersConfig.addUser(this);
    }

    @Override
    public WMSResponse deleteObject() {
        return UsersConfig.removeUser(this.name);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean CanRead(String string) {
        String string2;
        boolean bl = false;
        Iterator<String> iterator = this.groups.iterator();
        do {
            if (!iterator.hasNext()) return bl;
        } while (!(bl |= GroupsConfig.CanRead(string2 = iterator.next(), string)));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean CanWrite(String string) {
        String string2;
        boolean bl = false;
        Iterator<String> iterator = this.groups.iterator();
        do {
            if (!iterator.hasNext()) return bl;
        } while (!(bl |= GroupsConfig.CanWrite(string2 = iterator.next(), string)));
        return bl;
    }

    public boolean isMemberOf(String string) {
        return this.groups.contains(string);
    }

    public boolean removeFromGroup(String string) {
        this.groups.remove(string);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addToGroup(String string) {
        if (this.groups.contains(string)) {
            return true;
        }
        this.groups.add(string);
        return true;
    }

    public static UserConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (UserConfig)UserConfig.getObjectFromREST(UserConfig.getUrl(Utils.lastIndexOf("?8)?", 16 + 58), string, UserConfig.class), UserConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(UserConfig userConfig) {
        return this.name.compareTo(userConfig.getName());
    }
}

