/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.user;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.authentication.file.AuthenticationPasswordFile;
import com.wowza.wms.authentication.file.AuthenticationPasswordFiles;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.user.UserConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;

@JsonAutoDetect(value={JsonMethod.NONE})
@WMSConfig(restLocation="/v1/{server}/users", restVerbs="GET,POST", xmlFilename="")
@XStreamAlias(value="Users")
public class UsersConfig
extends ConfigBase {
    @JsonProperty(value="users")
    @XStreamImplicit(itemFieldName="User")
    public List<UserConfig> users = new ArrayList<UserConfig>();
    @XStreamOmitField
    public static List<UserConfig> staticUsers = null;
    @XStreamOmitField
    protected static long staticVersion;

    public List<UserConfig> getUsers() {
        return this.users;
    }

    public void setUsers(List<UserConfig> list) {
        this.users = list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        UsersConfig.loadAdminPassword();
        this.users.clear();
        if (this.user == null) {
            if (staticUsers == null) return true;
            this.users.addAll(staticUsers);
            return true;
        }
        UserConfig userConfig = UsersConfig.getUser(this.user.getName());
        if (!userConfig.isMemberOf(Severity.valueOf(141 / 38, "b`hoi"))) {
            this.users.add(userConfig);
            return true;
        }
        this.users.addAll(staticUsers);
        return true;
    }

    public static String getUserPasswordFile() {
        return ConfigBase.wowzaBasePath + Utils.lastIndexOf("%(&/e*( '!~!3 '\"9%<", -42 - 16);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean loadAdminPassword() {
        AuthenticationPasswordFile authenticationPasswordFile;
        boolean bl = true;
        String string = UsersConfig.getUserPasswordFile();
        AuthenticationPasswordFiles authenticationPasswordFiles = AuthenticationPasswordFiles.getInstance();
        if (authenticationPasswordFiles != null && (authenticationPasswordFile = authenticationPasswordFiles.getPasswordFile(new File(string))) != null) {
            staticUsers = new ArrayList<UserConfig>();
            Map map = authenticationPasswordFile.getPasswordVals();
            Map map2 = authenticationPasswordFile.getGroupVals();
            for (String string2 : map.keySet()) {
                UserConfig userConfig = new UserConfig();
                userConfig.setName(string2);
                userConfig.setPrivatePassword((String)map.get(string2));
                userConfig.groups.addAll((Collection)map2.get(string2));
                staticUsers.add(userConfig);
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static UserConfig getUser(String string) {
        UserConfig userConfig;
        UserConfig userConfig2 = null;
        UsersConfig.loadAdminPassword();
        Iterator<UserConfig> iterator = staticUsers.iterator();
        do {
            if (!iterator.hasNext()) return userConfig2;
        } while (!(userConfig = iterator.next()).getName().equals(string));
        return userConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMemberOf(String string, String string2) {
        boolean bl = false;
        UserConfig userConfig = UsersConfig.getUser(string);
        if (userConfig == null) return bl;
        return userConfig.isMemberOf(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static WMSResponse updateUser(UserConfig userConfig) {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)Utils.lastIndexOf("^H][0PBZ.5Evnpt|<ESS`i#'),(i8(98;\"<+ykr\u001a:u\"%9=?{/51(`,-'!kfg\u0006&>k/\"#\"9%&::2v4084<9.p", 43 - -1));
            wMSResponse.success = true;
            wMSResponse.message = Utils.lastIndexOf("\u0011\"2 \"", 41 + 25);
            return wMSResponse;
        }
        String string = UsersConfig.getUserPasswordFile();
        AuthenticationPasswordFiles authenticationPasswordFiles = AuthenticationPasswordFiles.getInstance();
        if (authenticationPasswordFiles == null) return wMSResponse;
        AuthenticationPasswordFile authenticationPasswordFile = authenticationPasswordFiles.getPasswordFile(new File(string));
        if (authenticationPasswordFile == null) return wMSResponse;
        if (!authenticationPasswordFile.updateUser(userConfig.getName(), userConfig.getPassword(), userConfig.getGroups())) {
            wMSResponse.message = Severity.valueOf(43 * 57, "Uu|zr|9nt<hn{aug#qvcu");
            return wMSResponse;
        }
        wMSResponse.success = true;
        return wMSResponse;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static WMSResponse removeUser(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)Severity.valueOf(585 / 120, "V@US(HZB6-]nfx|t4M[[81{\u007fqtp1p`qpsjtc!3*Bb-z}quw3g}y`8tu\u007fy3>?\u000e.6c'*+*!=>\"\"*n,80<41&x"));
            wMSResponse.success = true;
            wMSResponse.message = Severity.valueOf(33 * 23, "\u00049/??");
            return wMSResponse;
        }
        String string2 = UsersConfig.getUserPasswordFile();
        AuthenticationPasswordFiles authenticationPasswordFiles = AuthenticationPasswordFiles.getInstance();
        if (authenticationPasswordFiles == null) return wMSResponse;
        AuthenticationPasswordFile authenticationPasswordFile = authenticationPasswordFiles.getPasswordFile(new File(string2));
        if (authenticationPasswordFile == null) return wMSResponse;
        if (authenticationPasswordFile.deleteUser(string)) {
            wMSResponse.success = true;
            return wMSResponse;
        }
        wMSResponse.message = Severity.valueOf(23 * 41, "Iqx~vp5bx8}\u007fwyi{?52'1");
        return wMSResponse;
    }

    public static WMSResponse addUser(UserConfig userConfig) {
        WMSResponse wMSResponse = new WMSResponse();
        if (!ConfigBase.inTradeShowMode) {
            return UsersConfig.addUser2(userConfig);
        }
        ConfigBase.log.warn((Object)Severity.valueOf(27 * 9, "\u0001\u0011\u0006\u0002w\u0019\t\u0013a|\u000e?)ioe#\\HJ' hnfec \u007fqbad{gr>\"9Su<il~dd\"pljq'efnn\"-.A\u007fe2p{x{~lmsu{=}w!/%&7k"));
        wMSResponse.success = true;
        wMSResponse.message = Utils.lastIndexOf("Uf~ln", 1019 / 161);
        return wMSResponse;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static WMSResponse addUser2(UserConfig userConfig) {
        WMSResponse wMSResponse = new WMSResponse();
        String string = UsersConfig.getUserPasswordFile();
        AuthenticationPasswordFiles authenticationPasswordFiles = AuthenticationPasswordFiles.getInstance();
        if (authenticationPasswordFiles == null) return wMSResponse;
        AuthenticationPasswordFile authenticationPasswordFile = authenticationPasswordFiles.getPasswordFile(new File(string));
        if (authenticationPasswordFile == null) return wMSResponse;
        if (authenticationPasswordFile.addUser(userConfig.getName(), userConfig.getPrivatePassword(), userConfig.getGroups())) {
            wMSResponse.success = true;
            return wMSResponse;
        }
        wMSResponse.message = Utils.lastIndexOf("Eeljbl)~d,ljk0davf", 145 / 41);
        return wMSResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        UserConfig userConfig = new UserConfig();
        Representation representation2 = userConfig.post(representation, this.getRequest());
        this.setStatus(userConfig.getStatus());
        if (userConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(userConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static UsersConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        return (UsersConfig)UsersConfig.getObjectFromREST(UsersConfig.getUrl(UsersConfig.class), UsersConfig.class, wMSClientSecurity);
    }
}

