/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhost.startupstreams;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhost.startupstreams.StartupStreamsConfig;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import java.util.HashMap;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="StartupStream")
@WMSConfig(restLocation="/v1/{server}/vhosts/{vhost}/startupstreams/{appName}/{appInstance}/{streamName}", restVerbs="GET,DELETE,POST,PUT", xmlFilename="StartupStreams.xml")
public class StartupStreamConfig
extends ConfigBase
implements Comparable<StartupStreamConfig> {
    @XStreamOmitField
    public String vhostName;
    @JsonProperty(value="streamName")
    @XStreamAlias(value="StreamName")
    @WMSXMLVariable(xpath="/Root/StartupStreams/StartupStream[StreamName='{streamName}' and Application='{appName}/{appInstance}']/StreamName/text()")
    public String streamName;
    @JsonProperty(value="applicationName")
    @XStreamAlias(value="Application")
    public String applicationName;
    @JsonProperty(value="instance")
    @XStreamAlias(value="Instance")
    public String instance;
    @XStreamOmitField
    @WMSXMLVariable(xpath="/Root/StartupStreams/StartupStream[StreamName='{streamName}' and Application='{appName}/{appInstance}']/Application/text()")
    public String applicationInstance;
    @JsonProperty(value="mediaCasterType")
    @XStreamAlias(value="MediaCasterType")
    @WMSXMLVariable(xpath="/Root/StartupStreams/StartupStream[StreamName='{streamName}' and Application='{appName}/{appInstance}']/MediaCasterType/text()")
    public String mediaCasterType;

    public StartupStreamConfig() {
        this.addFieldForKeyMap(Severity.valueOf(-56 - 39, "wjlwq"), "vhostName");
        this.addFieldForKeyMap(Severity.valueOf(43 * 43, "xjkR|sz"), "applicationName");
        this.addFieldForKeyMap(Severity.valueOf(58 - 59, ">pqKmwqgikl"), "instance");
        String string = Utils.lastIndexOf("t|{ojaCobu", 13 * 3);
        this.addFieldForKeyMap(string, string);
    }

    public StartupStreamConfig(String string, String string2, String string3, String string4) {
        this.vhostName = string;
        this.streamName = string4;
        this.addToStringKeyMap(Severity.valueOf(1264 / 182, "pogz~"), string);
        this.addToStringKeyMap(Severity.valueOf(1 - 55, "+;<\u0003/\"5"), string2);
        this.addToStringKeyMap(Utils.lastIndexOf("euvNfz~jbnk", 894 / 221), string3);
        this.addToStringKeyMap(Severity.valueOf(33 + 45, "=;\"43>\u001a4;2"), string4);
        this.initUrl();
        this.addFieldForKeyMap(Severity.valueOf(99 + 75, "xg\u007fbf"), "vhostName");
        String string5 = Severity.valueOf(51 * 11, "bfaqt{Yyt\u007f");
        this.addFieldForKeyMap(string5, string5);
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(5 + 74, "98>!'"));
        this.addToStringKeyMapFromRequest(Utils.lastIndexOf("<./N`of", 49 * 13));
        this.addToStringKeyMapFromRequest(Utils.lastIndexOf("1!\"\u001a:&\"66:?", 87 + 121));
        this.addToStringKeyMapFromRequest(Severity.valueOf(-40 - -30, "%#*<;6\u0012<3:"));
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String string) {
        this.instance = string;
    }

    public String getMediaCasterType() {
        return this.mediaCasterType;
    }

    public void setMediaCasterType(String string) {
        this.mediaCasterType = string;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Utils.lastIndexOf("snh{}", 1352 / 245));
        String string = VHostsConfig.getVHostDir(this.vhostName);
        return string + Severity.valueOf(1424 / 205, ")dggl");
    }

    @Override
    public String getFilename() {
        return this.getBaseDir() + "/" + this.getXMLFilename();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        boolean bl = super.loadXMLNode(node, string);
        if (!bl) return bl;
        if (this.applicationInstance == null) return bl;
        String[] stringArray = this.applicationInstance.split("/");
        if (stringArray.length > 1) {
            this.applicationName = stringArray[0];
            this.instance = stringArray[1];
        }
        this.addToStringKeyMap(Severity.valueOf(17 + 9, "{klS\u007fre"), this.applicationName);
        this.addToStringKeyMap(Utils.lastIndexOf("pbc]{ecywy~", 29 * 5), this.instance);
        StartupStreamConfig startupStreamConfig = this;
        String string2 = startupStreamConfig.resolveVariables(startupStreamConfig.restURI, true);
        this.setRestURI(string2);
        return bl;
    }

    @Override
    protected boolean updateXML(Document document) {
        this.applicationInstance = this.applicationName + "/" + this.instance;
        return super.updateXML(document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean exists() {
        boolean bl = false;
        bl = false;
        StartupStreamsConfig startupStreamsConfig = new StartupStreamsConfig(this.vhostName);
        bl = startupStreamsConfig.loadObject();
        if (!bl) return bl;
        bl = false;
        if (startupStreamsConfig.streams == null) return bl;
        return startupStreamsConfig.streams.contains(this);
    }

    @Override
    protected String getParentUrl(String string) {
        string = string.substring(0, string.lastIndexOf("/"));
        string = string.substring(0, string.lastIndexOf("/"));
        string = string.substring(0, string.lastIndexOf("/"));
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse;
        block3: {
            block2: {
                block1: {
                    wMSResponse = new WMSResponse();
                    if (ConfigBase.inTradeShowMode) break block1;
                    if (!this.removeNode(Severity.valueOf(1694 / 246, ")Ugf~$_yo}ddb@`gsvuj5Hh|lkuqQwv`gjSZ~yilcAq|w.3necj|{vR|sz=f\u001f"))) break block2;
                    break block3;
                }
                ConfigBase.log.warn((Object)(Severity.valueOf(21 + 106, "\rERV#EUO=(Mogiygaw1Agugbbh9Ionx\u007fr )") + this.getStringVariable(Utils.lastIndexOf("t|{ojaCobu", 63 * 25)) + Severity.valueOf(415 / 79, ",<'Ag*\u007f~ljj0bz|c5{x||4;<Sqk egoaqoio)Y\u007fm\u007fzz`1Agfpwz6")));
                wMSResponse.success = true;
                wMSResponse.message = Severity.valueOf(184 / 33, "Ackm}oo");
                return wMSResponse;
            }
            wMSResponse.message = Utils.lastIndexOf("Je~`i.a\u007fe2wqysc}9uyvx}k", 51 * 51);
            return wMSResponse;
        }
        wMSResponse.success = true;
        return wMSResponse;
    }

    public static StartupStreamConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(24 + 119, "yx~ag"), string);
        hashMap.put(Severity.valueOf(209 / 36, "vrumhgEm`k"), string2);
        String string3 = StartupStreamConfig.getUrl(hashMap, StartupStreamConfig.class);
        return (StartupStreamConfig)StartupStreamConfig.getObjectFromREST(string3, StartupStreamConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(StartupStreamConfig startupStreamConfig) {
        return this.streamName.compareTo(startupStreamConfig.streamName);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        if (object.getClass() == StartupStreamConfig.class) {
            boolean bl = this.streamName.equals(((StartupStreamConfig)object).streamName);
            bl &= this.applicationName.equals(((StartupStreamConfig)object).applicationName);
            return bl &= this.instance.equals(((StartupStreamConfig)object).instance);
        }
        if (object.getClass() != String.class) return false;
        return this.streamName.equals((String)object);
    }
}

